/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.check;

import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.HttpClientFactory;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.CheckInList;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.ItemVariation;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.OrderSyncAdapter;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Condition;
import io.requery.query.Result;
import io.requery.query.WhereAndOr;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020\u001aJ\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0!2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u00100\u001a\u000201H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Leu/pretix/libpretixsync/check/OnlineCheckProvider;", "Leu/pretix/libpretixsync/check/TicketCheckProvider;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "httpClientFactory", "Leu/pretix/libpretixsync/api/HttpClientFactory;", "dataStore", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "fileStore", "Leu/pretix/libpretixsync/sync/FileStorage;", "listId", "", "(Leu/pretix/libpretixsync/config/ConfigStore;Leu/pretix/libpretixsync/api/HttpClientFactory;Lio/requery/BlockingEntityStore;Leu/pretix/libpretixsync/sync/FileStorage;J)V", "api", "Leu/pretix/libpretixsync/api/PretixApi;", "getApi", "()Leu/pretix/libpretixsync/api/PretixApi;", "setApi", "(Leu/pretix/libpretixsync/api/PretixApi;)V", "getFileStore", "()Leu/pretix/libpretixsync/sync/FileStorage;", "parser", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "check", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckResult;", "ticketid", "", "ticketid_", "answers", "", "Leu/pretix/libpretixsync/db/Answer;", "ignore_unpaid", "", "with_badge_data", "type", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;", "getSentry", "search", "Leu/pretix/libpretixsync/check/TicketCheckProvider$SearchResult;", "query", "page", "", "setSentry", "", "status", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "Companion", "libpretixsync"})
public final class OnlineCheckProvider
implements TicketCheckProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigStore config;
    @NotNull
    private final FileStorage fileStore;
    @NotNull
    private PretixApi api;
    @NotNull
    private SentryInterface sentry;
    @NotNull
    private final BlockingEntityStore<Persistable> dataStore;
    private final long listId;
    private final DateTimeFormatter parser;

    public OnlineCheckProvider(@NotNull ConfigStore config, @Nullable HttpClientFactory httpClientFactory, @NotNull BlockingEntityStore<Persistable> dataStore, @NotNull FileStorage fileStore, long listId) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(dataStore, "dataStore");
        Intrinsics.checkNotNullParameter(fileStore, "fileStore");
        this.config = config;
        this.fileStore = fileStore;
        this.parser = ISODateTimeFormat.dateTimeParser();
        this.api = PretixApi.Companion.fromConfig(this.config, httpClientFactory);
        this.sentry = new DummySentryImplementation();
        this.listId = listId;
        this.dataStore = dataStore;
    }

    @NotNull
    public final FileStorage getFileStore() {
        return this.fileStore;
    }

    @NotNull
    protected final PretixApi getApi() {
        return this.api;
    }

    protected final void setApi(@NotNull PretixApi pretixApi) {
        Intrinsics.checkNotNullParameter(pretixApi, "<set-?>");
        this.api = pretixApi;
    }

    @NotNull
    public final SentryInterface getSentry() {
        return this.sentry;
    }

    @Override
    public void setSentry(@NotNull SentryInterface sentry) {
        Intrinsics.checkNotNullParameter(sentry, "sentry");
        this.sentry = sentry;
        this.api.setSentry(sentry);
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull String ticketid_, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean with_badge_data, @NotNull TicketCheckProvider.CheckInType type2) {
        Intrinsics.checkNotNullParameter(ticketid_, "ticketid_");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        CharSequence charSequence = ticketid_;
        Object object = new Regex("[\\p{C}]");
        String string = "\ufffd";
        boolean bl = false;
        String ticketid = ((Regex)object).replace(charSequence, string);
        this.sentry.addBreadcrumb("provider.check", "started");
        object = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)this.listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)this.config.getEventSlug()))).get()).firstOrNull();
        if (object == null) {
            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not found");
        }
        Object list = object;
        try {
            TicketCheckProvider.CheckResult res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR);
            res.setScanType(type2);
            String string2 = null;
            String string3 = type2.toString();
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
            PretixApi.ApiResponse responseObj = this.api.redeem(ticketid, string2, false, null, answers, this.listId, ignore_unpaid, with_badge_data, string5);
            if (responseObj.getResponse().code() == 404) {
                res.setType(TicketCheckProvider.CheckResult.Type.INVALID);
            } else {
                int i2;
                JSONObject jSONObject = responseObj.getData();
                Intrinsics.checkNotNull(jSONObject);
                JSONObject response = jSONObject;
                String status = response.getString("status");
                if (Intrinsics.areEqual("ok", status)) {
                    res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                } else if (Intrinsics.areEqual("incomplete", status)) {
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    List required_answers = new ArrayList();
                    int n = 0;
                    int n2 = response.getJSONArray("questions").length();
                    if (n < n2) {
                        do {
                            i2 = n++;
                            JSONObject q = response.getJSONArray("questions").getJSONObject(i2);
                            Question question = new Question();
                            question.setServer_id(q.getLong("id"));
                            question.setRequired(q.getBoolean("required"));
                            question.setPosition(q.getLong("position"));
                            question.setJson_data(q.toString());
                            required_answers.add(new TicketCheckProvider.RequiredAnswer(question, ""));
                        } while (n < n2);
                    }
                    res.setRequiredAnswers(required_answers);
                } else {
                    String reason = response.optString("reason");
                    if (Intrinsics.areEqual("already_redeemed", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.USED);
                    } else if (Intrinsics.areEqual("unknown_ticket", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.INVALID);
                    } else if (Intrinsics.areEqual("canceled", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.CANCELED);
                    } else if (Intrinsics.areEqual("rules", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                    } else if (Intrinsics.areEqual("revoked", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.REVOKED);
                    } else if (Intrinsics.areEqual("unpaid", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.UNPAID);
                        res.setCheckinAllowed(((CheckInList)list).include_pending && response.has("position") && Intrinsics.areEqual(response.getJSONObject("position").optString("order__status", "n"), "n"));
                    } else if (Intrinsics.areEqual("product", reason)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.PRODUCT);
                    }
                    if (response.has("reason_explanation") && !response.isNull("reason_explanation")) {
                        res.setReasonExplanation(response.getString("reason_explanation"));
                    }
                }
                if (response.has("position")) {
                    JSONObject posjson = response.getJSONObject("position");
                    Item item = (Item)((Result)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.eq((Object)posjson.getLong("item"))).get()).firstOrNull();
                    if (item != null) {
                        ItemVariation iv;
                        res.setTicket(item.getInternalName());
                        if (posjson.optLong("variation", 0L) > 0L && (iv = item.getVariation(posjson.getLong("variation"))) != null) {
                            res.setVariation(iv.getStringValue());
                        }
                    }
                    if (!posjson.isNull("attendee_name")) {
                        res.setAttendee_name(posjson.optString("attendee_name"));
                    }
                    if (!posjson.isNull("seat")) {
                        res.setSeat(posjson.getJSONObject("seat").getString("name"));
                    }
                    res.setOrderCode(posjson.optString("order"));
                    res.setPositionId(posjson.optLong("positionid"));
                    res.setPosition(posjson);
                    JSONArray checkins = posjson.getJSONArray("checkins");
                    i2 = 0;
                    int q = checkins.length();
                    if (i2 < q) {
                        do {
                            int i3;
                            JSONObject ci;
                            if ((ci = checkins.getJSONObject(i3 = i2++)).getLong("list") != this.listId) continue;
                            res.setFirstScanned(this.parser.parseDateTime(ci.getString("datetime")).toDate());
                        } while (i2 < q);
                    }
                    try {
                        JSONObject pdfdata;
                        if (posjson.has("pdf_data") && (pdfdata = posjson.getJSONObject("pdf_data")).has("images")) {
                            JSONObject images = pdfdata.getJSONObject("images");
                            new OrderSyncAdapter(this.dataStore, this.fileStore, this.config.getEventSlug(), this.config.getSubEventId(), true, false, this.api, null).updatePdfImages(posjson.getLong("id"), images);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                res.setRequireAttention(response.optBoolean("require_attention", false));
            }
            object = res;
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            TicketCheckProvider.CheckResult cr = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Invalid server response");
            if (e.getCause() != null) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull(throwable);
                cr.setTicket(throwable.getMessage());
            }
            object = cr;
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.check", Intrinsics.stringPlus("API Error: ", e.getMessage()));
            TicketCheckProvider.CheckResult cr = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage());
            if (e.getCause() != null) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull(throwable);
                cr.setTicket(throwable.getMessage());
            }
            object = cr;
        }
        return object;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull String ticketid) {
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        return this.check(ticketid, new ArrayList(), false, true, TicketCheckProvider.CheckInType.ENTRY);
    }

    @Override
    @NotNull
    public List<TicketCheckProvider.SearchResult> search(@NotNull String query, int page) throws CheckException {
        List list;
        Intrinsics.checkNotNullParameter(query, "query");
        this.sentry.addBreadcrumb("provider.search", "started");
        try {
            PretixApi.ApiResponse response = this.api.search(this.listId, query, page);
            JSONObject jSONObject = response.getData();
            Intrinsics.checkNotNull(jSONObject);
            JSONArray resdata = jSONObject.getJSONArray("results");
            List results = new ArrayList();
            int n = 0;
            int n2 = resdata.length();
            if (n < n2) {
                do {
                    int i2 = n++;
                    JSONObject res = resdata.getJSONObject(i2);
                    TicketCheckProvider.SearchResult sr = new TicketCheckProvider.SearchResult();
                    Item item = (Item)((Result)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.eq((Object)res.getLong("item"))).get()).firstOrNull();
                    if (item != null) {
                        ItemVariation iv;
                        sr.setTicket(item.getInternalName());
                        if (res.optLong("variation", 0L) > 0L && (iv = item.getVariation(res.getLong("variation"))) != null) {
                            sr.setVariation(iv.getStringValue());
                        }
                    }
                    if (!res.isNull("attendee_name")) {
                        sr.setAttendee_name(res.optString("attendee_name"));
                    }
                    if (!res.isNull("seat")) {
                        sr.setSeat(res.getJSONObject("seat").getString("name"));
                    }
                    sr.setOrderCode(res.optString("order"));
                    sr.setPositionId(res.optLong("positionid"));
                    sr.setSecret(res.optString("secret"));
                    sr.setRedeemed(res.getJSONArray("checkins").length() > 0);
                    String status = res.optString("order__status", "p");
                    if (Intrinsics.areEqual(status, "p")) {
                        sr.setStatus(TicketCheckProvider.SearchResult.Status.PAID);
                    } else if (Intrinsics.areEqual(status, "n")) {
                        sr.setStatus(TicketCheckProvider.SearchResult.Status.PENDING);
                    } else {
                        sr.setStatus(TicketCheckProvider.SearchResult.Status.CANCELED);
                    }
                    sr.setRequireAttention(res.optBoolean("require_attention", false));
                    sr.setPosition(res);
                    results.add(sr);
                } while (n < n2);
            }
            list = results;
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            throw new CheckException("Unknown server response", e);
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", Intrinsics.stringPlus("API Error: ", e.getMessage()));
            throw new CheckException(e.getMessage(), e);
        }
        return list;
    }

    @Override
    @NotNull
    public TicketCheckProvider.StatusResult status() throws CheckException {
        TicketCheckProvider.StatusResult statusResult;
        this.sentry.addBreadcrumb("provider.status", "started");
        try {
            PretixApi.ApiResponse response = this.api.status(this.listId);
            JSONObject jSONObject = response.getData();
            Intrinsics.checkNotNull(jSONObject);
            TicketCheckProvider.StatusResult r = Companion.parseStatusResponse(jSONObject);
            CheckInList list = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)this.listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)this.config.getEventSlug()))).get()).firstOrNull();
            if (list != null) {
                TicketCheckProvider.StatusResult statusResult2 = r;
                statusResult2.setEventName(statusResult2.getEventName() + " \u2013 " + list.name);
            }
            statusResult = r;
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            throw new CheckException("Unknown server response", e);
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", Intrinsics.stringPlus("API Error: ", e.getMessage()));
            throw new CheckException(e.getMessage(), e);
        }
        return statusResult;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Leu/pretix/libpretixsync/check/OnlineCheckProvider$Companion;", "", "()V", "parseStatusResponse", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "response", "Lorg/json/JSONObject;", "libpretixsync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TicketCheckProvider.StatusResult parseStatusResponse(@NotNull JSONObject response) throws JSONException {
            Intrinsics.checkNotNullParameter(response, "response");
            List items = new ArrayList();
            int itemcount = response.getJSONArray("items").length();
            int n = 0;
            if (n < itemcount) {
                do {
                    int i2 = n++;
                    JSONObject item = response.getJSONArray("items").getJSONObject(i2);
                    List variations = new ArrayList();
                    int n2 = 0;
                    int varcount = item.getJSONArray("variations").length();
                    if (n2 < varcount) {
                        do {
                            int j = n2++;
                            JSONObject var = item.getJSONArray("variations").getJSONObject(j);
                            variations.add(new TicketCheckProvider.StatusResultItemVariation(var.getLong("id"), var.getString("value"), var.getInt("position_count"), var.getInt("checkin_count")));
                        } while (n2 < varcount);
                    }
                    items.add(new TicketCheckProvider.StatusResultItem(item.getLong("id"), item.getString("name"), item.getInt("position_count"), item.getInt("checkin_count"), variations, item.getBoolean("admission")));
                } while (n < itemcount);
            }
            return new TicketCheckProvider.StatusResult(response.getJSONObject("event").getString("name"), response.getInt("position_count"), response.getInt("checkin_count"), response.has("inside_count") ? Integer.valueOf(response.optInt("inside_count")) : null, items);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

