/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.net.http.X509TrustManagerExtensions;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.CertificateChainCleaner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/platform/android/Android10CertificateChainCleaner;", "Lokhttp3/internal/tls/CertificateChainCleaner;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "(Ljavax/net/ssl/X509TrustManager;)V", "extensions", "Landroid/net/http/X509TrustManagerExtensions;", "getExtensions", "()Landroid/net/http/X509TrustManagerExtensions;", "clean", "", "Ljava/security/cert/Certificate;", "chain", "hostname", "", "equals", "", "other", "", "hashCode", "", "okhttp"})
public final class Android10CertificateChainCleaner
extends CertificateChainCleaner {
    @NotNull
    private final X509TrustManagerExtensions extensions;
    private final X509TrustManager trustManager;

    @NotNull
    public final X509TrustManagerExtensions getExtensions() {
        return this.extensions;
    }

    @Override
    @NotNull
    public List<Certificate> clean(@NotNull List<? extends Certificate> chain, @NotNull String hostname) throws SSLPeerUnverifiedException {
        Intrinsics.checkParameterIsNotNull(chain, "chain");
        Intrinsics.checkParameterIsNotNull(hostname, "hostname");
        Collection $this$toTypedArray$iv = chain;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        if (x509CertificateArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        X509Certificate[] certificates = x509CertificateArray;
        try {
            List list = this.extensions.checkServerTrusted(certificates, "RSA", hostname);
            Intrinsics.checkExpressionValueIsNotNull(list, "extensions.checkServerTr\u2026ficates, \"RSA\", hostname)");
            return list;
        }
        catch (CertificateException ce) {
            SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(ce.getMessage());
            boolean bl = false;
            boolean bl2 = false;
            SSLPeerUnverifiedException $this$apply = sSLPeerUnverifiedException;
            boolean bl3 = false;
            $this$apply.initCause(ce);
            throw (Throwable)sSLPeerUnverifiedException;
        }
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Android10CertificateChainCleaner && ((Android10CertificateChainCleaner)other).trustManager == this.trustManager;
    }

    public int hashCode() {
        return System.identityHashCode(this.trustManager);
    }

    public Android10CertificateChainCleaner(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkParameterIsNotNull(trustManager, "trustManager");
        this.trustManager = trustManager;
        this.extensions = new X509TrustManagerExtensions(this.trustManager);
    }
}

