/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.check.QuestionType;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.QuestionLike;
import eu.pretix.libpretixsync.db.QuestionOption;
import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.utils.I18nString;
import io.requery.CascadeAction;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.JunctionTable;
import io.requery.Key;
import io.requery.ManyToMany;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractQuestion
extends QuestionLike
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public String event_slug;
    public Long server_id;
    public boolean required;
    public Long position;
    @Column(definition="TEXT")
    public String json_data;
    @ManyToMany(cascade={CascadeAction.NONE})
    @JunctionTable
    List<Item> items;

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    @Override
    public boolean requiresAnswer() {
        return this.required;
    }

    @Override
    public String getIdentifier() {
        try {
            return this.getJSON().getString("identifier");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "<invalid>";
        }
    }

    @Override
    public String getQuestion() {
        try {
            return I18nString.toString(this.getJSON().getJSONObject("question"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "<invalid>";
        }
    }

    public boolean isAskDuringCheckin() {
        try {
            return this.getJSON().getBoolean("ask_during_checkin");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public QuestionType getType() {
        try {
            return QuestionType.valueOf(this.getJSON().getString("type"));
        }
        catch (IllegalArgumentException | JSONException e) {
            return QuestionType.T;
        }
    }

    @Override
    public List<QuestionOption> getOptions() {
        ArrayList<QuestionOption> opts = new ArrayList<QuestionOption>();
        try {
            JSONArray arr = this.getJSON().getJSONArray("options");
            for (int i2 = 0; i2 < arr.length(); ++i2) {
                String answ;
                JSONObject oobj = arr.getJSONObject(i2);
                try {
                    answ = I18nString.toString(oobj.getJSONObject("answer"));
                }
                catch (JSONException e) {
                    answ = oobj.getString("answer");
                }
                opts.add(new QuestionOption(oobj.getLong("id"), oobj.getLong("position"), oobj.getString("identifier"), answ));
            }
            return opts;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

