/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.sql.FieldType;
import io.requery.util.Objects;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseType<T>
implements FieldType<T> {
    private final Class<T> type;
    private final int sqlType;

    protected BaseType(Class<T> type2, int sqlType) {
        this.type = type2;
        this.sqlType = sqlType;
    }

    @Override
    public T read(ResultSet results, int column) throws SQLException {
        T value = this.type.cast(results.getObject(column));
        if (results.wasNull()) {
            return null;
        }
        return value;
    }

    @Override
    public void write(PreparedStatement statement, int index, T value) throws SQLException {
        if (value == null) {
            statement.setNull(index, this.sqlType);
        } else {
            statement.setObject(index, value, this.sqlType);
        }
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public boolean hasLength() {
        return false;
    }

    @Override
    public Integer getDefaultLength() {
        return null;
    }

    @Override
    public abstract Object getIdentifier();

    @Override
    public String getIdentifierSuffix() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldType) {
            FieldType other = (FieldType)obj;
            return Objects.equals(this.getIdentifier(), other.getIdentifier()) && this.getSqlType() == other.getSqlType() && this.hasLength() == other.hasLength() && Objects.equals(this.getIdentifierSuffix(), other.getIdentifierSuffix()) && Objects.equals(this.getDefaultLength(), other.getDefaultLength());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getIdentifier(), this.getSqlType(), this.getDefaultLength(), this.getIdentifierSuffix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIdentifier());
        if (this.hasLength()) {
            sb.append("(");
            sb.append(this.getDefaultLength());
            sb.append(")");
        }
        if (this.getIdentifierSuffix() != null) {
            sb.append(" ");
            sb.append(this.getIdentifierSuffix());
        }
        return sb.toString();
    }
}

