/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.Closing;
import eu.pretix.libpretixsync.db.LocalObject;
import eu.pretix.libpretixsync.db.QueuedOrder;
import eu.pretix.libpretixsync.db.ReceiptLine;
import eu.pretix.libpretixsync.db.ReceiptPayment;
import io.requery.Column;
import io.requery.Entity;
import io.requery.ForeignKey;
import io.requery.Generated;
import io.requery.Key;
import io.requery.ManyToOne;
import io.requery.Nullable;
import io.requery.OneToMany;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractReceipt
implements LocalObject {
    @Generated
    @Key
    public Long id;
    public String event_slug;
    @Column(nullable=false, value="'EUR'")
    public String currency;
    public String order_code;
    @Nullable
    public String chosen_cart_id;
    @Nullable
    public Long server_id;
    @Column(value="false")
    public boolean open;
    @Nullable
    public Date datetime_opened;
    @Nullable
    public Date datetime_closed;
    public String payment_type;
    public String fiscalisation_data;
    public String fiscalisation_text;
    public String fiscalisation_qr;
    @Nullable
    public String additional_text;
    @Column(nullable=true)
    public String email_to;
    @OneToMany
    public List<ReceiptLine> lines;
    @OneToMany
    public List<ReceiptPayment> payments;
    @ForeignKey
    @ManyToOne
    public Closing closing;
    public Long cashier_numericid;
    public String cashier_userid;
    public String cashier_name;
    public boolean canceled;
    @Column(value="false")
    public boolean started;
    public String payment_data;
    @Column(nullable=false, value="false")
    public boolean printed;
    @Column(nullable=false, value="false")
    public boolean training;
    @OneToMany
    public List<QueuedOrder> queuedorders;

    @Override
    public JSONObject toJSON() throws JSONException {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        JSONObject jo = new JSONObject();
        jo.put("receipt_id", this.id);
        jo.put("event", this.event_slug != null ? this.event_slug : JSONObject.NULL);
        jo.put("order", this.order_code != null ? this.order_code : JSONObject.NULL);
        jo.put("order_full", this.order_code != null ? this.event_slug.toUpperCase() + "-" + this.order_code : "-");
        jo.put("open", this.open);
        jo.put("payment_type", this.payment_type);
        jo.put("datetime_opened", df.format(this.datetime_opened));
        jo.put("datetime_closed", df.format(this.datetime_closed));
        jo.put("closing_id", this.closing.getId());
        jo.put("canceled", this.canceled);
        jo.put("currency", this.currency);
        jo.put("printed", this.printed);
        jo.put("email_to", this.email_to);
        jo.put("payment_data", this.payment_data == null || this.payment_data.equals("null") || this.payment_data.isEmpty() ? new JSONObject() : new JSONObject(this.payment_data));
        jo.put("fiscalisation_data", this.fiscalisation_data == null || this.fiscalisation_data.equals("null") || this.fiscalisation_data.isEmpty() ? new JSONObject() : new JSONObject(this.fiscalisation_data));
        jo.put("fiscalisation_text", this.fiscalisation_text == null || this.fiscalisation_text.equals("null") || this.fiscalisation_text.isEmpty() ? "" : this.fiscalisation_text);
        jo.put("fiscalisation_qr", this.fiscalisation_qr == null || this.fiscalisation_qr.equals("null") || this.fiscalisation_qr.isEmpty() ? "" : this.fiscalisation_qr);
        jo.put("cashier", this.cashier_numericid);
        jo.put("training", this.training);
        jo.put("additional_text", this.additional_text);
        return jo;
    }
}

