/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.utils.I18nString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemVariation
implements Serializable {
    private Long server_id;
    private BigDecimal price;
    private boolean active;
    private JSONObject description;
    private JSONObject value;
    private Long position;
    private Long available;
    private Long available_number;

    public void setServer_id(Long server_id) {
        this.server_id = server_id;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setDescription(JSONObject description2) {
        this.description = description2;
    }

    public void setValue(JSONObject value) {
        this.value = value;
    }

    public void setPosition(Long position) {
        this.position = position;
    }

    public Long getServer_id() {
        return this.server_id;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public boolean isActive() {
        return this.active;
    }

    public JSONObject getDescription() {
        return this.description;
    }

    public JSONObject getValue() {
        return this.value;
    }

    public String getStringValue() {
        return I18nString.toString(this.getValue());
    }

    public Long getPosition() {
        return this.position;
    }

    public Long getAvailable() {
        return this.available;
    }

    public void setAvailable(Long available) {
        this.available = available;
    }

    public Long getAvailable_number() {
        return this.available_number;
    }

    public void setAvailable_number(Long available_number) {
        this.available_number = available_number;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("server_id", this.server_id);
            jsonObject.put("price", this.price.toPlainString());
            jsonObject.put("active", this.active);
            jsonObject.put("description", this.description);
            jsonObject.put("value", this.value);
            jsonObject.put("position", this.position);
            jsonObject.put("available", this.available);
            jsonObject.put("available_number", this.available_number);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        out.writeObject(jsonObject.toString());
        out.close();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String json2 = (String)in.readObject();
        in.close();
        try {
            JSONObject jsonObject = new JSONObject(json2);
            this.server_id = jsonObject.getLong("server_id");
            this.price = new BigDecimal(jsonObject.getString("price"));
            this.active = jsonObject.getBoolean("active");
            this.description = jsonObject.getJSONObject("description");
            this.value = jsonObject.getJSONObject("value");
            this.position = jsonObject.getLong("position");
            this.available = !jsonObject.isNull("available") ? Long.valueOf(jsonObject.optLong("available")) : null;
            this.available_number = !jsonObject.isNull("available_number") ? Long.valueOf(jsonObject.optLong("available_number")) : null;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
    }
}

