/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.Javalin;
import io.javalin.core.security.BasicAuthCredentials;
import io.javalin.core.validation.BodyValidator;
import io.javalin.core.validation.Validator;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.HandlerType;
import io.javalin.http.RedirectResponse;
import io.javalin.http.UploadedFile;
import io.javalin.http.util.ContextUtil;
import io.javalin.http.util.CookieStore;
import io.javalin.http.util.MultipartUtil;
import io.javalin.http.util.SeekableWriter;
import io.javalin.plugin.json.JavalinJson;
import io.javalin.plugin.rendering.JavalinRenderer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u001f\u0010=\u001a\u0002H>\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\b\u00a2\u0006\u0002\u0010@J\u001b\u0010A\u001a\u0004\u0018\u0001H>\"\u0004\b\u0000\u0010>2\u0006\u0010B\u001a\u00020\u0011\u00a2\u0006\u0002\u0010CJ\u0018\u0010A\u001a\u00020D2\u0006\u0010B\u001a\u00020\u00112\b\u0010E\u001a\u0004\u0018\u00010\u0001J\u001a\u0010F\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001H>0\u0007\"\u0004\b\u0000\u0010>J\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020%J\u0006\u0010\n\u001a\u00020\u0011J\u001a\u0010\n\u001a\u0002H>\"\n\b\u0000\u0010>\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010JJ\u0006\u0010K\u001a\u00020\u000bJ\u001f\u0010L\u001a\u0002H>\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\b\u00a2\u0006\u0002\u0010@J\u0006\u0010M\u001a\u000206J\u001b\u0010N\u001a\b\u0012\u0004\u0012\u0002H>0O\"\n\b\u0000\u0010>\u0018\u0001*\u00020\u0001H\u0086\bJ \u0010N\u001a\b\u0012\u0004\u0012\u0002H>0O\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\bJ\u0006\u0010P\u001a\u00020DJ\u0006\u0010Q\u001a\u00020RJ\b\u0010S\u001a\u0004\u0018\u00010\u0011J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\u0011J\u0006\u0010T\u001a\u00020\u0011J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010U\u001a\u00020VJ\u0010\u0010U\u001a\u0004\u0018\u00010\u00112\u0006\u0010W\u001a\u00020\u0011J\"\u0010U\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u00112\u0006\u0010E\u001a\u00020\u00112\b\b\u0002\u0010X\u001a\u00020RH\u0007J\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0007J\u0019\u0010\u0015\u001a\u0002H>\"\u0004\b\u0000\u0010>2\u0006\u0010B\u001a\u00020\u0011\u00a2\u0006\u0002\u0010CJ\u0016\u0010\u0015\u001a\u00020D2\u0006\u0010B\u001a\u00020\u00112\u0006\u0010E\u001a\u00020\u0001J\u0006\u0010\u001b\u001a\u00020\u0011J6\u0010Z\u001a\b\u0012\u0004\u0012\u0002H>0[\"\u0004\b\u0000\u0010>2\u0006\u0010B\u001a\u00020\u00112\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\b2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u0011H\u0007J\u001e\u0010Z\u001a\u0004\u0018\u00010\u00112\u0006\u0010B\u001a\u00020\u00112\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u0011H\u0007J/\u0010Z\u001a\b\u0012\u0004\u0012\u0002H>0[\"\n\b\u0000\u0010>\u0018\u0001*\u00020\u00012\u0006\u0010B\u001a\u00020\u00112\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u0011H\u0086\bJ\u0018\u0010]\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0011070\u0007J\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020\u0011072\u0006\u0010B\u001a\u00020\u0011J\u0006\u0010_\u001a\u00020\u0011J\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010`\u001a\u0004\u0018\u00010\u00112\u0006\u0010`\u001a\u00020\u0011J#\u0010`\u001a\b\u0012\u0004\u0012\u0002H>0[\"\n\b\u0000\u0010>\u0018\u0001*\u00020\u00012\u0006\u0010`\u001a\u00020\u0011H\u0086\bJ(\u0010`\u001a\b\u0012\u0004\u0012\u0002H>0[\"\u0004\b\u0000\u0010>2\u0006\u0010`\u001a\u00020\u00112\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\bJ\u0016\u0010`\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u00112\u0006\u0010E\u001a\u00020\u0011J\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0007J\b\u0010b\u001a\u0004\u0018\u00010\u0011J\u000e\u0010c\u001a\u00020\u00002\u0006\u0010c\u001a\u00020\u0011J\u0006\u0010d\u001a\u00020\u0011J\u0006\u0010e\u001a\u00020%J\u0006\u0010f\u001a\u00020%J\u0012\u0010g\u001a\u00020\u00002\n\u0010h\u001a\u0006\u0012\u0002\b\u000304J\u000e\u0010g\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u0001J\u0006\u0010+\u001a\u00020\u0011J\u0006\u0010j\u001a\u00020\u0011J\u0006\u0010k\u001a\u00020\u0011J\u000e\u0010l\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u0011J#\u0010l\u001a\b\u0012\u0004\u0012\u0002H>0[\"\n\b\u0000\u0010>\u0018\u0001*\u00020\u00012\u0006\u0010B\u001a\u00020\u0011H\u0086\bJ(\u0010l\u001a\b\u0012\u0004\u0012\u0002H>0[\"\u0004\b\u0000\u0010>2\u0006\u0010B\u001a\u00020\u00112\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\bJ\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0007J\u0006\u0010m\u001a\u00020RJ\u0006\u0010n\u001a\u00020\u0011J6\u0010o\u001a\b\u0012\u0004\u0012\u0002H>0[\"\u0004\b\u0000\u0010>2\u0006\u0010B\u001a\u00020\u00112\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\b2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u0011H\u0007J\u001e\u0010o\u001a\u0004\u0018\u00010\u00112\u0006\u0010B\u001a\u00020\u00112\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u0011H\u0007J/\u0010o\u001a\b\u0012\u0004\u0012\u0002H>0[\"\n\b\u0000\u0010>\u0018\u0001*\u00020\u00012\u0006\u0010B\u001a\u00020\u00112\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u0011H\u0086\bJ\u0018\u0010p\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0011070\u0007J\u0014\u0010q\u001a\b\u0012\u0004\u0012\u00020\u0011072\u0006\u0010B\u001a\u00020\u0011J\b\u0010r\u001a\u0004\u0018\u00010\u0011J\u001a\u0010s\u001a\u00020D2\u0006\u0010t\u001a\u00020\u00112\b\b\u0002\u0010u\u001a\u00020RH\u0007J\u001a\u0010v\u001a\u00020D2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010E\u001a\u00020\u0001J\u001c\u0010w\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u00112\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u0011H\u0007J(\u0010x\u001a\u00020\u00002\u0006\u0010y\u001a\u00020\u00112\u0016\b\u0002\u0010z\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007H\u0007J\u0010\u0010{\u001a\n }*\u0004\u0018\u00010|0|H\u0002J\u000e\u0010~\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u0012\u0010~\u001a\u00020\u00002\n\u0010h\u001a\u0006\u0012\u0002\b\u000304J\u000e\u0010~\u001a\u00020\u00002\u0006\u0010\u007f\u001a\u00020\u000bJ\u000f\u0010~\u001a\u00020\u00002\u0007\u0010\u0080\u0001\u001a\u00020\u0011J\f\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u000104J\b\u00105\u001a\u0004\u0018\u000106J\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0011J\u0007\u0010\u0081\u0001\u001a\u00020\u0011J\u0018\u0010\u0082\u0001\u001a\u00020D2\u0007\u0010\u0083\u0001\u001a\u0002062\u0006\u0010S\u001a\u00020\u0011J\u001c\u0010\u0084\u0001\u001a\u0004\u0018\u0001H>\"\u0004\b\u0000\u0010>2\u0006\u0010B\u001a\u00020\u0011\u00a2\u0006\u0002\u0010CJ\u0019\u0010\u0084\u0001\u001a\u00020D2\u0006\u0010B\u001a\u00020\u00112\b\u0010E\u001a\u0004\u0018\u00010\u0001J\u001b\u0010\u0085\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001H>0\u0007\"\u0004\b\u0000\u0010>J\u0012\u0010\u0086\u0001\u001a\u0004\u0018\u00010\u00112\u0007\u0010\u0087\u0001\u001a\u00020RJ\r\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u001107J\u0007\u0010\u0089\u0001\u001a\u00020RJ\u0010\u0010\u0089\u0001\u001a\u00020\u00002\u0007\u0010\u008a\u0001\u001a\u00020RJ\u0013\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\u0007\u0010\u008d\u0001\u001a\u00020\u0011J\u000e\u0010\u008e\u0001\u001a\t\u0012\u0005\u0012\u00030\u008c\u000107J\u0017\u0010\u008e\u0001\u001a\t\u0012\u0005\u0012\u00030\u008c\u0001072\u0007\u0010\u008d\u0001\u001a\u00020\u0011J\u0007\u0010\u008f\u0001\u001a\u00020\u0011J \u0010\u0090\u0001\u001a\u0002H>\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0\b\u00a2\u0006\u0002\u0010@J\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u0011R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R&\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00118@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u001eR&\u0010 \u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001f8@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R&\u0010&\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020%8@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R&\u0010+\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00118@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0013\"\u0004\b-\u0010\u001eR>\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00072\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00078@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u00108\u001a\b\u0012\u0004\u0012\u00020\u0011072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u0011078@@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006\u0092\u0001"}, d2={"Lio/javalin/http/Context;", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "res", "Ljavax/servlet/http/HttpServletResponse;", "appAttributes", "", "Ljava/lang/Class;", "(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Ljava/util/Map;)V", "body", "", "getBody", "()[B", "body$delegate", "Lkotlin/Lazy;", "characterEncoding", "", "getCharacterEncoding", "()Ljava/lang/String;", "characterEncoding$delegate", "cookieStore", "Lio/javalin/http/util/CookieStore;", "getCookieStore", "()Lio/javalin/http/util/CookieStore;", "cookieStore$delegate", "<set-?>", "endpointHandlerPath", "getEndpointHandlerPath$javalin", "setEndpointHandlerPath$javalin", "(Ljava/lang/String;)V", "Lio/javalin/http/HandlerType;", "handlerType", "getHandlerType$javalin", "()Lio/javalin/http/HandlerType;", "setHandlerType$javalin", "(Lio/javalin/http/HandlerType;)V", "", "inExceptionHandler", "getInExceptionHandler$javalin", "()Z", "setInExceptionHandler$javalin", "(Z)V", "matchedPath", "getMatchedPath$javalin", "setMatchedPath$javalin", "pathParamMap", "getPathParamMap$javalin", "()Ljava/util/Map;", "setPathParamMap$javalin", "(Ljava/util/Map;)V", "resultFuture", "Ljava/util/concurrent/CompletableFuture;", "resultStream", "Ljava/io/InputStream;", "", "splatList", "getSplatList$javalin", "()Ljava/util/List;", "setSplatList$javalin", "(Ljava/util/List;)V", "appAttribute", "T", "clazz", "(Ljava/lang/Class;)Ljava/lang/Object;", "attribute", "key", "(Ljava/lang/String;)Ljava/lang/Object;", "", "value", "attributeMap", "basicAuthCredentials", "Lio/javalin/core/security/BasicAuthCredentials;", "basicAuthCredentialsExist", "()Ljava/lang/Object;", "bodyAsBytes", "bodyAsClass", "bodyAsInputStream", "bodyValidator", "Lio/javalin/core/validation/BodyValidator;", "clearCookieStore", "contentLength", "", "contentType", "contextPath", "cookie", "Ljavax/servlet/http/Cookie;", "name", "maxAge", "cookieMap", "formParam", "Lio/javalin/core/validation/Validator;", "default", "formParamMap", "formParams", "fullUrl", "header", "headerMap", "host", "html", "ip", "isMultipart", "isMultipartFormData", "json", "future", "obj", "method", "path", "pathParam", "port", "protocol", "queryParam", "queryParamMap", "queryParams", "queryString", "redirect", "location", "httpStatusCode", "register", "removeCookie", "render", "filePath", "model", "responseCharset", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "result", "resultBytes", "resultString", "scheme", "seekableStream", "inputStream", "sessionAttribute", "sessionAttributeMap", "splat", "splatNr", "splats", "status", "statusCode", "uploadedFile", "Lio/javalin/http/UploadedFile;", "fileName", "uploadedFiles", "url", "use", "userAgent", "javalin"})
public class Context {
    private boolean inExceptionHandler;
    @NotNull
    private String matchedPath;
    @NotNull
    private String endpointHandlerPath;
    @NotNull
    private Map<String, String> pathParamMap;
    @NotNull
    private HandlerType handlerType;
    @NotNull
    private List<String> splatList;
    private final Lazy cookieStore$delegate;
    private final Lazy characterEncoding$delegate;
    private InputStream resultStream;
    private CompletableFuture<?> resultFuture;
    private final Lazy body$delegate;
    @JvmField
    @NotNull
    public final HttpServletRequest req;
    @JvmField
    @NotNull
    public final HttpServletResponse res;
    private final Map<Class<?>, Object> appAttributes;

    public final /* synthetic */ boolean getInExceptionHandler$javalin() {
        return this.inExceptionHandler;
    }

    public final /* synthetic */ void setInExceptionHandler$javalin(boolean bl) {
        this.inExceptionHandler = bl;
    }

    @NotNull
    public final /* synthetic */ String getMatchedPath$javalin() {
        return this.matchedPath;
    }

    public final /* synthetic */ void setMatchedPath$javalin(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.matchedPath = string;
    }

    @NotNull
    public final /* synthetic */ String getEndpointHandlerPath$javalin() {
        return this.endpointHandlerPath;
    }

    public final /* synthetic */ void setEndpointHandlerPath$javalin(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        this.endpointHandlerPath = string;
    }

    @NotNull
    public final /* synthetic */ Map<String, String> getPathParamMap$javalin() {
        return this.pathParamMap;
    }

    public final /* synthetic */ void setPathParamMap$javalin(@NotNull Map<String, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, "<set-?>");
        this.pathParamMap = map2;
    }

    @NotNull
    public final /* synthetic */ HandlerType getHandlerType$javalin() {
        return this.handlerType;
    }

    public final /* synthetic */ void setHandlerType$javalin(@NotNull HandlerType handlerType) {
        Intrinsics.checkParameterIsNotNull((Object)handlerType, "<set-?>");
        this.handlerType = handlerType;
    }

    @NotNull
    public final /* synthetic */ List<String> getSplatList$javalin() {
        return this.splatList;
    }

    public final /* synthetic */ void setSplatList$javalin(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, "<set-?>");
        this.splatList = list;
    }

    private final CookieStore getCookieStore() {
        Lazy lazy = this.cookieStore$delegate;
        Context context = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CookieStore)lazy.getValue();
    }

    private final String getCharacterEncoding() {
        Lazy lazy = this.characterEncoding$delegate;
        Context context = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final byte[] getBody() {
        Lazy lazy = this.body$delegate;
        Context context = this;
        Object var3_3 = null;
        boolean bl = false;
        return (byte[])lazy.getValue();
    }

    public final void register(@NotNull Class<?> clazz, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.req.setAttribute("ctx-ext-" + clazz.getCanonicalName(), value);
    }

    public final <T> T use(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return (T)this.req.getAttribute("ctx-ext-" + clazz.getCanonicalName());
    }

    public final <T> T appAttribute(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return (T)this.appAttributes.get(clazz);
    }

    public final <T> T cookieStore(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        return this.getCookieStore().get(key);
    }

    public final void cookieStore(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.getCookieStore().set(key, value);
        this.cookie(this.getCookieStore().serializeToCookie());
    }

    public final void clearCookieStore() {
        this.getCookieStore().clear();
        Context.removeCookie$default(this, CookieStore.Companion.getCOOKIE_NAME(), null, 2, null);
    }

    @NotNull
    public final String matchedPath() {
        return this.matchedPath;
    }

    @NotNull
    public final String endpointHandlerPath() {
        if (this.handlerType == HandlerType.BEFORE) {
            throw (Throwable)new IllegalStateException("Cannot access the endpoint handler path in a 'BEFORE' handler");
        }
        return this.endpointHandlerPath;
    }

    @NotNull
    public final String body() {
        byte[] byArray = this.bodyAsBytes();
        Charset charset = Charset.forName(this.getCharacterEncoding());
        Intrinsics.checkExpressionValueIsNotNull(charset, "Charset.forName(characterEncoding)");
        Charset charset2 = charset;
        boolean bl = false;
        boolean bl2 = false;
        return new String(byArray, charset2);
    }

    @NotNull
    public final /* synthetic */ <T> T body() {
        int $i$f$body = 0;
        Intrinsics.reifiedOperationMarker(4, "T");
        return (T)this.bodyAsClass(Object.class);
    }

    @NotNull
    public final byte[] bodyAsBytes() {
        return this.getBody();
    }

    public final <T> T bodyAsClass(@NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return this.bodyValidator(clazz).get();
    }

    @NotNull
    public final InputStream bodyAsInputStream() {
        byte[] byArray = this.getBody();
        boolean bl = false;
        return new ByteArrayInputStream(byArray);
    }

    @NotNull
    public final <T> BodyValidator<T> bodyValidator(@NotNull Class<T> clazz) {
        BodyValidator<T> bodyValidator;
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        try {
            bodyValidator = new BodyValidator<T>(JavalinJson.fromJson(this.body(), clazz), "Request body as " + clazz.getSimpleName());
        }
        catch (Exception e) {
            Logger logger = Javalin.log;
            if (logger != null) {
                logger.info("Couldn't deserialize body to " + clazz.getSimpleName(), e);
            }
            throw (Throwable)new BadRequestResponse("Couldn't deserialize body to " + clazz.getSimpleName());
        }
        return bodyValidator;
    }

    @NotNull
    public final /* synthetic */ <T> BodyValidator<T> bodyValidator() {
        int $i$f$bodyValidator = 0;
        Intrinsics.reifiedOperationMarker(4, "T");
        return this.bodyValidator(Object.class);
    }

    @Nullable
    public final UploadedFile uploadedFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return CollectionsKt.firstOrNull(this.uploadedFiles(fileName));
    }

    @NotNull
    public final List<UploadedFile> uploadedFiles(@NotNull String fileName) {
        List<UploadedFile> list;
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        if (this.isMultipartFormData()) {
            list = MultipartUtil.INSTANCE.getUploadedFiles(this.req, fileName);
        } else {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<UploadedFile> uploadedFiles() {
        List<UploadedFile> list;
        if (this.isMultipartFormData()) {
            list = MultipartUtil.INSTANCE.getUploadedFiles(this.req);
        } else {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmOverloads
    @Nullable
    public final String formParam(@NotNull String key, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        String string2 = CollectionsKt.firstOrNull(this.formParams(key));
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static /* synthetic */ String formParam$default(Context context, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formParam");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return context.formParam(string, string2);
    }

    @JvmOverloads
    @Nullable
    public final String formParam(@NotNull String key) {
        return Context.formParam$default(this, key, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final <T> Validator<T> formParam(@NotNull String key, @NotNull Class<T> clazz, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return Validator.Companion.create(clazz, this.formParam(key, string), "Form parameter '" + key + "' with value '" + this.formParam(key, string) + '\'', key);
    }

    public static /* synthetic */ Validator formParam$default(Context context, String string, Class clazz, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formParam");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return context.formParam(string, clazz, string2);
    }

    @JvmOverloads
    @NotNull
    public final <T> Validator<T> formParam(@NotNull String key, @NotNull Class<T> clazz) {
        return Context.formParam$default(this, key, clazz, null, 4, null);
    }

    @NotNull
    public final /* synthetic */ <T> Validator<T> formParam(@NotNull String key, @Nullable String string) {
        int $i$f$formParam = 0;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.reifiedOperationMarker(4, "T");
        return this.formParam(key, Object.class, string);
    }

    public static /* synthetic */ Validator formParam$default(Context this_, String key, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formParam");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        boolean $i$f$formParam = false;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.reifiedOperationMarker(4, "T");
        return this_.formParam(key, Object.class, string);
    }

    @NotNull
    public final List<String> formParams(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        List<String> list = this.formParamMap().get(key);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Map<String, List<String>> formParamMap() {
        return this.isMultipartFormData() ? MultipartUtil.INSTANCE.getFieldMap(this.req) : ContextUtil.INSTANCE.splitKeyValueStringAndGroupByKey(this.body(), this.getCharacterEncoding());
    }

    @NotNull
    public final String pathParam(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        return ContextUtil.INSTANCE.pathParamOrThrow(this.pathParamMap, key, this.matchedPath);
    }

    @NotNull
    public final <T> Validator<T> pathParam(@NotNull String key, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return Validator.Companion.create(clazz, this.pathParam(key), "Path parameter '" + key + "' with value '" + this.pathParam(key) + '\'', key);
    }

    @NotNull
    public final /* synthetic */ <T> Validator<T> pathParam(@NotNull String key) {
        int $i$f$pathParam = 0;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.reifiedOperationMarker(4, "T");
        return this.pathParam(key, Object.class);
    }

    @NotNull
    public final Map<String, String> pathParamMap() {
        Map<String, String> map2 = Collections.unmodifiableMap(this.pathParamMap);
        Intrinsics.checkExpressionValueIsNotNull(map2, "Collections.unmodifiableMap(pathParamMap)");
        return map2;
    }

    public final boolean basicAuthCredentialsExist() {
        return ContextUtil.INSTANCE.hasBasicAuthCredentials(this.header("Authorization"));
    }

    @NotNull
    public final BasicAuthCredentials basicAuthCredentials() {
        return ContextUtil.INSTANCE.getBasicAuthCredentials(this.header("Authorization"));
    }

    public final void attribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        this.req.setAttribute(key, value);
    }

    @Nullable
    public final <T> T attribute(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Object object = this.req.getAttribute(key);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Map<String, T> attributeMap() {
        void $this$associateTo$iv$iv;
        Enumeration<String> enumeration = this.req.getAttributeNames();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, "req.attributeNames");
        Enumeration<String> enumeration2 = enumeration;
        boolean bl = false;
        Sequence<String> $this$associate$iv = SequencesKt.asSequence(CollectionsKt.iterator(enumeration2));
        boolean $i$f$associate = false;
        Sequence<String> sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull(string, "it");
            Pair<String, T> pair = TuplesKt.to(it, this.attribute(string));
            boolean bl3 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public final int contentLength() {
        return this.req.getContentLength();
    }

    @Nullable
    public final String contentType() {
        return this.req.getContentType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String cookie(@NotNull String name) {
        Cookie cookie;
        Cookie[] cookieArray;
        block2: {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Cookie[] cookieArray2 = this.req.getCookies();
            cookieArray = cookieArray2;
            if (cookieArray2 == null) return null;
            Cookie[] cookieArray3 = cookieArray;
            boolean bl = false;
            Cookie[] cookieArray4 = cookieArray3;
            boolean bl2 = false;
            Cookie[] cookieArray5 = cookieArray4;
            int n = cookieArray5.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie it = cookie = cookieArray5[n2];
                boolean bl3 = false;
                Cookie cookie2 = it;
                Intrinsics.checkExpressionValueIsNotNull(cookie2, "it");
                if (!Intrinsics.areEqual(name, cookie2.getName())) {
                    ++n2;
                    continue;
                }
                break block2;
            }
            return null;
        }
        Cookie cookie3 = cookie;
        cookieArray = cookie3;
        if (cookie3 == null) return null;
        String string = cookieArray.getValue();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> cookieMap() {
        Map map2;
        Cookie[] cookieArray = this.req.getCookies();
        if (cookieArray != null) {
            void $this$associateTo$iv$iv;
            Cookie[] $this$associate$iv = cookieArray;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associate$iv.length), 16);
            Cookie[] cookieArray2 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (void element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv;
                void it = element$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull(v1, "it");
                Pair<String, String> pair = TuplesKt.to(v1.getName(), it.getValue());
                boolean bl2 = false;
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Nullable
    public final String header(@NotNull String header) {
        Intrinsics.checkParameterIsNotNull(header, "header");
        return this.req.getHeader(header);
    }

    @NotNull
    public final <T> Validator<T> header(@NotNull String header, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull(header, "header");
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return Validator.Companion.create(clazz, this.header(header), "Request header '" + header + "' with value '" + this.header(header) + '\'', header);
    }

    @NotNull
    public final /* synthetic */ <T> Validator<T> header(@NotNull String header) {
        int $i$f$header = 0;
        Intrinsics.checkParameterIsNotNull(header, "header");
        Intrinsics.reifiedOperationMarker(4, "T");
        return this.header(header, Object.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> headerMap() {
        void $this$associateTo$iv$iv;
        Enumeration<String> enumeration = this.req.getHeaderNames();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, "req.headerNames");
        Enumeration<String> enumeration2 = enumeration;
        boolean bl = false;
        Sequence<String> $this$associate$iv = SequencesKt.asSequence(CollectionsKt.iterator(enumeration2));
        boolean $i$f$associate = false;
        Sequence<String> sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull(string, "it");
            String string2 = this.header(string);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Pair<String, String> pair = TuplesKt.to(it, string2);
            boolean bl3 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Nullable
    public final String host() {
        return this.req.getHeader("Host");
    }

    @NotNull
    public final String ip() {
        String string = this.req.getRemoteAddr();
        Intrinsics.checkExpressionValueIsNotNull(string, "req.remoteAddr");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMultipart() {
        String string = this.header("Content-Type");
        String string2 = string;
        if (string == null) return false;
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).toLowerCase()");
        string2 = string5;
        if (string5 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string2, "multipart/", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMultipartFormData() {
        String string = this.header("Content-Type");
        String string2 = string;
        if (string == null) return false;
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.String).toLowerCase()");
        string2 = string5;
        if (string5 == null) return false;
        if (!StringsKt.contains$default((CharSequence)string2, "multipart/form-data", false, 2, null)) return false;
        return true;
    }

    @NotNull
    public final String method() {
        String string = this.req.getMethod();
        Intrinsics.checkExpressionValueIsNotNull(string, "req.method");
        return string;
    }

    @NotNull
    public final String path() {
        String string = this.req.getRequestURI();
        Intrinsics.checkExpressionValueIsNotNull(string, "req.requestURI");
        return string;
    }

    public final int port() {
        return this.req.getServerPort();
    }

    @NotNull
    public final String protocol() {
        String string = this.req.getProtocol();
        Intrinsics.checkExpressionValueIsNotNull(string, "req.protocol");
        return string;
    }

    @JvmOverloads
    @Nullable
    public final String queryParam(@NotNull String key, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        String string2 = CollectionsKt.firstOrNull(this.queryParams(key));
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static /* synthetic */ String queryParam$default(Context context, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queryParam");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return context.queryParam(string, string2);
    }

    @JvmOverloads
    @Nullable
    public final String queryParam(@NotNull String key) {
        return Context.queryParam$default(this, key, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final <T> Validator<T> queryParam(@NotNull String key, @NotNull Class<T> clazz, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return Validator.Companion.create(clazz, this.queryParam(key, string), "Query parameter '" + key + "' with value '" + this.queryParam(key, string) + '\'', key);
    }

    public static /* synthetic */ Validator queryParam$default(Context context, String string, Class clazz, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queryParam");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return context.queryParam(string, clazz, string2);
    }

    @JvmOverloads
    @NotNull
    public final <T> Validator<T> queryParam(@NotNull String key, @NotNull Class<T> clazz) {
        return Context.queryParam$default(this, key, clazz, null, 4, null);
    }

    @NotNull
    public final /* synthetic */ <T> Validator<T> queryParam(@NotNull String key, @Nullable String string) {
        int $i$f$queryParam = 0;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.reifiedOperationMarker(4, "T");
        return this.queryParam(key, Object.class, string);
    }

    public static /* synthetic */ Validator queryParam$default(Context this_, String key, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queryParam");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        boolean $i$f$queryParam = false;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.reifiedOperationMarker(4, "T");
        return this_.queryParam(key, Object.class, string);
    }

    @NotNull
    public final List<String> queryParams(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        List<String> list = this.queryParamMap().get(key);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Map<String, List<String>> queryParamMap() {
        String string = this.queryString();
        if (string == null) {
            string = "";
        }
        return ContextUtil.INSTANCE.splitKeyValueStringAndGroupByKey(string, this.getCharacterEncoding());
    }

    @Nullable
    public final String queryString() {
        return this.req.getQueryString();
    }

    @NotNull
    public final String scheme() {
        String string = this.req.getScheme();
        Intrinsics.checkExpressionValueIsNotNull(string, "req.scheme");
        return string;
    }

    public final void sessionAttribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        this.req.getSession().setAttribute(key, value);
    }

    @Nullable
    public final <T> T sessionAttribute(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Object object = this.req.getSession().getAttribute(key);
        if (!(object instanceof Object)) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Map<String, T> sessionAttributeMap() {
        void $this$associateTo$iv$iv;
        HttpSession httpSession = this.req.getSession();
        Intrinsics.checkExpressionValueIsNotNull(httpSession, "req.session");
        Enumeration<String> enumeration = httpSession.getAttributeNames();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, "req.session.attributeNames");
        Enumeration<String> enumeration2 = enumeration;
        boolean bl = false;
        Sequence<String> $this$associate$iv = SequencesKt.asSequence(CollectionsKt.iterator(enumeration2));
        boolean $i$f$associate = false;
        Sequence<String> sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull(string, "it");
            Pair<String, T> pair = TuplesKt.to(it, this.sessionAttribute(string));
            boolean bl3 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public final String url() {
        String string = this.req.getRequestURL().toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "req.requestURL.toString()");
        return string;
    }

    @NotNull
    public final String fullUrl() {
        return this.url() + (this.queryString() != null ? "?" + this.queryString() : "");
    }

    @NotNull
    public final String contextPath() {
        String string = this.req.getContextPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "req.contextPath");
        return string;
    }

    @Nullable
    public final String userAgent() {
        return this.req.getHeader("User-Agent");
    }

    private final Charset responseCharset() {
        Charset charset;
        try {
            charset = Charset.forName(this.res.getCharacterEncoding());
        }
        catch (Exception e) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    @NotNull
    public final Context result(@NotNull String resultString) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull(resultString, "resultString");
        String string = resultString;
        Charset charset = this.responseCharset();
        Intrinsics.checkExpressionValueIsNotNull(charset, "responseCharset()");
        Charset charset2 = charset;
        Context context = this;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        byte[] byArray2 = string2.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull(byArray2, "(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        return context.result(byteArrayInputStream);
    }

    @NotNull
    public final Context result(@NotNull byte[] resultBytes) {
        Intrinsics.checkParameterIsNotNull(resultBytes, "resultBytes");
        byte[] byArray = resultBytes;
        Context context = this;
        boolean bl = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return context.result(byteArrayInputStream);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final String resultString() {
        block2: {
            v0 = this.resultStream;
            if (v0 == null) ** GOTO lbl-1000
            var1_1 = v0;
            var2_2 = false;
            var3_5 = false;
            $this$apply = var1_1;
            $i$a$-apply-Context$resultString$1 = false;
            $this$apply.reset();
            v0 = var1_1;
            if (v0 == null) ** GOTO lbl-1000
            v1 = ByteStreamsKt.readBytes((InputStream)v0);
            v0 = v1;
            if (v1 != null) {
                var1_1 = v0;
                v2 = this.responseCharset();
                Intrinsics.checkExpressionValueIsNotNull(v2, "responseCharset()");
                var2_3 = v2;
                var3_5 = false;
                $this$apply = false;
                v3 = new String((byte[])var1_1, var2_3);
            } else lbl-1000:
            // 3 sources

            {
                v3 = null;
            }
            var1_1 = v3;
            var2_4 = false;
            var3_5 = false;
            it = var1_1;
            $i$a$-also-Context$resultString$2 = false;
            v4 = this.resultStream;
            if (v4 == null) break block2;
            v4.reset();
        }
        return var1_1;
    }

    @NotNull
    public final Context result(@NotNull InputStream resultStream) {
        Intrinsics.checkParameterIsNotNull(resultStream, "resultStream");
        this.resultFuture = null;
        this.resultStream = resultStream;
        return this;
    }

    public final void seekableStream(@NotNull InputStream inputStream2, @NotNull String contentType) {
        Intrinsics.checkParameterIsNotNull(inputStream2, "inputStream");
        Intrinsics.checkParameterIsNotNull(contentType, "contentType");
        SeekableWriter.INSTANCE.write(this, inputStream2, contentType);
    }

    @Nullable
    public final InputStream resultStream() {
        return this.resultStream;
    }

    @NotNull
    public final Context result(@NotNull CompletableFuture<?> future) {
        Intrinsics.checkParameterIsNotNull(future, "future");
        this.resultStream = null;
        if (this.handlerType.isHttpMethod() && !this.inExceptionHandler) {
            this.resultFuture = future;
            return this;
        }
        throw (Throwable)new IllegalStateException("You can only set CompletableFuture results in endpoint handlers.");
    }

    @Nullable
    public final CompletableFuture<?> resultFuture() {
        return this.resultFuture;
    }

    @NotNull
    public final Context contentType(@NotNull String contentType) {
        Intrinsics.checkParameterIsNotNull(contentType, "contentType");
        this.res.setContentType(contentType);
        return this;
    }

    @NotNull
    public final Context header(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.res.setHeader(name, value);
        return this;
    }

    @JvmOverloads
    public final void redirect(@NotNull String location, int httpStatusCode) {
        Intrinsics.checkParameterIsNotNull(location, "location");
        this.res.setHeader("Location", location);
        this.status(httpStatusCode);
        if (this.handlerType == HandlerType.BEFORE) {
            throw (Throwable)new RedirectResponse(httpStatusCode, null, 2, null);
        }
    }

    public static /* synthetic */ void redirect$default(Context context, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: redirect");
        }
        if ((n2 & 2) != 0) {
            n = 302;
        }
        context.redirect(string, n);
    }

    @JvmOverloads
    public final void redirect(@NotNull String location) {
        Context.redirect$default(this, location, 0, 2, null);
    }

    @NotNull
    public final Context status(int statusCode) {
        this.res.setStatus(statusCode);
        return this;
    }

    public final int status() {
        return this.res.getStatus();
    }

    @JvmOverloads
    @NotNull
    public final Context cookie(@NotNull String name, @NotNull String value, int maxAge) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Cookie cookie = new Cookie(name, value);
        Context context = this;
        boolean bl = false;
        boolean bl2 = false;
        Cookie $this$apply = cookie;
        boolean bl3 = false;
        $this$apply.setMaxAge(maxAge);
        Cookie cookie2 = cookie;
        return context.cookie(cookie2);
    }

    public static /* synthetic */ Context cookie$default(Context context, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: cookie");
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        return context.cookie(string, string2, n);
    }

    @JvmOverloads
    @NotNull
    public final Context cookie(@NotNull String name, @NotNull String value) {
        return Context.cookie$default(this, name, value, 0, 4, null);
    }

    @NotNull
    public final Context cookie(@NotNull Cookie cookie) {
        Intrinsics.checkParameterIsNotNull(cookie, "cookie");
        String string = cookie.getPath();
        if (string == null) {
            string = "/";
        }
        cookie.setPath(string);
        this.res.addCookie(cookie);
        return this;
    }

    @JvmOverloads
    @NotNull
    public final Context removeCookie(@NotNull String name, @Nullable String path) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Cookie cookie = new Cookie(name, "");
        HttpServletResponse httpServletResponse = this.res;
        boolean bl = false;
        boolean bl2 = false;
        Cookie $this$apply = cookie;
        boolean bl3 = false;
        $this$apply.setPath(path);
        $this$apply.setMaxAge(0);
        Cookie cookie2 = cookie;
        httpServletResponse.addCookie(cookie2);
        return this;
    }

    public static /* synthetic */ Context removeCookie$default(Context context, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeCookie");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return context.removeCookie(string, string2);
    }

    @JvmOverloads
    @NotNull
    public final Context removeCookie(@NotNull String name) {
        return Context.removeCookie$default(this, name, null, 2, null);
    }

    @NotNull
    public final Context html(@NotNull String html) {
        Intrinsics.checkParameterIsNotNull(html, "html");
        return this.contentType("text/html").result(html);
    }

    @NotNull
    public final Context json(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        return this.contentType("application/json").result(JavalinJson.toJson(obj));
    }

    @NotNull
    public final Context json(@NotNull CompletableFuture<?> future) {
        Intrinsics.checkParameterIsNotNull(future, "future");
        CompletionStage mappingFuture2 = future.thenApply((Function)json.mappingFuture.1.INSTANCE);
        Context context = this.contentType("application/json");
        CompletionStage completionStage = mappingFuture2;
        Intrinsics.checkExpressionValueIsNotNull(completionStage, "mappingFuture");
        return context.result((CompletableFuture<?>)completionStage);
    }

    @JvmOverloads
    @NotNull
    public final Context render(@NotNull String filePath, @NotNull Map<String, ? extends Object> model) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        Intrinsics.checkParameterIsNotNull(model, "model");
        return this.html(JavalinRenderer.INSTANCE.renderBasedOnExtension(filePath, model, this));
    }

    public static /* synthetic */ Context render$default(Context context, String string, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: render");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = new LinkedHashMap();
        }
        return context.render(string, map2);
    }

    @JvmOverloads
    @NotNull
    public final Context render(@NotNull String filePath) {
        return Context.render$default(this, filePath, null, 2, null);
    }

    @Nullable
    public final String splat(int splatNr) {
        return this.splatList.get(splatNr);
    }

    @NotNull
    public final List<String> splats() {
        List<String> list = Collections.unmodifiableList(this.splatList);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.unmodifiableList(splatList)");
        return list;
    }

    @NotNull
    public final HandlerType handlerType() {
        return this.handlerType;
    }

    public Context(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res, @NotNull Map<Class<?>, ? extends Object> appAttributes) {
        Intrinsics.checkParameterIsNotNull(req, "req");
        Intrinsics.checkParameterIsNotNull(res, "res");
        Intrinsics.checkParameterIsNotNull(appAttributes, "appAttributes");
        this.req = req;
        this.res = res;
        this.appAttributes = appAttributes;
        this.matchedPath = "";
        this.endpointHandlerPath = "";
        Context context = this;
        boolean bl = false;
        Object object = MapsKt.emptyMap();
        context.pathParamMap = object;
        this.handlerType = HandlerType.BEFORE;
        context = this;
        bl = false;
        context.splatList = object = CollectionsKt.emptyList();
        this.cookieStore$delegate = LazyKt.lazy((Function0)new Function0<CookieStore>(this){
            final /* synthetic */ Context this$0;

            @NotNull
            public final CookieStore invoke() {
                return new CookieStore(this.this$0.cookie(CookieStore.Companion.getCOOKIE_NAME()));
            }
            {
                this.this$0 = context;
                super(0);
            }
        });
        this.characterEncoding$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ Context this$0;

            @NotNull
            public final String invoke() {
                String string = ContextUtil.INSTANCE.getRequestCharset(this.this$0);
                if (string == null) {
                    string = "UTF-8";
                }
                return string;
            }
            {
                this.this$0 = context;
                super(0);
            }
        });
        this.body$delegate = LazyKt.lazy((Function0)new Function0<byte[]>(this){
            final /* synthetic */ Context this$0;

            @NotNull
            public final byte[] invoke() {
                ServletInputStream servletInputStream = this.this$0.req.getInputStream();
                Intrinsics.checkExpressionValueIsNotNull(servletInputStream, "req.inputStream");
                return ByteStreamsKt.readBytes(servletInputStream);
            }
            {
                this.this$0 = context;
                super(0);
            }
        });
    }

    public /* synthetic */ Context(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        this(httpServletRequest, httpServletResponse, map2);
    }
}

