/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query;

import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.query.Expression;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.util.CloseableIterable;
import io.requery.util.CloseableIterator;
import io.requery.util.function.Consumer;
import io.requery.util.function.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public abstract class BaseResult<E>
implements Result<E>,
CloseableIterable<E> {
    private final Integer maxSize;
    private final Queue<CloseableIterator<E>> iterators;
    private final AtomicBoolean closed;

    protected BaseResult() {
        this(null);
    }

    protected BaseResult(Integer maxSize) {
        this.maxSize = maxSize;
        this.iterators = new ConcurrentLinkedQueue<CloseableIterator<E>>();
        this.closed = new AtomicBoolean();
    }

    @Override
    public List<E> toList() {
        ArrayList list = this.maxSize == null ? new ArrayList() : new ArrayList(this.maxSize);
        this.collect(list);
        return Collections.unmodifiableList(list);
    }

    @Override
    public <C extends Collection<E>> C collect(C collection) {
        try (CloseableIterator<E> iterator2 = this.createIterator();){
            while (iterator2.hasNext()) {
                collection.add(iterator2.next());
            }
        }
        return collection;
    }

    @Override
    public E first() {
        try (CloseableIterator<E> iterator2 = this.createIterator();){
            Object e = iterator2.next();
            return e;
        }
    }

    @Override
    public E firstOr(E defaultElement) {
        try (CloseableIterator<E> iterator2 = this.createIterator();){
            if (iterator2.hasNext()) {
                Object e = iterator2.next();
                return e;
            }
        }
        return defaultElement;
    }

    @Override
    public E firstOr(Supplier<E> supplier) {
        try (CloseableIterator<E> iterator2 = this.createIterator();){
            if (iterator2.hasNext()) {
                Object e = iterator2.next();
                return e;
            }
        }
        return supplier.get();
    }

    @Override
    public E firstOrNull() {
        return this.firstOr((E)null);
    }

    @Override
    @Nonnull
    public CloseableIterator<E> iterator() {
        if (this.closed.get()) {
            throw new IllegalStateException();
        }
        CloseableIterator<E> iterator2 = this.createIterator(0, Integer.MAX_VALUE);
        this.iterators.add(iterator2);
        return iterator2;
    }

    @Override
    public CloseableIterator<E> iterator(int skip, int take) {
        if (this.closed.get()) {
            throw new IllegalStateException();
        }
        CloseableIterator<E> iterator2 = this.createIterator(skip, take);
        this.iterators.add(iterator2);
        return iterator2;
    }

    protected CloseableIterator<E> createIterator() {
        return this.createIterator(0, Integer.MAX_VALUE);
    }

    protected abstract CloseableIterator<E> createIterator(int var1, int var2);

    @Override
    public Stream<E> stream() {
        final CloseableIterator<E> iterator2 = this.createIterator();
        Spliterator<E> spliterator = this.maxSize == null ? Spliterators.spliteratorUnknownSize(iterator2, 0) : Spliterators.spliterator(iterator2, (long)this.maxSize.intValue(), 0);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(new Runnable(){

            @Override
            public void run() {
                iterator2.close();
            }
        });
    }

    @Override
    public void each(Consumer<? super E> action) {
        try (CloseableIterator<E> iterator2 = this.createIterator();){
            while (iterator2.hasNext()) {
                action.accept(iterator2.next());
            }
        }
    }

    @Override
    public <K> Map<K, E> toMap(Expression<K> key) {
        return this.toMap(key, new HashMap());
    }

    @Override
    public <K> Map<K, E> toMap(Expression<K> key, Map<K, E> map2) {
        try (CloseableIterator<E> iterator2 = this.createIterator();){
            while (iterator2.hasNext()) {
                Object value = iterator2.next();
                Type type2 = null;
                if (key instanceof Attribute) {
                    Attribute attribute = (Attribute)((Object)key);
                    type2 = attribute.getDeclaringType();
                }
                if (type2 != null) {
                    EntityProxy proxy = type2.getProxyProvider().apply(value);
                    map2.put(proxy.get((Attribute)((Object)key)), value);
                    continue;
                }
                if (value instanceof Tuple) {
                    map2.put(((Tuple)value).get(key), value);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        return map2;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            CloseableIterator<E> iterator2 = this.iterators.poll();
            while (iterator2 != null) {
                iterator2.close();
                iterator2 = this.iterators.poll();
            }
        }
    }
}

