/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.PersistenceException;
import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.query.BaseResult;
import io.requery.query.Result;
import io.requery.sql.Attributes;
import io.requery.sql.BoundParameters;
import io.requery.sql.EntityContext;
import io.requery.sql.EntityReader;
import io.requery.sql.EntityResultReader;
import io.requery.sql.ParameterInliner;
import io.requery.sql.PreparedQueryOperation;
import io.requery.sql.ResultSetIterator;
import io.requery.sql.StatementExecutionException;
import io.requery.sql.StatementListener;
import io.requery.util.CloseableIterator;
import io.requery.util.function.Predicate;
import io.requery.util.function.Supplier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;

class RawEntityQuery<E extends S, S>
extends PreparedQueryOperation
implements Supplier<Result<E>> {
    private final EntityReader<E, S> reader;
    private final Type<E> type;
    private final BoundParameters boundParameters;
    private final String sql;

    RawEntityQuery(EntityContext<S> context, Class<E> cls, String sql, Object[] parameters2) {
        super(context, null);
        ParameterInliner inlined2 = new ParameterInliner(sql, parameters2).apply();
        this.type = this.configuration.getModel().typeOf(cls);
        this.sql = inlined2.sql();
        this.reader = context.read(cls);
        this.boundParameters = new BoundParameters(inlined2.parameters());
    }

    @Override
    public Result<E> get() {
        PreparedStatement statement = null;
        try {
            Connection connection = this.configuration.getConnection();
            statement = this.prepare(this.sql, connection);
            this.mapParameters(statement, this.boundParameters);
            return new EntityResult(statement);
        }
        catch (Exception e) {
            throw StatementExecutionException.closing(statement, e, this.sql);
        }
    }

    private class EntityResult
    extends BaseResult<E> {
        private final PreparedStatement statement;

        private EntityResult(PreparedStatement statement) {
            this.statement = statement;
        }

        @Override
        public CloseableIterator<E> createIterator(int skip, int take) {
            try {
                StatementListener listener = RawEntityQuery.this.configuration.getStatementListener();
                listener.beforeExecuteQuery(this.statement, RawEntityQuery.this.sql, RawEntityQuery.this.boundParameters);
                ResultSet results = this.statement.executeQuery();
                listener.afterExecuteQuery(this.statement);
                ResultSetMetaData metadata2 = results.getMetaData();
                HashMap map2 = new HashMap();
                for (Attribute attribute : RawEntityQuery.this.type.getAttributes()) {
                    map2.put(attribute.getName().toLowerCase(Locale.ROOT), attribute);
                }
                LinkedHashSet attributes = new LinkedHashSet();
                for (int i2 = 0; i2 < metadata2.getColumnCount(); ++i2) {
                    String name = metadata2.getColumnName(i2 + 1);
                    Attribute attribute = (Attribute)map2.get(name.toLowerCase(Locale.ROOT));
                    if (attribute == null) continue;
                    attributes.add(attribute);
                }
                Attribute[] array = Attributes.toArray(attributes, new Predicate<Attribute<E, ?>>(){

                    @Override
                    public boolean test(Attribute<E, ?> value) {
                        return true;
                    }
                });
                EntityResultReader entityReader = new EntityResultReader(RawEntityQuery.this.reader, array);
                return new ResultSetIterator(entityReader, results, null, true, true);
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
    }
}

