/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java8.util.Objects;
import java8.util.concurrent.ConcurrentMaps$$Lambda$1;
import java8.util.function.BiConsumer;
import java8.util.function.BiFunction;
import java8.util.function.Function;

public final class ConcurrentMaps {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <K, V> V merge(ConcurrentMap<K, V> map2, K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(map2);
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        block0: while (true) {
            Object oldValue = map2.get(key);
            do {
                if (oldValue == null) continue;
                V newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (!map2.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                if (map2.remove(key, oldValue)) return null;
                continue block0;
            } while ((oldValue = map2.putIfAbsent(key, value)) != null);
            break;
        }
        return value;
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map2, K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(map2);
        Objects.requireNonNull(mappingFunction);
        Object oldValue = map2.get(key);
        return oldValue == null && (newValue = mappingFunction.apply(key)) != null && (oldValue = map2.putIfAbsent(key, newValue)) == null ? newValue : oldValue;
    }

    public static <K, V> V computeIfPresent(ConcurrentMap<K, V> map2, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        Objects.requireNonNull(map2);
        Objects.requireNonNull(remappingFunction);
        while ((oldValue = map2.get(key)) != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (!(newValue == null ? map2.remove(key, oldValue) : map2.replace(key, oldValue, newValue))) continue;
            return newValue;
        }
        return null;
    }

    public static <K, V> V compute(ConcurrentMap<K, V> map2, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(map2);
        block0: while (true) {
            V newValue;
            Object oldValue = map2.get(key);
            while ((newValue = remappingFunction.apply(key, oldValue)) != null) {
                if (oldValue != null) {
                    if (!map2.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                oldValue = map2.putIfAbsent(key, newValue);
                if (oldValue != null) continue;
                return newValue;
            }
            if (oldValue == null || map2.remove(key, oldValue)) break;
        }
        return null;
    }

    public static <K, V> void replaceAll(ConcurrentMap<K, V> map2, BiFunction<? super K, ? super V, ? extends V> function2) {
        Objects.requireNonNull(map2);
        Objects.requireNonNull(function2);
        ConcurrentMaps.forEach(map2, ConcurrentMaps$$Lambda$1.lambdaFactory$(map2, function2));
    }

    public static <K, V> V getOrDefault(ConcurrentMap<K, V> map2, Object key, V defaultValue) {
        Objects.requireNonNull(map2);
        Object v = map2.get(key);
        return v != null ? v : defaultValue;
    }

    public static <K, V> void forEach(ConcurrentMap<K, V> map2, BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(map2);
        Objects.requireNonNull(action);
        for (Map.Entry entry : map2.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            action.accept(k, v);
        }
    }

    private ConcurrentMaps() {
    }

    static /* synthetic */ void lambda$replaceAll$132(ConcurrentMap concurrentMap, BiFunction biFunction, Object k, Object v) {
        while (!concurrentMap.replace(k, v, biFunction.apply(k, v)) && (v = concurrentMap.get(k)) != null) {
        }
    }
}

