/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionClassKind
extends Enum<FunctionClassKind> {
    public static final /* enum */ FunctionClassKind Function;
    public static final /* enum */ FunctionClassKind SuspendFunction;
    public static final /* enum */ FunctionClassKind KFunction;
    public static final /* enum */ FunctionClassKind KSuspendFunction;
    private static final /* synthetic */ FunctionClassKind[] $VALUES;
    private final FqName packageFqName;
    private final String classNamePrefix;
    @NotNull
    public static final Companion Companion;

    static {
        FunctionClassKind[] functionClassKindArray = new FunctionClassKind[4];
        FunctionClassKind[] functionClassKindArray2 = functionClassKindArray;
        functionClassKindArray[0] = Function = new FunctionClassKind(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, "Function");
        functionClassKindArray[1] = SuspendFunction = new FunctionClassKind(StandardNames.COROUTINES_PACKAGE_FQ_NAME_RELEASE, "SuspendFunction");
        functionClassKindArray[2] = KFunction = new FunctionClassKind(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KFunction");
        functionClassKindArray[3] = KSuspendFunction = new FunctionClassKind(StandardNames.KOTLIN_REFLECT_FQ_NAME, "KSuspendFunction");
        $VALUES = functionClassKindArray;
        Companion = new Companion(null);
    }

    @NotNull
    public final Name numberedClassName(int arity) {
        Name name = Name.identifier(this.classNamePrefix + arity);
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"$classNamePrefix$arity\")");
        return name;
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    private FunctionClassKind(FqName packageFqName, String classNamePrefix) {
        this.packageFqName = packageFqName;
        this.classNamePrefix = classNamePrefix;
    }

    public static FunctionClassKind[] values() {
        return (FunctionClassKind[])$VALUES.clone();
    }

    public static FunctionClassKind valueOf(String string) {
        return Enum.valueOf(FunctionClassKind.class, string);
    }

    public static final class Companion {
        @Nullable
        public final FunctionClassKind byClassNamePrefix(@NotNull FqName packageFqName, @NotNull String className) {
            FunctionClassKind functionClassKind;
            block1: {
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Intrinsics.checkNotNullParameter(className, "className");
                FunctionClassKind[] $this$firstOrNull$iv = FunctionClassKind.values();
                boolean $i$f$firstOrNull = false;
                FunctionClassKind[] functionClassKindArray = $this$firstOrNull$iv;
                int n = functionClassKindArray.length;
                for (int j = 0; j < n; ++j) {
                    FunctionClassKind element$iv;
                    FunctionClassKind it = element$iv = functionClassKindArray[j];
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getPackageFqName(), packageFqName) && StringsKt.startsWith$default(className, it.getClassNamePrefix(), false, 2, null))) continue;
                    functionClassKind = element$iv;
                    break block1;
                }
                functionClassKind = null;
            }
            return functionClassKind;
        }

        @Nullable
        public final KindWithArity parseClassName(@NotNull String className, @NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter(className, "className");
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            FunctionClassKind functionClassKind = this.byClassNamePrefix(packageFqName, className);
            if (functionClassKind == null) {
                return null;
            }
            FunctionClassKind kind = functionClassKind;
            String prefix = kind.getClassNamePrefix();
            String string = className;
            int n = prefix.length();
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).substring(startIndex)");
            Integer n2 = this.toInt(string2);
            if (n2 == null) {
                return null;
            }
            int arity = n2;
            return new KindWithArity(kind, arity);
        }

        @JvmStatic
        @Nullable
        public final FunctionClassKind getFunctionalClassKind(@NotNull String className, @NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter(className, "className");
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            KindWithArity kindWithArity = this.parseClassName(className, packageFqName);
            return kindWithArity != null ? kindWithArity.getKind() : null;
        }

        private final Integer toInt(String s) {
            CharSequence charSequence = s;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return null;
            }
            int result2 = 0;
            String string = s;
            int n = string.length();
            for (int j = 0; j < n; ++j) {
                char c = string.charAt(j);
                int d = c - 48;
                int n2 = d;
                if (0 > n2 || 9 < n2) {
                    return null;
                }
                result2 = result2 * 10 + d;
            }
            return result2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class KindWithArity {
            private final FunctionClassKind kind;
            private final int arity;

            @NotNull
            public final FunctionClassKind getKind() {
                return this.kind;
            }

            public KindWithArity(@NotNull FunctionClassKind kind, int arity) {
                Intrinsics.checkNotNullParameter((Object)kind, "kind");
                this.kind = kind;
                this.arity = arity;
            }

            @NotNull
            public final FunctionClassKind component1() {
                return this.kind;
            }

            public final int component2() {
                return this.arity;
            }

            @NotNull
            public String toString() {
                return "KindWithArity(kind=" + (Object)((Object)this.kind) + ", arity=" + this.arity + ")";
            }

            public int hashCode() {
                FunctionClassKind functionClassKind = this.kind;
                return (functionClassKind != null ? ((Object)((Object)functionClassKind)).hashCode() : 0) * 31 + this.arity;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof KindWithArity)) break block3;
                        KindWithArity kindWithArity = (KindWithArity)object;
                        if (!Intrinsics.areEqual((Object)this.kind, (Object)kindWithArity.kind) || this.arity != kindWithArity.arity) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

