/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.sync.BatchEmptyException;
import eu.pretix.libpretixsync.sync.BatchedQueryIterator;
import eu.pretix.libpretixsync.sync.DownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.JSONUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.query.Tuple;
import io.requery.util.CloseableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java8.util.concurrent.CompletableFuture;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseDownloadSyncAdapter<T extends RemoteObject & Persistable, K>
implements DownloadSyncAdapter,
BatchedQueryIterator.BatchedQueryCall<K, T> {
    protected BlockingEntityStore<Persistable> store;
    protected PretixApi api;
    protected String eventSlug;
    protected FileStorage fileStorage;
    protected Set<K> knownIDs;
    protected Set<K> seenIDs;
    protected int sizeBefore;
    protected ExecutorService threadPool = Executors.newCachedThreadPool();
    protected SyncManager.ProgressFeedback feedback;
    protected int total;
    protected int inserted;
    protected int totalOnline;
    protected SyncManager.CanceledState canceledState;

    public BaseDownloadSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, PretixApi api, SyncManager.ProgressFeedback feedback) {
        this.store = store;
        this.api = api;
        this.eventSlug = eventSlug;
        this.fileStorage = fileStorage;
        this.feedback = feedback;
    }

    @Override
    public void setCancelState(SyncManager.CanceledState state) {
        this.canceledState = state;
    }

    @Override
    public void download() throws JSONException, ApiException, ExecutionException, InterruptedException {
        if (this.feedback != null) {
            this.feedback.postFeedback("Downloading " + this.getResourceName() + "\u2026");
        }
        try {
            this.total = 0;
            this.inserted = 0;
            this.knownIDs = this.getKnownIDs();
            this.sizeBefore = this.knownIDs.size();
            this.seenIDs = new HashSet<K>();
            this.downloadData();
            if (this.deleteUnseen()) {
                for (Map.Entry<K, T> obj : this.getKnownObjects(this.knownIDs).entrySet()) {
                    this.prepareDelete((RemoteObject)obj.getValue());
                    this.store.delete(obj.getValue());
                }
            }
        }
        catch (ResourceNotModified resourceNotModified) {
            // empty catch block
        }
    }

    protected Iterator<T> getKnownObjectsIterator(Set<K> ids) {
        return new BatchedQueryIterator(ids.iterator(), this);
    }

    abstract CloseableIterator<Tuple> getKnownIDsIterator();

    protected Set<K> getKnownIDs() {
        CloseableIterator<Tuple> it = this.getKnownIDsIterator();
        HashSet known = new HashSet();
        while (it.hasNext()) {
            Tuple obj = (Tuple)it.next();
            known.add(obj.get(0));
        }
        it.close();
        return known;
    }

    protected Map<K, T> getKnownObjects(Set<K> ids) {
        if (ids.isEmpty()) {
            return new HashMap();
        }
        Iterator<T> it = this.getKnownObjectsIterator(ids);
        HashMap<K, RemoteObject> known = new HashMap<K, RemoteObject>();
        while (it.hasNext()) {
            try {
                RemoteObject obj = (RemoteObject)it.next();
                if (known.containsKey(this.getId(obj))) {
                    this.store.delete(known.get(this.getId(obj)));
                }
                known.put(this.getId(obj), obj);
            }
            catch (BatchEmptyException batchEmptyException) {}
        }
        return known;
    }

    protected JSONObject preprocessObject(JSONObject obj) {
        return obj;
    }

    protected void processPage(final JSONArray data2) {
        final int l = data2.length();
        this.store.runInTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HashSet fetchIds = new HashSet();
                for (int i2 = 0; i2 < l; ++i2) {
                    JSONObject jsonobj = data2.getJSONObject(i2);
                    fetchIds.add(BaseDownloadSyncAdapter.this.getId(jsonobj));
                }
                Map known = BaseDownloadSyncAdapter.this.getKnownObjects(fetchIds);
                ArrayList<Object> inserts = new ArrayList<Object>();
                for (int i3 = 0; i3 < l; ++i3) {
                    Object obj;
                    JSONObject jsonobj = BaseDownloadSyncAdapter.this.preprocessObject(data2.getJSONObject(i3));
                    Object jsonid = BaseDownloadSyncAdapter.this.getId(jsonobj);
                    JSONObject old = null;
                    if (BaseDownloadSyncAdapter.this.seenIDs.contains(jsonid)) continue;
                    if (known.containsKey(jsonid)) {
                        obj = (RemoteObject)known.get(jsonid);
                        old = obj.getJSON();
                    } else {
                        obj = BaseDownloadSyncAdapter.this.newEmptyObject();
                    }
                    if (known.containsKey(jsonid)) {
                        known.remove(jsonid);
                        BaseDownloadSyncAdapter.this.knownIDs.remove(jsonid);
                        if (!JSONUtils.similar(jsonobj, (Object)old)) {
                            BaseDownloadSyncAdapter.this.updateObject(obj, jsonobj);
                            BaseDownloadSyncAdapter.this.store.update(obj);
                        }
                    } else {
                        BaseDownloadSyncAdapter.this.updateObject(obj, jsonobj);
                        if (BaseDownloadSyncAdapter.this.autoPersist()) {
                            inserts.add(obj);
                        }
                    }
                    BaseDownloadSyncAdapter.this.seenIDs.add(jsonid);
                }
                BaseDownloadSyncAdapter.this.inserted += inserts.size();
                BaseDownloadSyncAdapter.this.store.insert(inserts);
                BaseDownloadSyncAdapter.this.afterPage();
                return null;
            }
        });
        this.total += l;
        if (this.feedback != null) {
            this.feedback.postFeedback("Processed " + this.total + "/" + this.totalOnline + " " + this.getResourceName() + " (total in database: ~" + (this.sizeBefore + this.inserted) + ")\u2026");
        }
    }

    protected void afterPage() {
    }

    protected void prepareDelete(T obj) {
    }

    protected boolean autoPersist() {
        return true;
    }

    protected boolean deleteUnseen() {
        return true;
    }

    public abstract void updateObject(T var1, JSONObject var2) throws JSONException;

    protected CompletableFuture<Boolean> asyncProcessPage(JSONArray data2) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.threadPool.submit(() -> {
            try {
                this.processPage(data2);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
            finally {
                completableFuture.complete(true);
            }
        });
        return completableFuture;
    }

    protected String getUrl() {
        return this.api.eventResourceUrl(this.getResourceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadData() throws JSONException, ApiException, ResourceNotModified, ExecutionException, InterruptedException {
        String url = this.getUrl();
        boolean isFirstPage = true;
        CompletableFuture<Boolean> future = null;
        try {
            while (true) {
                if (this.canceledState != null && this.canceledState.isCanceled()) {
                    throw new InterruptedException();
                }
                JSONObject page = this.downloadPage(url, isFirstPage);
                if (future != null) {
                    future.get();
                }
                this.totalOnline = page.getInt("count");
                future = this.asyncProcessPage(page.getJSONArray("results"));
                if (page.isNull("next")) {
                    break;
                }
                url = page.getString("next");
                isFirstPage = false;
            }
        }
        finally {
            if (future != null) {
                future.get();
            }
        }
    }

    protected JSONObject downloadPage(String url, boolean isFirstPage) throws ApiException, ResourceNotModified {
        return this.api.fetchResource(url).getData();
    }

    abstract String getResourceName();

    abstract K getId(JSONObject var1) throws JSONException;

    abstract K getId(T var1);

    abstract T newEmptyObject();
}

