/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.TicketLayout;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.HashUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Condition;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketLayoutSyncAdapter
extends BaseDownloadSyncAdapter<TicketLayout, Long> {
    public TicketLayoutSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, PretixApi api, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage, eventSlug, api, feedback);
    }

    @Override
    public void updateObject(TicketLayout obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setIs_default(jsonobj.getBoolean("default"));
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setJson_data(jsonobj.toString());
        ArrayList<Object> itemids_web = new ArrayList<Object>();
        ArrayList<Object> itemids_pretixpos = new ArrayList<Object>();
        JSONArray assignmentarr = jsonobj.getJSONArray("item_assignments");
        for (int i2 = 0; i2 < assignmentarr.length(); ++i2) {
            Item itemobj;
            Long item = assignmentarr.getJSONObject(i2).getLong("item");
            String sc = assignmentarr.getJSONObject(i2).optString("sales_channel", "web");
            if (sc == null) {
                sc = "web";
            }
            if (sc.equals("web")) {
                itemids_web.add(item);
                itemobj = (Item)((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.SERVER_ID.eq((Object)item)).get()).firstOrNull();
                if (itemobj == null) continue;
                itemobj.setTicket_layout_id(obj.getServer_id());
                this.store.update(itemobj, Item.TICKET_LAYOUT_ID);
                continue;
            }
            if (!sc.equals("pretixpos")) continue;
            itemids_pretixpos.add(item);
            itemobj = (Item)((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.SERVER_ID.eq((Object)item)).get()).firstOrNull();
            if (itemobj == null) continue;
            itemobj.setTicket_layout_pretixpos_id(obj.getServer_id());
            this.store.update(itemobj, Item.TICKET_LAYOUT_PRETIXPOS_ID);
        }
        List items_to_remove_web = !itemids_web.isEmpty() ? ((Result)this.store.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.notIn(itemids_web).and(Item.TICKET_LAYOUT_ID.eq((Object)obj.getServer_id()))).get()).toList() : ((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.TICKET_LAYOUT_ID.eq((Object)obj.getServer_id())).get()).toList();
        for (Object item : items_to_remove_web) {
            ((Item)item).setTicket_layout_id(null);
            this.store.update(item, Item.TICKET_LAYOUT_ID);
        }
        List items_to_remove_pretixpos = !itemids_pretixpos.isEmpty() ? ((Result)this.store.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.notIn(itemids_pretixpos).and(Item.TICKET_LAYOUT_PRETIXPOS_ID.eq((Object)obj.getServer_id()))).get()).toList() : ((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.TICKET_LAYOUT_PRETIXPOS_ID.eq((Object)obj.getServer_id())).get()).toList();
        for (Item item : items_to_remove_pretixpos) {
            item.setTicket_layout_pretixpos_id(null);
            this.store.update(item, Item.TICKET_LAYOUT_PRETIXPOS_ID);
        }
        String remote_filename = jsonobj.optString("background");
        if (remote_filename != null && remote_filename.startsWith("http")) {
            String hash = HashUtils.toSHA1(remote_filename.getBytes());
            String local_filename = "ticketlayout_" + obj.getServer_id() + "_" + hash + ".pdf";
            if (obj.getBackground_filename() != null && !obj.getBackground_filename().equals(local_filename)) {
                this.fileStorage.delete(obj.getBackground_filename());
                obj.setBackground_filename(null);
            }
            if (!this.fileStorage.contains(local_filename)) {
                try {
                    int byteread;
                    PretixApi.ApiResponse file = this.api.downloadFile(remote_filename);
                    OutputStream os = this.fileStorage.writeStream(local_filename);
                    InputStream is = file.getResponse().body().byteStream();
                    byte[] buffer = new byte[1444];
                    while ((byteread = is.read(buffer)) != -1) {
                        os.write(buffer, 0, byteread);
                    }
                    is.close();
                    os.close();
                    obj.setBackground_filename(local_filename);
                }
                catch (ApiException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.fileStorage.delete(local_filename);
                }
            } else {
                obj.setBackground_filename(local_filename);
            }
        } else if (obj.getBackground_filename() != null) {
            this.fileStorage.delete(obj.getBackground_filename());
            obj.setBackground_filename(null);
        }
    }

    @Override
    protected void prepareDelete(TicketLayout obj) {
        super.prepareDelete(obj);
        if (obj.getBackground_filename() != null) {
            this.fileStorage.delete(obj.getBackground_filename());
        }
    }

    @Override
    public CloseableIterator<TicketLayout> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(TicketLayout.class, new QueryAttribute[0]).where(TicketLayout.EVENT_SLUG.eq((Object)this.eventSlug)).and(TicketLayout.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(TicketLayout.SERVER_ID).where(TicketLayout.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "ticketlayouts";
    }

    @Override
    protected JSONObject preprocessObject(JSONObject obj) {
        try {
            obj.put("_written_after_20200123", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(TicketLayout obj) {
        return obj.getServer_id();
    }

    @Override
    TicketLayout newEmptyObject() {
        return new TicketLayout();
    }
}

