/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.sql.BoundParameters;
import io.requery.sql.StatementListener;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

class CompositeStatementListener
implements StatementListener {
    private final Set<StatementListener> listeners = new HashSet<StatementListener>();

    CompositeStatementListener(Set<StatementListener> listeners) {
        if (listeners != null) {
            this.listeners.addAll(listeners);
        }
    }

    public void add(StatementListener listener) {
        this.listeners.add(listener);
    }

    public void remove(StatementListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void beforeExecuteUpdate(Statement statement, String sql, BoundParameters parameters2) {
        for (StatementListener interceptor : this.listeners) {
            interceptor.beforeExecuteUpdate(statement, sql, parameters2);
        }
    }

    @Override
    public void afterExecuteUpdate(Statement statement, int count) {
        for (StatementListener interceptor : this.listeners) {
            interceptor.afterExecuteUpdate(statement, count);
        }
    }

    @Override
    public void beforeExecuteBatchUpdate(Statement statement, String sql) {
        for (StatementListener interceptor : this.listeners) {
            interceptor.beforeExecuteBatchUpdate(statement, sql);
        }
    }

    @Override
    public void afterExecuteBatchUpdate(Statement statement, int[] count) {
        for (StatementListener interceptor : this.listeners) {
            interceptor.afterExecuteBatchUpdate(statement, count);
        }
    }

    @Override
    public void beforeExecuteQuery(Statement statement, String sql, BoundParameters parameters2) {
        for (StatementListener interceptor : this.listeners) {
            interceptor.beforeExecuteQuery(statement, sql, parameters2);
        }
    }

    @Override
    public void afterExecuteQuery(Statement statement) {
        for (StatementListener interceptor : this.listeners) {
            interceptor.afterExecuteQuery(statement);
        }
    }
}

