/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.EntityCache;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

class TransactionEntitiesSet
extends LinkedHashSet<EntityProxy<?>> {
    private final EntityCache cache;
    private final Set<Type<?>> types;

    TransactionEntitiesSet(EntityCache cache) {
        this.cache = cache;
        this.types = new HashSet();
    }

    @Override
    public boolean add(EntityProxy<?> proxy) {
        if (super.add(proxy)) {
            this.types.add(proxy.type());
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.types.clear();
    }

    void clearAndInvalidate() {
        for (EntityProxy proxy : this) {
            proxy.unlink();
            Object key = proxy.key();
            if (key == null) continue;
            this.cache.invalidate(proxy.type().getClassType(), key);
        }
        this.clear();
    }

    Set<Type<?>> types() {
        return this.types;
    }
}

