/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.check;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.HttpClientFactory;
import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.serialization.JSONArrayDeserializer;
import eu.pretix.libpretixsync.serialization.JSONArraySerializer;
import eu.pretix.libpretixsync.serialization.JSONObjectDeserializer;
import eu.pretix.libpretixsync.serialization.JSONObjectSerializer;
import eu.pretix.libpretixsync.utils.NetUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u0011J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00172\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010)\u001a\u00020*H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Leu/pretix/libpretixsync/check/ProxyCheckProvider;", "Leu/pretix/libpretixsync/check/TicketCheckProvider;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "httpClientFactory", "Leu/pretix/libpretixsync/api/HttpClientFactory;", "dataStore", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "listId", "", "(Leu/pretix/libpretixsync/config/ConfigStore;Leu/pretix/libpretixsync/api/HttpClientFactory;Lio/requery/BlockingEntityStore;J)V", "client", "Lokhttp3/OkHttpClient;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "check", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckResult;", "ticketid", "", "answers", "", "Leu/pretix/libpretixsync/db/Answer;", "ignore_unpaid", "", "with_badge_data", "type", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;", "execute", "r", "Lokhttp3/Request;", "getSentry", "search", "Leu/pretix/libpretixsync/check/TicketCheckProvider$SearchResult;", "query", "page", "", "setSentry", "", "status", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "libpretixsync"})
public final class ProxyCheckProvider
implements TicketCheckProvider {
    @NotNull
    private final ConfigStore config;
    @NotNull
    private SentryInterface sentry;
    private final long listId;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final ObjectMapper mapper;

    public ProxyCheckProvider(@NotNull ConfigStore config, @NotNull HttpClientFactory httpClientFactory, @NotNull BlockingEntityStore<Persistable> dataStore, long listId) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(httpClientFactory, "httpClientFactory");
        Intrinsics.checkNotNullParameter(dataStore, "dataStore");
        this.config = config;
        this.sentry = new DummySentryImplementation();
        this.listId = listId;
        OkHttpClient okHttpClient = httpClientFactory.buildClient(NetUtils.ignoreSSLforURL(this.config.getApiUrl()));
        Intrinsics.checkNotNullExpressionValue(okHttpClient, "httpClientFactory.buildC\u2026SSLforURL(config.apiUrl))");
        this.client = okHttpClient;
        this.mapper = new ObjectMapper();
        SimpleModule m = new SimpleModule();
        m.addDeserializer(JSONObject.class, new JSONObjectDeserializer(null, 1, null));
        m.addDeserializer(JSONArray.class, new JSONArrayDeserializer(null, 1, null));
        m.addSerializer(JSONObject.class, new JSONObjectSerializer(null, 1, null));
        m.addSerializer(JSONArray.class, new JSONArraySerializer(null, 1, null));
        this.mapper.registerModule(m);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @NotNull
    public final SentryInterface getSentry() {
        return this.sentry;
    }

    @Override
    public void setSentry(@NotNull SentryInterface sentry) {
        Intrinsics.checkNotNullParameter(sentry, "sentry");
        this.sentry = sentry;
    }

    private final String execute(Request r) throws ApiException, CheckException {
        String e3;
        Response response;
        Response response2 = null;
        try {
            response = this.client.newCall(r).execute();
        }
        catch (SSLException e2) {
            e2.printStackTrace();
            throw new ApiException("Error while creating a secure connection.", e2);
        }
        catch (IOException e3) {
            e3.printStackTrace();
            throw new ApiException(Intrinsics.stringPlus("Connection error: ", e3.getMessage()), e3);
        }
        response2 = response;
        this.sentry.addHttpBreadcrumb(r.url().toString(), r.method(), response2.code());
        String body2 = "";
        try {
            ResponseBody responseBody = response2.body();
            Intrinsics.checkNotNull(responseBody);
            e3 = responseBody.string();
        }
        catch (IOException e4) {
            e4.printStackTrace();
            throw new ApiException(Intrinsics.stringPlus("Connection error: ", e4.getMessage()), e4);
        }
        body2 = e3;
        if (response2.code() >= 500) {
            response2.close();
            throw new ApiException(Intrinsics.stringPlus("Server error: ", response2.code()));
        }
        if (response2.code() == 404) {
            response2.close();
            throw new ApiException("Server error: Resource not found.");
        }
        if (response2.code() == 403) {
            response2.close();
            throw new ApiException("Server error: Permission denied.");
        }
        if (response2.code() >= 400) {
            response2.close();
            try {
                throw new CheckException(new JSONObject("body").optString("title", "?"), null, 2, null);
            }
            catch (JSONException e5) {
                throw new ApiException(body2);
            }
        }
        if (response2.code() >= 405) {
            response2.close();
            throw new ApiException("Server error: " + response2.code() + '.');
        }
        return body2;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull String ticketid, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean with_badge_data, @NotNull TicketCheckProvider.CheckInType type2) {
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Map data2 = new HashMap();
        Object object = data2;
        String string = "ticketid";
        boolean bl = false;
        object.put(string, ticketid);
        object = data2;
        string = "answers";
        Object object2 = answers;
        object2 = object2 == null ? CollectionsKt.emptyList() : object2;
        boolean bl2 = false;
        object.put(string, object2);
        object = data2;
        string = "ignore_unpaid";
        object2 = ignore_unpaid;
        bl2 = false;
        object.put(string, object2);
        object = data2;
        string = "with_badge_data";
        object2 = with_badge_data;
        bl2 = false;
        object.put(string, object2);
        object = data2;
        string = "type";
        boolean bl3 = false;
        object.put(string, type2);
        try {
            Request.Builder builder = new Request.Builder().url(this.config.getApiUrl() + "/proxyapi/v1/rpc/" + this.config.getEventSlug() + '/' + this.listId + "/check/");
            String string2 = this.mapper.writeValueAsString(data2);
            Intrinsics.checkNotNullExpressionValue(string2, "mapper.writeValueAsString(data)");
            Request request = builder.post(RequestBody.Companion.create(string2, MediaType.Companion.get("application/json"))).header("Authorization", Intrinsics.stringPlus("Device ", this.config.getApiKey())).build();
            String body2 = this.execute(request);
            object = this.mapper.readValue(body2, TicketCheckProvider.CheckResult.class);
            Intrinsics.checkNotNullExpressionValue(object, "{\n            val reques\u2026lt::class.java)\n        }");
            object = (TicketCheckProvider.CheckResult)object;
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", Intrinsics.stringPlus("API Error: ", e.getMessage()));
            object = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            object = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            object = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage());
        }
        catch (CheckException e) {
            object = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, e.getMessage());
        }
        return object;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull String ticketid) {
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        return this.check(ticketid, new ArrayList(), false, true, TicketCheckProvider.CheckInType.ENTRY);
    }

    @Override
    @NotNull
    public List<TicketCheckProvider.SearchResult> search(@NotNull String query, int page) throws CheckException {
        Intrinsics.checkNotNullParameter(query, "query");
        Map data2 = new HashMap();
        Object object = data2;
        String string = "query";
        boolean bl = false;
        object.put(string, query);
        object = data2;
        string = "page";
        Integer n = page;
        boolean bl2 = false;
        object.put(string, n);
        try {
            Request.Builder builder = new Request.Builder().url(this.config.getApiUrl() + "/proxyapi/v1/rpc/" + this.config.getEventSlug() + '/' + this.listId + "/search/");
            string = this.mapper.writeValueAsString(data2);
            Intrinsics.checkNotNullExpressionValue(string, "mapper.writeValueAsString(data)");
            Request request = builder.post(RequestBody.Companion.create(string, MediaType.Companion.get("application/json"))).header("Authorization", Intrinsics.stringPlus("Device ", this.config.getApiKey())).build();
            String body2 = this.execute(request);
            ObjectMapper $this$readValue$iv = this.mapper;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = (List)$this$readValue$iv.readValue(body2, (TypeReference)new TypeReference<List<? extends TicketCheckProvider.SearchResult>>(){});
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.search", Intrinsics.stringPlus("API Error: ", e.getMessage()));
            throw new CheckException(e.getMessage(), e);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        return object;
    }

    @Override
    @NotNull
    public TicketCheckProvider.StatusResult status() throws CheckException {
        TicketCheckProvider.StatusResult statusResult;
        Request request = new Request.Builder().url(this.config.getApiUrl() + "/proxyapi/v1/rpc/" + this.config.getEventSlug() + '/' + this.listId + "/status/").header("Authorization", Intrinsics.stringPlus("Device ", this.config.getApiKey())).build();
        try {
            String body2 = this.execute(request);
            statusResult = this.mapper.readValue(body2, TicketCheckProvider.StatusResult.class);
            Intrinsics.checkNotNullExpressionValue(statusResult, "{\n            val body =\u2026lt::class.java)\n        }");
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("provider.status", Intrinsics.stringPlus("API Error: ", e.getMessage()));
            throw new CheckException(e.getMessage(), e);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CheckException(e.getMessage(), e);
        }
        return statusResult;
    }
}

