/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.utils.I18nString;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Key;
import io.requery.Nullable;
import java.math.BigDecimal;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractSubEvent
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public Long server_id;
    public String event_slug;
    public Date date_from;
    @Nullable
    public Date date_to;
    public boolean active;
    @Column(definition="TEXT")
    public String json_data;

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    public boolean hasSeating() {
        try {
            return !this.getJSON().isNull("seating_plan");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public String getName() {
        try {
            return I18nString.toString(this.getJSON().getJSONObject("name"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public BigDecimal getPriceForItem(Long item_id, BigDecimal original_price) throws JSONException {
        JSONObject jd = this.getJSON();
        JSONArray ja = jd.getJSONArray("item_price_overrides");
        for (int i2 = 0; i2 < ja.length(); ++i2) {
            JSONObject or = ja.getJSONObject(i2);
            if (or.getLong("item") != item_id.longValue()) continue;
            if (or.isNull("price")) {
                return original_price;
            }
            return new BigDecimal(or.getString("price"));
        }
        return original_price;
    }

    public BigDecimal getPriceForVariation(Long var_id, BigDecimal original_price) throws JSONException {
        JSONObject jd = this.getJSON();
        JSONArray ja = jd.getJSONArray("variation_price_overrides");
        for (int i2 = 0; i2 < ja.length(); ++i2) {
            JSONObject or = ja.getJSONObject(i2);
            if (or.getLong("variation") != var_id.longValue()) continue;
            if (or.isNull("price")) {
                return original_price;
            }
            return new BigDecimal(or.getString("price"));
        }
        return original_price;
    }
}

