/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.TaxRule;
import eu.pretix.libpretixsync.sync.BaseConditionalSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TaxRuleSyncAdapter
extends BaseConditionalSyncAdapter<TaxRule, Long> {
    public TaxRuleSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, PretixApi api, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage, eventSlug, api, feedback);
    }

    @Override
    public void updateObject(TaxRule obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setJson_data(jsonobj.toString());
    }

    @Override
    public CloseableIterator<TaxRule> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(TaxRule.class, new QueryAttribute[0]).where(TaxRule.EVENT_SLUG.eq((Object)this.eventSlug)).and(TaxRule.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(TaxRule.SERVER_ID).where(TaxRule.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "taxrules";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(TaxRule obj) {
        return obj.getServer_id();
    }

    @Override
    TaxRule newEmptyObject() {
        return new TaxRule();
    }
}

