/*
 * Decompiled with CFR 0.152.
 */
package io.requery.util;

public enum LanguageVersion {
    JAVA_1_5,
    JAVA_1_6,
    JAVA_1_7,
    JAVA_1_8,
    JAVA_1_9;

    private static LanguageVersion version;

    public static LanguageVersion current() {
        return version;
    }

    public boolean atLeast(LanguageVersion version) {
        return this.ordinal() >= version.ordinal();
    }

    static {
        try {
            String specificationVersion;
            switch (specificationVersion = System.getProperty("java.specification.version")) {
                case "0.9": {
                    version = JAVA_1_7;
                    break;
                }
                case "1.5": {
                    version = JAVA_1_5;
                    break;
                }
                case "1.6": {
                    version = JAVA_1_6;
                    break;
                }
                case "1.7": {
                    version = JAVA_1_7;
                    break;
                }
                case "1.8": {
                    version = JAVA_1_8;
                    break;
                }
                case "1.9": {
                    version = JAVA_1_9;
                    break;
                }
                default: {
                    version = JAVA_1_8;
                    break;
                }
            }
        }
        catch (SecurityException se) {
            version = JAVA_1_7;
        }
    }
}

