/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.sync.BaseConditionalSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.HashUtils;
import eu.pretix.libpretixsync.utils.JSONUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemSyncAdapter
extends BaseConditionalSyncAdapter<Item, Long> {
    public ItemSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, PretixApi api, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage, eventSlug, api, feedback);
    }

    @Override
    public void updateObject(Item obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setPosition(jsonobj.getLong("position"));
        obj.setCategory_id(jsonobj.optLong("category"));
        obj.setAdmission(jsonobj.optBoolean("admission", false));
        obj.setActive(jsonobj.optBoolean("active", true));
        obj.setJson_data(jsonobj.toString());
        String remote_filename = jsonobj.optString("picture");
        if (remote_filename != null && remote_filename.startsWith("http")) {
            String hash = HashUtils.toSHA1(remote_filename.getBytes());
            String local_filename = "item_" + obj.getServer_id() + "_" + hash + remote_filename.substring(remote_filename.lastIndexOf("."));
            if (obj.getPicture_filename() != null && !obj.getPicture_filename().equals(local_filename)) {
                this.fileStorage.delete(obj.getPicture_filename());
                obj.setPicture_filename(null);
            }
            if (!this.fileStorage.contains(local_filename)) {
                try {
                    int byteread;
                    PretixApi.ApiResponse file = this.api.downloadFile(remote_filename);
                    OutputStream os = this.fileStorage.writeStream(local_filename);
                    InputStream is = file.getResponse().body().byteStream();
                    byte[] buffer = new byte[1444];
                    while ((byteread = is.read(buffer)) != -1) {
                        os.write(buffer, 0, byteread);
                    }
                    is.close();
                    os.close();
                    obj.setPicture_filename(local_filename);
                }
                catch (ApiException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.fileStorage.delete(local_filename);
                }
            } else {
                obj.setPicture_filename(local_filename);
            }
        } else if (obj.getPicture_filename() != null) {
            this.fileStorage.delete(obj.getPicture_filename());
            obj.setPicture_filename(null);
        }
    }

    @Override
    public CloseableIterator<Item> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(Item.class, new QueryAttribute[0]).where(Item.EVENT_SLUG.eq((Object)this.eventSlug)).and(Item.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(Item.SERVER_ID).where(Item.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "items";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(Item obj) {
        return obj.getServer_id();
    }

    @Override
    Item newEmptyObject() {
        return new Item();
    }

    public void standaloneRefreshFromJSON(JSONObject data2) throws JSONException {
        Item obj = ((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.SERVER_ID.eq((Object)data2.getLong("id"))).get()).firstOr(this.newEmptyObject());
        JSONObject old = null;
        if (obj.getId() != null) {
            old = obj.getJSON();
        }
        if (old == null) {
            this.updateObject(obj, data2);
            this.store.insert(obj);
        } else if (!JSONUtils.similar(data2, (Object)old)) {
            this.updateObject(obj, data2);
            this.store.update(obj);
        }
    }
}

