/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.sql.ConnectionDelegate;
import io.requery.sql.PreparedStatementCache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class StatementCachingConnection
extends ConnectionDelegate {
    private final PreparedStatementCache statementCache;

    StatementCachingConnection(PreparedStatementCache cache, Connection connection) {
        super(connection);
        this.statementCache = cache;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement statement = this.statementCache.get(sql);
        if (statement != null && statement.getResultSetType() == resultSetType && statement.getResultSetConcurrency() == resultSetConcurrency && statement.getResultSetHoldability() == resultSetHoldability) {
            return statement;
        }
        statement = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.statementCache.put(sql, statement);
    }
}

