/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.WhereAndOr;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseConditionalSyncAdapter<T extends RemoteObject & Persistable, K>
extends BaseDownloadSyncAdapter<T, K> {
    private PretixApi.ApiResponse firstResponse;

    public BaseConditionalSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage, eventSlug, api, syncCycleId, feedback);
    }

    @Override
    protected JSONObject downloadPage(String url, boolean isFirstPage) throws ApiException, ResourceNotModified {
        ResourceSyncStatus resourceSyncStatus = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.getResourceName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
        if (resourceSyncStatus == null) {
            resourceSyncStatus = new ResourceSyncStatus();
        } else if (!(this.getMeta().equals(resourceSyncStatus.getMeta()) || this.getMeta().equals("") && resourceSyncStatus.getMeta() == null)) {
            this.store.delete(resourceSyncStatus);
            resourceSyncStatus = new ResourceSyncStatus();
        }
        PretixApi.ApiResponse apiResponse = this.api.fetchResource(url, resourceSyncStatus.getLast_modified());
        if (isFirstPage) {
            this.firstResponse = apiResponse;
        }
        return apiResponse.getData();
    }

    public String getMeta() {
        return "";
    }

    @Override
    public void download() throws JSONException, ApiException, ExecutionException, InterruptedException {
        this.firstResponse = null;
        super.download();
        if (this.firstResponse != null) {
            ResourceSyncStatus resourceSyncStatus = (ResourceSyncStatus)((Result)((WhereAndOr)this.store.select(ResourceSyncStatus.class, new QueryAttribute[0]).where(ResourceSyncStatus.RESOURCE.eq((Object)this.getResourceName())).and(ResourceSyncStatus.EVENT_SLUG.eq((Object)this.eventSlug))).limit(1).get()).firstOrNull();
            if (resourceSyncStatus == null) {
                resourceSyncStatus = new ResourceSyncStatus();
                resourceSyncStatus.setResource(this.getResourceName());
                resourceSyncStatus.setEvent_slug(this.eventSlug);
                resourceSyncStatus.setMeta(this.getMeta());
            }
            if (this.firstResponse.getResponse().header("Last-Modified") != null) {
                resourceSyncStatus.setLast_modified(this.firstResponse.getResponse().header("Last-Modified"));
                resourceSyncStatus.setMeta(this.getMeta());
                this.store.upsert(resourceSyncStatus);
            }
            this.firstResponse = null;
        }
    }
}

