/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.DeviceAccessRevokedException;
import eu.pretix.libpretixsync.api.NotFoundApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.api.ResourceNotModified;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.CheckIn;
import eu.pretix.libpretixsync.db.Closing;
import eu.pretix.libpretixsync.db.Order;
import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.db.QueuedCall;
import eu.pretix.libpretixsync.db.QueuedCheckIn;
import eu.pretix.libpretixsync.db.QueuedOrder;
import eu.pretix.libpretixsync.db.Receipt;
import eu.pretix.libpretixsync.db.ReceiptLine;
import eu.pretix.libpretixsync.db.ReceiptPayment;
import eu.pretix.libpretixsync.db.ResourceSyncStatus;
import eu.pretix.libpretixsync.sync.AllSubEventsSyncAdapter;
import eu.pretix.libpretixsync.sync.BadgeLayoutItemSyncAdapter;
import eu.pretix.libpretixsync.sync.BadgeLayoutSyncAdapter;
import eu.pretix.libpretixsync.sync.CashierSyncAdapter;
import eu.pretix.libpretixsync.sync.CheckInListSyncAdapter;
import eu.pretix.libpretixsync.sync.DownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.EventSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.InvoiceSettingsSyncAdapter;
import eu.pretix.libpretixsync.sync.ItemCategorySyncAdapter;
import eu.pretix.libpretixsync.sync.ItemSyncAdapter;
import eu.pretix.libpretixsync.sync.OrderSyncAdapter;
import eu.pretix.libpretixsync.sync.QuestionSyncAdapter;
import eu.pretix.libpretixsync.sync.QuotaSyncAdapter;
import eu.pretix.libpretixsync.sync.RevokedTicketSecretSyncAdapter;
import eu.pretix.libpretixsync.sync.SettingsSyncAdapter;
import eu.pretix.libpretixsync.sync.SyncException;
import eu.pretix.libpretixsync.sync.TaxRuleSyncAdapter;
import eu.pretix.libpretixsync.sync.TicketLayoutSyncAdapter;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Scalar;
import io.requery.query.WhereAndOr;
import io.requery.sql.StatementExecutionException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SyncManager {
    protected SentryInterface sentry;
    protected PretixApi api;
    protected ConfigStore configStore;
    protected long upload_interval;
    protected long download_interval;
    protected BlockingEntityStore<Persistable> dataStore;
    protected FileStorage fileStorage;
    protected Profile profile;
    protected boolean with_pdf_data;
    protected CanceledState canceled;
    protected int app_version;
    protected String hardware_brand;
    protected String hardware_model;
    protected String software_brand;
    protected String software_version;
    public List<String> keepSlugs;
    protected CheckConnectivityFeedback connectivityFeedback;

    public SyncManager(ConfigStore configStore, PretixApi api, SentryInterface sentry, BlockingEntityStore<Persistable> dataStore, FileStorage fileStorage, long upload_interval, long download_interval, Profile profile, boolean with_pdf_data, int app_version, String hardware_brand, String hardware_model, String software_brand, String software_version, CheckConnectivityFeedback connectivityFeedback) {
        this.configStore = configStore;
        this.api = api;
        this.sentry = sentry;
        this.upload_interval = upload_interval;
        this.download_interval = download_interval;
        this.dataStore = dataStore;
        this.fileStorage = fileStorage;
        this.profile = profile;
        this.with_pdf_data = with_pdf_data;
        this.canceled = new CanceledState();
        this.app_version = app_version;
        this.hardware_brand = hardware_brand;
        this.hardware_model = hardware_model;
        this.software_brand = software_brand;
        this.software_version = software_version;
        this.connectivityFeedback = connectivityFeedback;
        this.keepSlugs = new ArrayList<String>();
        this.keepSlugs.add(configStore.getEventSlug());
    }

    public SyncResult sync(boolean force) throws EventSwitchRequested {
        return this.sync(force, null, null);
    }

    public SyncResult sync(boolean force, ProgressFeedback feedback) {
        if (!this.configStore.isConfigured()) {
            return new SyncResult(false, false);
        }
        if (this.configStore.getAutoSwitchRequested().booleanValue()) {
            throw new RuntimeException("Invalid call: If auto switch is requested, a list ID needs to be supplied");
        }
        try {
            return this.sync(force, -1L, feedback);
        }
        catch (EventSwitchRequested eventSwitchRequested) {
            throw new RuntimeException("Invalid call: If auto switch is requested, a list ID needs to be supplied");
        }
    }

    public SyncResult sync(boolean force, Long listId, ProgressFeedback feedback) throws EventSwitchRequested {
        if (!this.configStore.isConfigured()) {
            return new SyncResult(false, false);
        }
        if (!force && System.currentTimeMillis() - this.configStore.getLastSync() < this.upload_interval) {
            return new SyncResult(false, false);
        }
        if (!force && System.currentTimeMillis() - this.configStore.getLastFailedSync() < 30000L) {
            return new SyncResult(false, false);
        }
        this.bumpKnownVersion();
        this.canceled.setCanceled(false);
        boolean download = force || System.currentTimeMillis() - this.configStore.getLastDownload() > this.download_interval;
        try {
            if (this.configStore.getAutoSwitchRequested().booleanValue()) {
                if (feedback != null) {
                    feedback.postFeedback("Checking for other event\u2026");
                }
                this.checkEventSelection(listId);
            }
            if (feedback != null) {
                feedback.postFeedback("Uploading data\u2026");
            }
            this.upload();
            if (download) {
                if (feedback != null) {
                    feedback.postFeedback("Downloading data\u2026");
                }
                this.downloadData(feedback, false);
                this.configStore.setLastDownload(System.currentTimeMillis());
            }
            if (feedback != null) {
                feedback.postFeedback("Finishing touches\u2026");
            }
            this.configStore.setLastSync(System.currentTimeMillis());
            this.configStore.setLastFailedSync(0L);
            if (feedback != null) {
                feedback.postFeedback("Sync completed.");
            }
        }
        catch (StatementExecutionException e) {
            if (e.getCause() != null && e.getCause().getMessage().contains("SQLITE_BUSY")) {
                this.configStore.setLastFailedSync(System.currentTimeMillis());
                this.configStore.setLastFailedSyncMsg("Local database was locked");
            }
            throw e;
        }
        catch (SyncException e) {
            this.configStore.setLastFailedSync(System.currentTimeMillis());
            this.configStore.setLastFailedSyncMsg(e.getMessage());
        }
        return new SyncResult(true, download);
    }

    public SyncResult syncMinimalEventSet(ProgressFeedback feedback) {
        this.bumpKnownVersion();
        try {
            this.upload();
            this.downloadData(feedback, true);
            this.configStore.setLastDownload(0L);
            this.configStore.setLastSync(0L);
        }
        catch (SyncException e) {
            this.configStore.setLastFailedSync(System.currentTimeMillis());
            this.configStore.setLastFailedSyncMsg(e.getMessage());
        }
        return new SyncResult(true, true);
    }

    private void checkEventSelection(Long listId) throws EventSwitchRequested {
        try {
            PretixApi.ApiResponse resp;
            String query = "current_event=" + this.configStore.getEventSlug();
            if (this.configStore.getSubEventId() != null && this.configStore.getSubEventId() > 0L) {
                query = query + "&current_subevent=" + this.configStore.getSubEventId();
            }
            if (listId != null && listId > 0L) {
                query = query + "&current_checkinlist=" + listId;
            }
            if ((resp = this.api.fetchResource(this.api.apiURL("device/eventselection?" + query))).getResponse().code() == 200) {
                String eventSlug = resp.getData().getJSONObject("event").getString("slug");
                Long subeventId = resp.getData().isNull("subevent") ? 0L : resp.getData().optLong("subevent", 0L);
                Long checkinlistId = resp.getData().isNull("checkinlist") ? 0L : resp.getData().optLong("checkinlist", 0L);
                if (!(eventSlug.equals(this.configStore.getEventSlug()) && subeventId.equals(this.configStore.getSubEventId()) && checkinlistId.equals(listId))) {
                    throw new EventSwitchRequested(eventSlug, resp.getData().getJSONObject("event").getString("name"), subeventId, checkinlistId);
                }
            }
        }
        catch (ResourceNotModified query) {
        }
        catch (NotFoundApiException query) {
        }
        catch (ApiException | JSONException e) {
            this.configStore.setLastFailedSync(System.currentTimeMillis());
            this.configStore.setLastFailedSyncMsg(e.getMessage());
        }
    }

    private void bumpKnownVersion() {
        try {
            if (this.app_version != this.configStore.getDeviceKnownVersion()) {
                JSONObject apiBody = new JSONObject();
                apiBody.put("hardware_brand", this.hardware_brand);
                apiBody.put("hardware_model", this.hardware_model);
                apiBody.put("software_brand", this.software_brand);
                apiBody.put("software_version", this.software_version);
                PretixApi.ApiResponse resp = this.api.postResource(this.api.apiURL("device/update"), apiBody);
                this.configStore.setDeviceKnownVersion(this.app_version);
                this.configStore.setDeviceKnownName(resp.getData().getString("name"));
                String gate = null;
                if (resp.getData().has("gate") && !resp.getData().isNull("gate")) {
                    gate = resp.getData().getJSONObject("gate").getString("name");
                }
                this.configStore.setDeviceKnownGateName(gate);
            }
        }
        catch (ApiException | JSONException e) {
            this.configStore.setLastFailedSync(System.currentTimeMillis());
            this.configStore.setLastFailedSyncMsg(e.getMessage());
        }
        try {
            this.dataStore.raw("UPDATE checkin SET listId = list WHERE (listId IS NULL OR listID = 0) AND list IS NOT NULL AND list > 0", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void upload() throws SyncException {
        this.uploadOrders();
        if (this.canceled.isCanceled()) {
            throw new SyncException("Canceled");
        }
        this.uploadTicketData();
        if (this.canceled.isCanceled()) {
            throw new SyncException("Canceled");
        }
        this.uploadQueuedCalls();
        if (this.canceled.isCanceled()) {
            throw new SyncException("Canceled");
        }
        this.uploadReceipts();
        if (this.canceled.isCanceled()) {
            throw new SyncException("Canceled");
        }
        this.uploadClosings();
        if (this.canceled.isCanceled()) {
            throw new SyncException("Canceled");
        }
    }

    private void download(DownloadSyncAdapter adapter) throws InterruptedException, ExecutionException, ApiException, JSONException {
        adapter.setCancelState(this.canceled);
        adapter.download();
    }

    public void cancel() {
        this.canceled.setCanceled(true);
    }

    protected void downloadData(ProgressFeedback feedback, Boolean skip_orders) throws SyncException {
        this.sentry.addBreadcrumb("sync.queue", "Start download");
        try {
            OrderSyncAdapter osa;
            try {
                PretixApi.ApiResponse vresp = this.api.fetchResource(this.api.apiURL("version"));
                this.configStore.setKnownPretixVersion(vresp.getData().getLong("pretix_numeric"));
            }
            catch (ApiException | ResourceNotModified | JSONException e) {
                e.printStackTrace();
            }
            if (this.profile == Profile.PRETIXPOS) {
                try {
                    this.download(new CashierSyncAdapter(this.dataStore, this.fileStorage, this.api, this.configStore.getSyncCycleId(), feedback));
                }
                catch (NotFoundApiException e) {
                    // empty catch block
                }
                if (this.configStore.getEventSlug() == null) {
                    return;
                }
            }
            this.download(new EventSyncAdapter(this.dataStore, this.configStore.getEventSlug(), this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            this.download(new AllSubEventsSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            this.download(new ItemCategorySyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            this.download(new ItemSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            this.download(new QuestionSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            if (this.profile == Profile.PRETIXPOS) {
                this.download(new QuotaSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback, this.configStore.getSubEventId()));
                this.download(new TaxRuleSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
                this.download(new TicketLayoutSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            }
            this.download(new BadgeLayoutSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            try {
                this.download(new BadgeLayoutItemSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            }
            catch (ApiException e) {
                // empty catch block
            }
            this.download(new CheckInListSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback, this.configStore.getSubEventId()));
            if (this.profile == Profile.PRETIXSCAN || this.profile == Profile.PRETIXSCAN_ONLINE) {
                try {
                    this.download(new RevokedTicketSecretSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
                }
                catch (NotFoundApiException e) {
                    // empty catch block
                }
            }
            if (this.profile == Profile.PRETIXSCAN && !skip_orders.booleanValue()) {
                osa = new OrderSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.configStore.getSubEventId(), this.with_pdf_data, false, this.api, this.configStore.getSyncCycleId(), feedback);
                this.download(osa);
                if (System.currentTimeMillis() - this.configStore.getLastCleanup() > 43200000L) {
                    osa.deleteOldSubevents();
                    osa.deleteOldEvents(this.keepSlugs);
                    osa.deleteOldPdfImages();
                    this.configStore.setLastCleanup(System.currentTimeMillis());
                }
            } else if (this.profile == Profile.PRETIXSCAN_ONLINE) {
                ((Scalar)this.dataStore.delete(CheckIn.class).get()).value();
                ((Scalar)this.dataStore.delete(OrderPosition.class).get()).value();
                ((Scalar)this.dataStore.delete(Order.class).get()).value();
                ((Scalar)this.dataStore.delete(ResourceSyncStatus.class).where(ResourceSyncStatus.RESOURCE.like("order%")).get()).value();
                osa = new OrderSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.configStore.getSubEventId(), this.with_pdf_data, false, this.api, this.configStore.getSyncCycleId(), feedback);
                if (System.currentTimeMillis() - this.configStore.getLastCleanup() > 43200000L) {
                    osa.deleteOldPdfImages();
                    this.configStore.setLastCleanup(System.currentTimeMillis());
                }
            }
            try {
                this.download(new SettingsSyncAdapter(this.dataStore, this.configStore.getEventSlug(), this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
            }
            catch (ApiException e) {
                if (this.profile == Profile.PRETIXPOS) {
                    this.download(new InvoiceSettingsSyncAdapter(this.dataStore, this.configStore.getEventSlug(), this.configStore.getEventSlug(), this.api, this.configStore.getSyncCycleId(), feedback));
                }
            }
        }
        catch (DeviceAccessRevokedException e) {
            int deleted = 0;
            deleted += ((Integer)((Scalar)this.dataStore.delete(CheckIn.class).get()).value()).intValue();
            deleted += ((Integer)((Scalar)this.dataStore.delete(OrderPosition.class).get()).value()).intValue();
            deleted += ((Integer)((Scalar)this.dataStore.delete(Order.class).get()).value()).intValue();
            deleted += ((Integer)((Scalar)this.dataStore.delete(ResourceSyncStatus.class).get()).value()).intValue();
            throw new SyncException(e.getMessage());
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new SyncException("Unknown server response: " + e.getMessage());
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("sync.tickets", "API Error: " + e.getMessage());
            throw new SyncException(e.getMessage());
        }
        catch (ExecutionException e) {
            this.sentry.captureException(e);
            throw new SyncException(e.getMessage());
        }
        catch (InterruptedException e) {
            this.sentry.captureException(e);
            throw new SyncException(e.getMessage());
        }
    }

    protected void uploadQueuedCalls() throws SyncException {
        this.sentry.addBreadcrumb("sync.queue", "Start queuedcall upload");
        List calls = ((Result)this.dataStore.select(QueuedCall.class, new QueryAttribute[0]).get()).toList();
        String url = "";
        try {
            for (QueuedCall call : calls) {
                url = call.url;
                PretixApi.ApiResponse response = this.api.postResource(call.url, new JSONObject(call.body), call.idempotency_key);
                if (response.getResponse().code() < 500) {
                    this.dataStore.delete(call);
                    if (response.getResponse().code() < 400) continue;
                    this.sentry.captureException(new ApiException("Received response (" + response.getResponse().code() + ") for queued call: " + response.getData().toString()));
                    continue;
                }
                throw new SyncException(response.getData().toString());
            }
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            throw new SyncException("Unknown server response: " + e.getMessage());
        }
        catch (NotFoundApiException e) {
            if (!url.contains("/failed_checkins/")) {
                this.sentry.addBreadcrumb("sync.queue", "API Error: " + e.getMessage());
                throw new SyncException(e.getMessage());
            }
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("sync.queue", "API Error: " + e.getMessage());
            throw new SyncException(e.getMessage());
        }
        this.sentry.addBreadcrumb("sync.queue", "Receipt upload complete");
    }

    protected void uploadReceipts() throws SyncException {
        this.sentry.addBreadcrumb("sync.queue", "Start receipt upload");
        List receipts = ((Result)((WhereAndOr)this.dataStore.select(Receipt.class, new QueryAttribute[0]).where(Receipt.OPEN.eq((Object)false)).and(Receipt.SERVER_ID.isNull())).get()).toList();
        try {
            for (Receipt receipt : receipts) {
                JSONObject data2 = receipt.toJSON();
                JSONArray lines = new JSONArray();
                JSONArray payments = new JSONArray();
                for (ReceiptLine line : receipt.getLines()) {
                    lines.put(line.toJSON());
                }
                for (ReceiptPayment payment : receipt.getPayments()) {
                    payments.put(payment.toJSON());
                }
                data2.put("lines", lines);
                data2.put("payments", payments);
                PretixApi.ApiResponse response = this.api.postResource(this.api.organizerResourceUrl("posdevices/" + this.configStore.getPosId() + "/receipts"), data2);
                if (response.getResponse().code() == 201) {
                    receipt.setServer_id(response.getData().getLong("receipt_id"));
                    this.dataStore.update(receipt);
                    continue;
                }
                throw new SyncException(response.getData().toString());
            }
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            throw new SyncException("Unknown server response: " + e.getMessage());
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("sync.queue", "API Error: " + e.getMessage());
            throw new SyncException(e.getMessage());
        }
        this.sentry.addBreadcrumb("sync.queue", "Receipt upload complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadOrders() throws SyncException {
        this.sentry.addBreadcrumb("sync.queue", "Start order upload");
        List orders = ((Result)((WhereAndOr)this.dataStore.select(QueuedOrder.class, new QueryAttribute[0]).where(QueuedOrder.ERROR.isNull()).and(QueuedOrder.LOCKED.eq((Object)false))).get()).toList();
        try {
            for (QueuedOrder qo : orders) {
                qo.setLocked(true);
                this.dataStore.update(qo, QueuedOrder.LOCKED);
                try {
                    this.api.setEventSlug(qo.getEvent_slug());
                    Long startedAt = System.currentTimeMillis();
                    PretixApi.ApiResponse resp = this.api.postResource(this.api.eventResourceUrl("orders") + "?pdf_data=true&force=true", new JSONObject(qo.getPayload()), qo.getIdempotency_key());
                    if (resp.getResponse().code() == 201) {
                        Receipt r = qo.getReceipt();
                        r.setOrder_code(resp.getData().getString("code"));
                        this.dataStore.update(r, Receipt.ORDER_CODE);
                        this.dataStore.delete(qo);
                        new OrderSyncAdapter(this.dataStore, this.fileStorage, this.configStore.getEventSlug(), this.configStore.getSubEventId(), true, true, this.api, this.configStore.getSyncCycleId(), null).standaloneRefreshFromJSON(resp.getData());
                        if (this.connectivityFeedback == null) continue;
                        this.connectivityFeedback.recordSuccess(System.currentTimeMillis() - startedAt);
                        continue;
                    }
                    if (resp.getResponse().code() != 400) continue;
                    qo.setError(resp.getData().toString());
                    this.dataStore.update(qo);
                }
                finally {
                    this.api.setEventSlug(this.configStore.getEventSlug());
                }
            }
        }
        catch (JSONException e) {
            if (this.connectivityFeedback != null) {
                this.connectivityFeedback.recordError();
            }
            this.sentry.captureException(e);
            throw new SyncException("Unknown server response: " + e.getMessage());
        }
        catch (ApiException e) {
            if (this.connectivityFeedback != null) {
                this.connectivityFeedback.recordError();
            }
            this.sentry.addBreadcrumb("sync.queue", "API Error: " + e.getMessage());
            throw new SyncException(e.getMessage());
        }
        this.sentry.addBreadcrumb("sync.queue", "Receipt upload complete");
    }

    protected void uploadClosings() throws SyncException {
        this.sentry.addBreadcrumb("sync.queue", "Start closings upload");
        List closings = ((Result)((WhereAndOr)this.dataStore.select(Closing.class, new QueryAttribute[0]).where(Closing.OPEN.eq((Object)false)).and(Closing.SERVER_ID.isNull())).get()).toList();
        try {
            for (Closing closing : closings) {
                PretixApi.ApiResponse response = this.api.postResource(this.api.organizerResourceUrl("posdevices/" + this.configStore.getPosId() + "/closings"), closing.toJSON());
                if (response.getResponse().code() == 201) {
                    closing.setServer_id(response.getData().getLong("closing_id"));
                    this.dataStore.update(closing);
                    continue;
                }
                throw new SyncException(response.getData().toString());
            }
        }
        catch (JSONException e) {
            this.sentry.captureException(e);
            throw new SyncException("Unknown server response: " + e.getMessage());
        }
        catch (ApiException e) {
            this.sentry.addBreadcrumb("sync.queue", "API Error: " + e.getMessage());
            throw new SyncException(e.getMessage());
        }
        this.sentry.addBreadcrumb("sync.queue", "Closings upload complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadTicketData() throws SyncException {
        this.sentry.addBreadcrumb("sync.queue", "Start check-in upload");
        List queued = ((Result)this.dataStore.select(QueuedCheckIn.class, new QueryAttribute[0]).get()).toList();
        try {
            for (QueuedCheckIn qci : queued) {
                PretixApi.ApiResponse ar;
                ArrayList<Answer> answers = new ArrayList<Answer>();
                try {
                    JSONArray ja = new JSONArray(qci.getAnswers());
                    for (int i2 = 0; i2 < ja.length(); ++i2) {
                        JSONObject jo = ja.getJSONObject(i2);
                        Question q = new Question();
                        q.setServer_id(jo.getLong("question"));
                        answers.add(new Answer(q, jo.getString("answer"), null));
                    }
                }
                catch (JSONException ja) {
                    // empty catch block
                }
                try {
                    this.api.setEventSlug(qci.getEvent_slug());
                    Long startedAt = System.currentTimeMillis();
                    ar = qci.getDatetime_string() == null || qci.getDatetime_string().equals("") ? this.api.redeem(qci.getSecret(), qci.getDatetime(), true, qci.getNonce(), answers, (long)qci.checkinListId, false, false, qci.getType()) : this.api.redeem(qci.getSecret(), qci.getDatetime_string(), true, qci.getNonce(), answers, (long)qci.checkinListId, false, false, qci.getType());
                    if (this.connectivityFeedback != null) {
                        this.connectivityFeedback.recordSuccess(System.currentTimeMillis() - startedAt);
                    }
                }
                finally {
                    this.api.setEventSlug(this.configStore.getEventSlug());
                }
                JSONObject response = ar.getData();
                String status = response.optString("status", null);
                if ("ok".equals(status)) {
                    this.dataStore.delete(qci);
                    continue;
                }
                if (ar.getResponse().code() != 404 && ar.getResponse().code() != 400) continue;
                this.dataStore.delete(qci);
            }
        }
        catch (JSONException e) {
            if (this.connectivityFeedback != null) {
                this.connectivityFeedback.recordError();
            }
            this.sentry.captureException(e);
            throw new SyncException("Unknown server response: " + e.getMessage());
        }
        catch (NotFoundApiException e) {
        }
        catch (ApiException e) {
            if (this.connectivityFeedback != null) {
                this.connectivityFeedback.recordError();
            }
            this.sentry.addBreadcrumb("sync.tickets", "API Error: " + e.getMessage());
            throw new SyncException(e.getMessage());
        }
        this.sentry.addBreadcrumb("sync.queue", "Check-in upload complete");
    }

    public class SyncResult {
        private boolean dataUploaded;
        private boolean dataDownloaded;

        public SyncResult(boolean dataUploaded, boolean dataDownloaded) {
            this.dataUploaded = dataUploaded;
            this.dataDownloaded = dataDownloaded;
        }

        public boolean isDataUploaded() {
            return this.dataUploaded;
        }

        public boolean isDataDownloaded() {
            return this.dataDownloaded;
        }
    }

    public static class EventSwitchRequested
    extends Exception {
        public String eventSlug;
        public String eventName;
        public Long subeventId;
        public Long checkinlistId;

        public EventSwitchRequested(String eventSlug, String eventName, Long subeventId, Long checkinlistId) {
            this.eventSlug = eventSlug;
            this.eventName = eventName;
            this.subeventId = subeventId;
            this.checkinlistId = checkinlistId;
        }
    }

    public static interface CheckConnectivityFeedback {
        public void recordError();

        public void recordSuccess(Long var1);
    }

    public static interface ProgressFeedback {
        public void postFeedback(String var1);
    }

    public class CanceledState {
        private boolean canceled = false;

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }

    public static enum Profile {
        PRETIXPOS,
        PRETIXSCAN,
        PRETIXSCAN_ONLINE;

    }
}

