/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query;

import io.requery.proxy.CollectionChanges;
import io.requery.query.Expression;
import io.requery.query.MutableResult;
import io.requery.query.Result;
import io.requery.util.CloseableIterator;
import io.requery.util.CollectionObserver;
import io.requery.util.CompositeIterator;
import io.requery.util.FilteringIterator;
import io.requery.util.ObservableCollection;
import io.requery.util.function.Consumer;
import io.requery.util.function.Predicate;
import io.requery.util.function.Supplier;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ModifiableResult<E>
implements MutableResult<E>,
ObservableCollection<E> {
    private final Result<E> result;
    private final CollectionChanges<?, E> changes;

    public ModifiableResult(Result<E> result2, CollectionChanges<?, E> changes) {
        this.result = result2;
        this.changes = changes;
    }

    @Override
    public CollectionObserver<E> observer() {
        return this.changes;
    }

    @Override
    public void add(E element) {
        this.changes.elementAdded(element);
    }

    @Override
    public void remove(E element) {
        this.changes.elementRemoved(element);
    }

    @Override
    public CloseableIterator<E> iterator() {
        final Iterator queried = this.result == null ? Collections.emptyIterator() : this.result.iterator();
        Iterator<E> added = this.changes.addedElements().iterator();
        CompositeIterator composite = new CompositeIterator(queried, added);
        final FilteringIterator filtered = new FilteringIterator(composite, new Predicate<E>(){

            @Override
            public boolean test(E e) {
                return !ModifiableResult.this.changes.removedElements().contains(e);
            }
        });
        return new CloseableIterator<E>(){

            @Override
            public void close() {
                if (queried instanceof CloseableIterator) {
                    CloseableIterator closeable = (CloseableIterator)queried;
                    closeable.close();
                }
            }

            @Override
            public boolean hasNext() {
                return filtered.hasNext();
            }

            @Override
            public E next() {
                return filtered.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public CloseableIterator<E> iterator(int skip, int take) {
        return this.iterator();
    }

    @Override
    public void close() {
        if (this.result != null) {
            this.result.close();
        }
    }

    @Override
    public List<E> toList() {
        return this.result == null ? Collections.emptyList() : this.result.toList();
    }

    @Override
    public <C extends Collection<E>> C collect(C collection) {
        if (this.result != null) {
            return this.result.collect(collection);
        }
        return collection;
    }

    @Override
    public E first() throws NoSuchElementException {
        if (this.result == null) {
            throw new NoSuchElementException();
        }
        return this.result.first();
    }

    @Override
    public E firstOr(E defaultElement) {
        return this.result == null ? defaultElement : this.result.firstOr(defaultElement);
    }

    @Override
    public E firstOrNull() {
        return this.firstOr((E)null);
    }

    @Override
    public E firstOr(Supplier<E> supplier) {
        if (this.result != null) {
            return this.result.firstOr(supplier);
        }
        return supplier.get();
    }

    @Override
    public void each(Consumer<? super E> action) {
        if (this.result != null) {
            this.result.each(action);
        }
    }

    @Override
    public Stream<E> stream() {
        return this.result == null ? StreamSupport.stream(Spliterators.emptySpliterator(), false) : this.result.stream();
    }

    @Override
    public <K> Map<K, E> toMap(Expression<K> key) {
        return this.result == null ? Collections.emptyMap() : this.result.toMap(key);
    }

    @Override
    public <K> Map<K, E> toMap(Expression<K> key, Map<K, E> map2) {
        if (this.result != null) {
            return this.result.toMap(key, map2);
        }
        return map2;
    }
}

