/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.platform;

import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.query.Expression;
import io.requery.query.element.LimitedElement;
import io.requery.query.element.OrderByElement;
import io.requery.query.element.QueryElement;
import io.requery.query.function.Function;
import io.requery.query.function.Now;
import io.requery.sql.BaseType;
import io.requery.sql.GeneratedColumnDefinition;
import io.requery.sql.Keyword;
import io.requery.sql.Mapping;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.OffsetFetchGenerator;
import io.requery.sql.gen.OrderByGenerator;
import io.requery.sql.gen.Output;
import io.requery.sql.gen.UpsertMergeGenerator;
import io.requery.sql.platform.Generic;
import io.requery.sql.type.PrimitiveBooleanType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;

public class SQLServer
extends Generic {
    private final GeneratedColumnDefinition generatedColumnDefinition = new IdentityColumnDefinition();

    @Override
    public void addMappings(Mapping mapping) {
        super.addMappings(mapping);
        mapping.replaceType(16, new BitBooleanType());
        mapping.replaceType(93, new DateTime2TimeStampType());
        mapping.aliasFunction(new Function.Name("getutcdate"), Now.class);
    }

    @Override
    public boolean supportsIfExists() {
        return false;
    }

    @Override
    public GeneratedColumnDefinition generatedColumnDefinition() {
        return this.generatedColumnDefinition;
    }

    @Override
    public Generator<LimitedElement> limitGenerator() {
        return new OrderByOffsetFetchLimit();
    }

    @Override
    public Generator<Map<Expression<?>, Object>> upsertGenerator() {
        return new MergeGenerator();
    }

    @Override
    public Generator<OrderByElement> orderByGenerator() {
        return new OrderByWithLimitGenerator();
    }

    private static class DateTime2TimeStampType
    extends BaseType<Timestamp> {
        DateTime2TimeStampType() {
            super(Timestamp.class, 93);
        }

        @Override
        public Object getIdentifier() {
            return "datetime2";
        }
    }

    private static class BitBooleanType
    extends BaseType<Boolean>
    implements PrimitiveBooleanType {
        BitBooleanType() {
            super(Boolean.class, -7);
        }

        @Override
        public Object getIdentifier() {
            return "bit";
        }

        @Override
        public Boolean read(ResultSet results, int column) throws SQLException {
            Boolean value = results.getBoolean(column);
            return results.wasNull() ? null : value;
        }

        @Override
        public boolean readBoolean(ResultSet results, int column) throws SQLException {
            return results.getBoolean(column);
        }

        @Override
        public void writeBoolean(PreparedStatement statement, int index, boolean value) throws SQLException {
            statement.setBoolean(index, value);
        }
    }

    private static class OrderByOffsetFetchLimit
    extends OffsetFetchGenerator {
        private OrderByOffsetFetchLimit() {
        }

        @Override
        public void write(QueryBuilder qb, Integer limit, Integer offset) {
            super.write(qb, limit, offset == null ? 0 : offset);
        }
    }

    private static class IdentityColumnDefinition
    implements GeneratedColumnDefinition {
        private IdentityColumnDefinition() {
        }

        @Override
        public boolean skipTypeIdentifier() {
            return false;
        }

        @Override
        public boolean postFixPrimaryKey() {
            return false;
        }

        @Override
        public void appendGeneratedSequence(QueryBuilder qb, Attribute attribute) {
            int start2 = 1;
            int increment = 1;
            qb.keyword(Keyword.IDENTITY);
            qb.openParenthesis().value(start2).comma().value(increment).closeParenthesis();
        }
    }

    private class OrderByWithLimitGenerator
    extends OrderByGenerator {
        private OrderByWithLimitGenerator() {
        }

        private void forceOrderBy(QueryElement<?> query) {
            Set<Type<?>> types;
            if (query.getLimit() != null && (query.getOrderByExpressions() == null || query.getOrderByExpressions().isEmpty()) && (types = query.entityTypes()) != null && !types.isEmpty()) {
                Type<?> type2 = types.iterator().next();
                for (Attribute<?, ?> attribute : type2.getAttributes()) {
                    if (!attribute.isKey()) continue;
                    query.orderBy((Expression)((Object)attribute));
                    break;
                }
            }
        }

        @Override
        public void write(Output output, OrderByElement query) {
            if (query instanceof QueryElement) {
                this.forceOrderBy((QueryElement)query);
            }
            super.write(output, query);
        }
    }

    private static class MergeGenerator
    extends UpsertMergeGenerator {
        private MergeGenerator() {
        }

        @Override
        public void write(Output output, Map<Expression<?>, Object> values2) {
            super.write(output, values2);
            output.builder().append(";");
        }
    }
}

