/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.meta.Attribute;
import io.requery.query.Expression;
import io.requery.query.element.InsertType;
import io.requery.query.element.QueryElement;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;
import java.util.Map;

public class InsertGenerator
implements Generator<QueryElement<?>> {
    @Override
    public void write(final Output output, QueryElement<?> query) {
        Map<Expression<?>, Object> values2 = query.updateValues();
        InsertType insertType = query.insertType();
        QueryBuilder qb = output.builder();
        qb.keyword(Keyword.INSERT, Keyword.INTO);
        output.appendTables();
        if (values2.isEmpty()) {
            if (insertType == InsertType.VALUES) {
                qb.keyword(Keyword.DEFAULT, Keyword.VALUES);
            }
        } else {
            qb.openParenthesis().commaSeparated(values2.entrySet(), new QueryBuilder.Appender<Map.Entry<Expression<?>, Object>>(){

                @Override
                public void append(QueryBuilder qb, Map.Entry<Expression<?>, Object> value) {
                    Expression<?> key = value.getKey();
                    switch (key.getExpressionType()) {
                        case ATTRIBUTE: {
                            Attribute attribute = (Attribute)((Object)key);
                            if (attribute.isGenerated()) {
                                throw new IllegalStateException();
                            }
                            qb.attribute(attribute);
                            break;
                        }
                        default: {
                            qb.append(key.getName()).space();
                        }
                    }
                }
            }).closeParenthesis().space();
            if (insertType == InsertType.VALUES) {
                qb.keyword(Keyword.VALUES).openParenthesis().commaSeparated(values2.entrySet(), new QueryBuilder.Appender<Map.Entry<Expression<?>, Object>>(){

                    @Override
                    public void append(QueryBuilder qb, Map.Entry<Expression<?>, Object> value) {
                        output.appendConditionValue(value.getKey(), value.getValue());
                    }
                }).closeParenthesis();
            } else {
                output.appendQuery(query.subQuery());
            }
        }
    }
}

