/*
 * Decompiled with CFR 0.152.
 */
package io.requery.proxy;

import io.requery.proxy.EntityStateEventListeners;
import io.requery.proxy.EntityStateListener;
import io.requery.proxy.PostDeleteListener;
import io.requery.proxy.PostInsertListener;
import io.requery.proxy.PostLoadListener;
import io.requery.proxy.PostUpdateListener;
import io.requery.proxy.PreDeleteListener;
import io.requery.proxy.PreInsertListener;
import io.requery.proxy.PreUpdateListener;

class CompositeEntityStateListener<T>
extends EntityStateEventListeners<T>
implements EntityStateListener {
    private final T entity;

    CompositeEntityStateListener(T entity) {
        this.entity = entity;
    }

    @Override
    public void preUpdate() {
        for (PreUpdateListener listener : this.preUpdateListeners) {
            listener.preUpdate(this.entity);
        }
    }

    @Override
    public void postUpdate() {
        for (PostUpdateListener listener : this.postUpdateListeners) {
            listener.postUpdate(this.entity);
        }
    }

    @Override
    public void preInsert() {
        for (PreInsertListener listener : this.preInsertListeners) {
            listener.preInsert(this.entity);
        }
    }

    @Override
    public void postInsert() {
        for (PostInsertListener listener : this.postInsertListeners) {
            listener.postInsert(this.entity);
        }
    }

    @Override
    public void preDelete() {
        for (PreDeleteListener listener : this.preDeleteListeners) {
            listener.preDelete(this.entity);
        }
    }

    @Override
    public void postDelete() {
        for (PostDeleteListener listener : this.postDeleteListeners) {
            listener.postDelete(this.entity);
        }
    }

    @Override
    public void postLoad() {
        for (PostLoadListener listener : this.postLoadListeners) {
            listener.postLoad(this.entity);
        }
    }
}

