/*
 * Decompiled with CFR 0.152.
 */
package io.requery.meta;

import io.requery.meta.Attribute;
import io.requery.meta.BaseType;
import io.requery.meta.QueryExpression;
import io.requery.meta.TypeBuilder;
import io.requery.meta.TypeDeclarable;
import io.requery.util.function.Supplier;
import java.util.Collections;
import java.util.LinkedHashSet;

final class ImmutableType<T>
extends BaseType<T> {
    ImmutableType(TypeBuilder<T> builder) {
        this.type = builder.getClassType();
        this.baseType = builder.getBaseType();
        this.name = builder.getName();
        this.cacheable = builder.isCacheable();
        this.readOnly = builder.isReadOnly();
        this.immutable = builder.isImmutable();
        this.isView = builder.isView();
        this.stateless = builder.isStateless();
        this.factory = builder.getFactory();
        this.proxyProvider = builder.getProxyProvider();
        this.tableCreateAttributes = builder.getTableCreateAttributes();
        this.tableUniqueIndexes = builder.getTableUniqueIndexes();
        this.builderFactory = builder.getBuilderFactory();
        this.buildFunction = builder.getBuildFunction();
        LinkedHashSet<Attribute> attributes = new LinkedHashSet<Attribute>();
        LinkedHashSet<Attribute> keyAttributes = new LinkedHashSet<Attribute>();
        for (Attribute attribute : builder.getAttributes()) {
            this.setDeclaringType(attribute);
            attributes.add(attribute);
            if (!attribute.isKey()) continue;
            keyAttributes.add(attribute);
        }
        this.attributes = Collections.unmodifiableSet(attributes);
        this.keyAttributes = Collections.unmodifiableSet(keyAttributes);
        if (keyAttributes.size() == 1) {
            this.keyAttribute = (Attribute)keyAttributes.iterator().next();
        }
        this.expressions = Collections.unmodifiableSet(builder.expressions);
        for (QueryExpression expression : builder.expressions) {
            this.setDeclaringType(expression);
        }
        if (this.factory == null) {
            this.factory = new Supplier<T>(){

                @Override
                public T get() {
                    try {
                        return ImmutableType.this.getClassType().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    private void setDeclaringType(Object expression) {
        if (!(expression instanceof TypeDeclarable)) {
            throw new UnsupportedOperationException();
        }
        TypeDeclarable declarable = (TypeDeclarable)expression;
        declarable.setDeclaringType(this);
    }
}

