/*
 * Decompiled with CFR 0.152.
 */
package io.requery.meta;

import io.requery.meta.Attribute;
import io.requery.meta.BaseType;
import io.requery.meta.ImmutableType;
import io.requery.meta.QueryExpression;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.util.Objects;
import io.requery.util.function.Function;
import io.requery.util.function.Supplier;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.TreeSet;

public class TypeBuilder<T>
extends BaseType<T> {
    public TypeBuilder(Class<T> type2, String name) {
        Objects.requireNotNull(type2);
        this.type = type2;
        this.attributes = new TreeSet(new Comparator<Attribute<T, ?>>(){

            @Override
            public int compare(Attribute<T, ?> o1, Attribute<T, ?> o2) {
                if (o1.isKey()) {
                    return -1;
                }
                if (o2.isKey()) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.name = name;
        this.referencedTypes = new LinkedHashSet();
        this.expressions = new LinkedHashSet();
    }

    public TypeBuilder<T> setBaseType(Class<? super T> type2) {
        this.baseType = type2;
        return this;
    }

    public TypeBuilder<T> setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public TypeBuilder<T> setImmutable(boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public TypeBuilder<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public TypeBuilder<T> setStateless(boolean stateless) {
        this.stateless = stateless;
        return this;
    }

    public TypeBuilder<T> setView(boolean isView) {
        this.isView = isView;
        return this;
    }

    public TypeBuilder<T> setFactory(Supplier<T> factory) {
        this.factory = factory;
        return this;
    }

    public TypeBuilder<T> setProxyProvider(Function<T, EntityProxy<T>> provider) {
        this.proxyProvider = provider;
        return this;
    }

    public <B> TypeBuilder<T> setBuilderFactory(Supplier<B> factory) {
        this.builderFactory = factory;
        return this;
    }

    public <B> TypeBuilder<T> setBuilderFunction(Function<B, T> function2) {
        this.buildFunction = function2;
        return this;
    }

    public TypeBuilder<T> setTableCreateAttributes(String[] attributes) {
        this.tableCreateAttributes = attributes;
        return this;
    }

    public TypeBuilder<T> setTableUniqueIndexes(String[] indexes) {
        this.tableUniqueIndexes = indexes;
        return this;
    }

    public TypeBuilder<T> addAttribute(Attribute<T, ?> attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public TypeBuilder<T> addExpression(QueryExpression<?> expression) {
        this.expressions.add(expression);
        return this;
    }

    public Type<T> build() {
        return new ImmutableType(this);
    }
}

