/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class HMSpliterators {
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long VALUES_$0_OFF;
    private static final long KEYSET_$0_OFF;
    private static final long ENTRYSET_$0_OFF;
    private static final long HASHSET_MAP_OFF;

    private HMSpliterators() {
    }

    static <K> Spliterator<K> getKeySetSpliterator(Set<K> keySet) {
        return new KeySpliterator(HMSpliterators.getHashMapFromKeySet(keySet), 0, -1, 0, 0);
    }

    static <K, V> Spliterator<Map.Entry<K, V>> getEntrySetSpliterator(Set<Map.Entry<K, V>> entrySet) {
        return new EntrySpliterator<K, V>(HMSpliterators.getHashMapFromEntrySet(entrySet), 0, -1, 0, 0);
    }

    static <V> Spliterator<V> getValuesSpliterator(Collection<V> values2) {
        return new ValueSpliterator(HMSpliterators.getHashMapFromValues(values2), 0, -1, 0, 0);
    }

    static <E> Spliterator<E> getHashSetSpliterator(HashSet<E> hashSet) {
        return new KeySpliterator(HMSpliterators.getHashMapFromHashSet(hashSet), 0, -1, 0, 0);
    }

    private static <K, V> HashMap<K, V> getHashMapFromKeySet(Set<K> keySet) {
        return (HashMap)U.getObject(keySet, KEYSET_$0_OFF);
    }

    private static <K, V> HashMap<K, V> getHashMapFromEntrySet(Set<Map.Entry<K, V>> entrySet) {
        return (HashMap)U.getObject(entrySet, ENTRYSET_$0_OFF);
    }

    private static <K, V> HashMap<K, V> getHashMapFromValues(Collection<V> values2) {
        return (HashMap)U.getObject(values2, VALUES_$0_OFF);
    }

    private static <K, V> HashMap<K, V> getHashMapFromHashSet(HashSet<K> hashSet) {
        return (HashMap)U.getObject(hashSet, HASHSET_MAP_OFF);
    }

    static {
        try {
            Class<?> vc = Class.forName("java.util.HashMap$Values");
            Class<?> ksc = Class.forName("java.util.HashMap$KeySet");
            Class<?> esc = Class.forName("java.util.HashMap$EntrySet");
            VALUES_$0_OFF = U.objectFieldOffset(vc.getDeclaredField("this$0"));
            KEYSET_$0_OFF = U.objectFieldOffset(ksc.getDeclaredField("this$0"));
            ENTRYSET_$0_OFF = U.objectFieldOffset(esc.getDeclaredField("this$0"));
            HASHSET_MAP_OFF = U.objectFieldOffset(HashSet.class.getDeclaredField("map"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static abstract class HashMapSpliterator<K, V> {
        final HashMap<K, V> map;
        Object current;
        int index;
        int fence;
        int est;
        int expectedModCount;
        private static final Unsafe U = UnsafeAccess.unsafe;
        private static final long TABLE_OFF;
        private static final long MODCOUNT_OFF;
        private static final long NODE_KEY_OFF;
        private static final long NODE_VAL_OFF;
        private static final long NODE_NXT_OFF;

        HashMapSpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            this.map = m;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                HashMap<K, V> m = this.map;
                this.est = m.size();
                this.expectedModCount = HashMapSpliterator.getModCount(m);
                Object[] tab = HashMapSpliterator.getTable(m);
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            }
            return hi;
        }

        public abstract int characteristics();

        public final long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown((Spliterator)((Object)this));
        }

        public final boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics((Spliterator)((Object)this), characteristics);
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }

        static int getModCount(HashMap<?, ?> map2) {
            return U.getInt(map2, MODCOUNT_OFF);
        }

        static Object[] getTable(HashMap<?, ?> map2) {
            return (Object[])U.getObject(map2, TABLE_OFF);
        }

        static <K> K getNodeKey(Object node) {
            return (K)U.getObject(node, NODE_KEY_OFF);
        }

        static <T> T getNodeValue(Object node) {
            return (T)U.getObject(node, NODE_VAL_OFF);
        }

        static Object getNextNode(Object node) {
            return U.getObject(node, NODE_NXT_OFF);
        }

        static Class<?> nodeClass() throws ClassNotFoundException {
            String nodeName = "java.util.HashMap$" + (Spliterators.IS_ANDROID || Spliterators.HAS_STREAMS ? "Node" : "Entry");
            try {
                return Class.forName(nodeName);
            }
            catch (ClassNotFoundException e) {
                if (Spliterators.IS_ANDROID) {
                    return Class.forName("java.util.HashMap$HashMapEntry");
                }
                throw e;
            }
        }

        static {
            try {
                TABLE_OFF = U.objectFieldOffset(HashMap.class.getDeclaredField("table"));
                MODCOUNT_OFF = U.objectFieldOffset(HashMap.class.getDeclaredField("modCount"));
                Class<?> nc = HashMapSpliterator.nodeClass();
                NODE_KEY_OFF = U.objectFieldOffset(nc.getDeclaredField("key"));
                NODE_VAL_OFF = U.objectFieldOffset(nc.getDeclaredField("value"));
                NODE_NXT_OFF = U.objectFieldOffset(nc.getDeclaredField("next"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }

    private static final class EntrySpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                entrySpliterator = null;
            } else {
                this.index = mid;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            int i2;
            int mc;
            Objects.requireNonNull(action);
            HashMap m = this.map;
            Object[] tab = EntrySpliterator.getTable(m);
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = EntrySpliterator.getModCount(m);
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i2 = this.index) >= 0 && (i2 < (this.index = hi) || this.current != null)) {
                Object p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i2++];
                        continue;
                    }
                    action.accept((Map.Entry)p);
                    p = EntrySpliterator.getNextNode(p);
                } while (p != null || i2 < hi);
                if (mc != EntrySpliterator.getModCount(m)) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            int hi;
            Objects.requireNonNull(action);
            Object[] tab = EntrySpliterator.getTable(this.map);
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Map.Entry e = (Map.Entry)this.current;
                    this.current = EntrySpliterator.getNextNode(this.current);
                    action.accept(e);
                    if (this.expectedModCount != EntrySpliterator.getModCount(this.map)) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size() ? 64 : 0) | 1;
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> getComparator() {
            return Spliterators.getComparator(null);
        }
    }

    private static final class ValueSpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                valueSpliterator = null;
            } else {
                this.index = mid;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            int i2;
            int mc;
            Objects.requireNonNull(action);
            HashMap m = this.map;
            Object[] tab = ValueSpliterator.getTable(m);
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = ValueSpliterator.getModCount(m);
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i2 = this.index) >= 0 && (i2 < (this.index = hi) || this.current != null)) {
                Object p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i2++];
                        continue;
                    }
                    action.accept(HashMapSpliterator.getNodeValue(p));
                    p = ValueSpliterator.getNextNode(p);
                } while (p != null || i2 < hi);
                if (mc != ValueSpliterator.getModCount(m)) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            int hi;
            Objects.requireNonNull(action);
            Object[] tab = ValueSpliterator.getTable(this.map);
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object v = ValueSpliterator.getNodeValue(this.current);
                    this.current = ValueSpliterator.getNextNode(this.current);
                    action.accept(v);
                    if (this.expectedModCount != ValueSpliterator.getModCount(this.map)) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size() ? 64 : 0;
        }

        @Override
        public Comparator<? super V> getComparator() {
            return Spliterators.getComparator(null);
        }
    }

    private static final class KeySpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(HashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            int i2;
            int mc;
            Objects.requireNonNull(action);
            HashMap m = this.map;
            Object[] tab = KeySpliterator.getTable(m);
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = KeySpliterator.getModCount(m);
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i2 = this.index) >= 0 && (i2 < (this.index = hi) || this.current != null)) {
                Object p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i2++];
                        continue;
                    }
                    action.accept(HashMapSpliterator.getNodeKey(p));
                    p = KeySpliterator.getNextNode(p);
                } while (p != null || i2 < hi);
                if (mc != KeySpliterator.getModCount(m)) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            int hi;
            Objects.requireNonNull(action);
            Object[] tab = KeySpliterator.getTable(this.map);
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object k = KeySpliterator.getNodeKey(this.current);
                    this.current = KeySpliterator.getNextNode(this.current);
                    action.accept(k);
                    if (this.expectedModCount != KeySpliterator.getModCount(this.map)) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size() ? 64 : 0) | 1;
        }

        @Override
        public Comparator<? super K> getComparator() {
            return Spliterators.getComparator(null);
        }
    }
}

