/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.platform;

import io.requery.meta.Attribute;
import io.requery.query.Expression;
import io.requery.query.function.Function;
import io.requery.query.function.Random;
import io.requery.sql.AutoIncrementColumnDefinition;
import io.requery.sql.GeneratedColumnDefinition;
import io.requery.sql.Keyword;
import io.requery.sql.Mapping;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.LimitGenerator;
import io.requery.sql.gen.Output;
import io.requery.sql.platform.Generic;
import java.util.Map;

public class MySQL
extends Generic {
    private final AutoIncrementColumnDefinition autoIncrementColumn = new AutoIncrementColumnDefinition();

    @Override
    public void addMappings(Mapping mapping) {
        mapping.aliasFunction(new Function.Name("rand"), Random.class);
    }

    @Override
    public boolean supportsGeneratedKeysInBatchUpdate() {
        return true;
    }

    @Override
    public GeneratedColumnDefinition generatedColumnDefinition() {
        return this.autoIncrementColumn;
    }

    public LimitGenerator limitGenerator() {
        return new LimitGenerator();
    }

    @Override
    public Generator<Map<Expression<?>, Object>> upsertGenerator() {
        return new UpsertOnDuplicateKeyUpdate();
    }

    private static class UpsertOnDuplicateKeyUpdate
    implements Generator<Map<Expression<?>, Object>> {
        private UpsertOnDuplicateKeyUpdate() {
        }

        @Override
        public void write(final Output output, final Map<Expression<?>, Object> values2) {
            QueryBuilder qb = output.builder();
            qb.keyword(Keyword.INSERT, Keyword.INTO).tableNames(values2.keySet()).openParenthesis().commaSeparatedExpressions(values2.keySet()).closeParenthesis().space().keyword(Keyword.VALUES).openParenthesis().commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression expression) {
                    qb.append("?");
                    output.parameters().add(expression, values2.get(expression));
                }
            }).closeParenthesis().space().keyword(Keyword.ON, Keyword.DUPLICATE, Keyword.KEY, Keyword.UPDATE).commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression<?> value) {
                    qb.attribute((Attribute)((Object)value)).append("=").append("values").openParenthesis().attribute((Attribute)((Object)value)).closeParenthesis().space();
                }
            });
        }
    }
}

