/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class HttpConnection
implements Connection,
Attachable {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final HttpDestination destination;
    private final RequestTimeouts requestTimeouts;
    private Object attachment;
    private int idleTimeoutGuard;
    private long idleTimeoutStamp;

    protected HttpConnection(HttpDestination destination) {
        this.destination = destination;
        this.requestTimeouts = new RequestTimeouts(destination.getHttpClient().getScheduler());
        this.idleTimeoutStamp = System.nanoTime();
    }

    public HttpClient getHttpClient() {
        return this.destination.getHttpClient();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    protected abstract Iterator<HttpChannel> getHttpChannels();

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        HttpExchange exchange;
        SendFailure result2;
        HttpRequest httpRequest = (HttpRequest)request;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(httpRequest.getResponseListeners());
        httpRequest.sent();
        if (listener != null) {
            listeners.add(listener);
        }
        if ((result2 = this.send(exchange = new HttpExchange(this.getHttpDestination(), httpRequest, listeners))) != null) {
            httpRequest.abort(result2.failure);
        }
    }

    protected abstract SendFailure send(HttpExchange var1);

    protected void normalizeRequest(Request request) {
        URI uri2;
        URI uri3;
        boolean normalized = ((HttpRequest)request).normalized();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Normalizing {} {}", !normalized, request);
        }
        if (normalized) {
            return;
        }
        HttpVersion version = request.getVersion();
        HttpFields headers = request.getHeaders();
        ContentProvider content = request.getContent();
        ProxyConfiguration.Proxy proxy = this.destination.getProxy();
        String path = request.getPath();
        if (path.trim().length() == 0) {
            path = "/";
            request.path(path);
        }
        if (proxy instanceof HttpProxy && !HttpClient.isSchemeSecure(request.getScheme()) && (uri3 = request.getURI()) != null) {
            path = uri3.toString();
            request.path(path);
        }
        if (version.getVersion() <= 11 && !headers.containsKey(HttpHeader.HOST.asString())) {
            uri3 = request.getURI();
            if (uri3 != null) {
                headers.put(HttpHeader.HOST, uri3.getAuthority());
            } else {
                headers.put(this.getHttpDestination().getHostField());
            }
        }
        if (content != null) {
            long contentLength;
            if (!headers.containsKey(HttpHeader.CONTENT_TYPE.asString())) {
                String contentType = null;
                if (content instanceof ContentProvider.Typed) {
                    contentType = ((ContentProvider.Typed)content).getContentType();
                }
                if (contentType != null) {
                    headers.put(HttpHeader.CONTENT_TYPE, contentType);
                } else {
                    contentType = this.getHttpClient().getDefaultRequestContentType();
                    if (contentType != null) {
                        headers.put(HttpHeader.CONTENT_TYPE, contentType);
                    }
                }
            }
            if ((contentLength = content.getLength()) >= 0L && !headers.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                headers.put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
            }
        }
        StringBuilder cookies = this.convertCookies(request.getCookies(), null);
        CookieStore cookieStore2 = this.getHttpClient().getCookieStore();
        if (cookieStore2 != null && cookieStore2.getClass() != HttpCookieStore.Empty.class && (uri2 = request.getURI()) != null) {
            cookies = this.convertCookies(HttpCookieStore.matchPath(uri2, cookieStore2.get(uri2)), cookies);
        }
        if (cookies != null) {
            request.header(HttpHeader.COOKIE.asString(), cookies.toString());
        }
        this.applyProxyAuthentication(request, proxy);
        this.applyRequestAuthentication(request);
    }

    private StringBuilder convertCookies(List<HttpCookie> cookies, StringBuilder builder) {
        for (HttpCookie cookie : cookies) {
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (builder.length() > 0) {
                builder.append("; ");
            }
            builder.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        return builder;
    }

    private void applyRequestAuthentication(Request request) {
        Authentication.Result result2;
        URI uri2;
        AuthenticationStore authenticationStore = this.getHttpClient().getAuthenticationStore();
        if (authenticationStore.hasAuthenticationResults() && (uri2 = request.getURI()) != null && (result2 = authenticationStore.findAuthenticationResult(uri2)) != null) {
            result2.apply(request);
        }
    }

    private void applyProxyAuthentication(Request request, ProxyConfiguration.Proxy proxy) {
        Authentication.Result result2;
        if (proxy != null && (result2 = this.getHttpClient().getAuthenticationStore().findAuthenticationResult(proxy.getURI())) != null) {
            result2.apply(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SendFailure send(HttpChannel channel, HttpExchange exchange) {
        boolean send;
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            boolean bl = send = this.idleTimeoutGuard >= 0;
            if (send) {
                ++this.idleTimeoutGuard;
            }
        }
        if (send) {
            SendFailure result2;
            HttpRequest request = exchange.getRequest();
            if (channel.associate(exchange)) {
                this.requestTimeouts.schedule(channel);
                channel.send();
                result2 = null;
            } else {
                channel.release();
                result2 = new SendFailure(new HttpRequestException("Could not associate request to connection", request), false);
            }
            HttpConnection httpConnection2 = this;
            synchronized (httpConnection2) {
                --this.idleTimeoutGuard;
                this.idleTimeoutStamp = System.nanoTime();
            }
            return result2;
        }
        return new SendFailure(new TimeoutException(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onIdleTimeout(long idleTimeout) {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this.idleTimeoutGuard == 0) {
                boolean idle;
                long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.idleTimeoutStamp);
                boolean bl = idle = elapsed > idleTimeout / 2L;
                if (idle) {
                    this.idleTimeoutGuard = -1;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Idle timeout {}/{}ms - {}", elapsed, idleTimeout, this);
                }
                return idle;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout skipped - {}", this);
            }
            return false;
        }
    }

    @Override
    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    protected void destroy() {
        this.requestTimeouts.destroy();
    }

    public String toString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }

    private class RequestTimeouts
    extends CyclicTimeouts<HttpChannel> {
        private RequestTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        @Override
        protected Iterator<HttpChannel> iterator() {
            return HttpConnection.this.getHttpChannels();
        }

        @Override
        protected boolean onExpired(HttpChannel channel) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange != null) {
                HttpRequest request = exchange.getRequest();
                request.abort(new TimeoutException("Total timeout " + request.getConversation().getTimeout() + " ms elapsed"));
            }
            return false;
        }
    }
}

