/*
 * Decompiled with CFR 0.152.
 */
package io.requery.cache;

import io.requery.EntityCache;
import io.requery.cache.SerializedEntity;
import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.proxy.CompositeKey;
import io.requery.util.ClassMap;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;

public class SerializableEntityCache
implements EntityCache {
    private final EntityModel model;
    private final CacheManager cacheManager;
    private final ClassMap<Cache<?, ?>> caches;
    private final Factory<ExpiryPolicy> expiryPolicyFactory;

    public SerializableEntityCache(EntityModel model, CacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
        this.cacheManager = cacheManager;
        this.expiryPolicyFactory = EternalExpiryPolicy.factoryOf();
        this.caches = new ClassMap();
    }

    protected String getCacheName(Type<?> type2) {
        return type2.getName();
    }

    protected <K, V> void configure(MutableConfiguration<K, V> configuration) {
        configuration.setExpiryPolicyFactory(this.expiryPolicyFactory);
    }

    private <T> Class getKeyClass(Type<T> type2) {
        Class keyClass;
        Set<Attribute<T, ?>> keys2 = type2.getKeyAttributes();
        if (keys2.isEmpty()) {
            return Integer.class;
        }
        if (keys2.size() == 1) {
            Attribute attribute = keys2.iterator().next();
            if (attribute.isAssociation()) {
                attribute = attribute.getReferencedAttribute().get();
            }
            if ((keyClass = attribute.getClassType()).isPrimitive()) {
                if (keyClass == Integer.TYPE) {
                    keyClass = Integer.class;
                } else if (keyClass == Long.TYPE) {
                    keyClass = Long.class;
                }
            }
        } else {
            keyClass = CompositeKey.class;
        }
        return keyClass;
    }

    protected <K, T> Cache<K, SerializedEntity<T>> createCache(String cacheName, Type<T> type2) {
        Class keyClass = this.getKeyClass(type2);
        if (keyClass == null) {
            throw new IllegalStateException();
        }
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setTypes(keyClass, SerializedEntity.class);
        this.configure(configuration);
        return this.cacheManager.createCache(cacheName, (Configuration)configuration);
    }

    private <K, T> Cache<K, SerializedEntity<T>> tryCreateCache(Class<T> type2) {
        Cache cache2;
        block3: {
            Type<T> declaredType = this.model.typeOf(type2);
            String cacheName = this.getCacheName(declaredType);
            cache2 = this.cacheManager.getCache(cacheName);
            if (cache2 == null) {
                try {
                    cache2 = this.createCache(cacheName, declaredType);
                }
                catch (CacheException ce) {
                    cache2 = this.cacheManager.getCache(cacheName);
                    if (cache2 != null) break block3;
                    throw ce;
                }
            }
        }
        return cache2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache(Class<?> type2) {
        Cache cache2;
        ClassMap<Cache<?, ?>> classMap = this.caches;
        synchronized (classMap) {
            cache2 = this.caches.get(type2);
            if (cache2 == null) {
                Type<?> declaredType = this.model.typeOf(type2);
                String cacheName = this.getCacheName(declaredType);
                Class keyClass = this.getKeyClass(declaredType);
                cache2 = this.cacheManager.getCache(cacheName, keyClass, SerializedEntity.class);
            }
        }
        return cache2;
    }

    @Override
    public <T> T get(Class<T> type2, Object key) {
        SerializedEntity container;
        Cache cache2 = this.getCache(type2);
        if (cache2 != null && cache2.isClosed()) {
            cache2 = null;
        }
        if (cache2 != null && (container = (SerializedEntity)cache2.get(key)) != null) {
            return type2.cast(container.getEntity());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(Class<T> type2, Object key, T value) {
        Cache cache2;
        ClassMap<Cache<?, ?>> classMap = this.caches;
        synchronized (classMap) {
            cache2 = this.getCache(type2);
            if (cache2 == null) {
                cache2 = this.tryCreateCache(type2);
            }
        }
        cache2.put(key, new SerializedEntity<T>(type2, value));
    }

    @Override
    public boolean contains(Class<?> type2, Object key) {
        Cache cache2 = this.getCache(type2);
        return cache2 != null && !cache2.isClosed() && cache2.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Class<?> type2) {
        Cache cache2 = this.getCache(type2);
        if (cache2 != null) {
            cache2.clear();
            String cacheName = this.getCacheName(this.model.typeOf(type2));
            this.cacheManager.destroyCache(cacheName);
            ClassMap<Cache<?, ?>> classMap = this.caches;
            synchronized (classMap) {
                this.caches.remove(type2);
            }
            cache2.close();
        }
    }

    @Override
    public void invalidate(Class<?> type2, Object key) {
        Cache cache2 = this.getCache(type2);
        if (cache2 != null && !cache2.isClosed()) {
            cache2.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ClassMap<Cache<?, ?>> classMap = this.caches;
        synchronized (classMap) {
            for (Map.Entry<Class<?>, Cache<?, ?>> entry : this.caches.entrySet()) {
                this.invalidate(entry.getKey());
            }
        }
    }
}

