/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query;

import io.requery.query.ExpressionType;
import io.requery.query.FieldExpression;
import io.requery.query.NamedNumericExpression;
import io.requery.query.NamedStringExpression;

public class NamedExpression<V>
extends FieldExpression<V> {
    private final String name;
    private final Class<V> type;

    public static <V> NamedExpression<V> of(String name, Class<V> type2) {
        return new NamedExpression<V>(name, type2);
    }

    public static NamedNumericExpression<Double> ofDouble(String name) {
        return new NamedNumericExpression<Double>(name, Double.class);
    }

    public static NamedNumericExpression<Float> ofFloat(String name) {
        return new NamedNumericExpression<Float>(name, Float.class);
    }

    public static NamedNumericExpression<Integer> ofInteger(String name) {
        return new NamedNumericExpression<Integer>(name, Integer.class);
    }

    public static NamedNumericExpression<Long> ofLong(String name) {
        return new NamedNumericExpression<Long>(name, Long.class);
    }

    public static NamedStringExpression ofString(String name) {
        return new NamedStringExpression("'" + name + "'");
    }

    protected NamedExpression(String name, Class<V> type2) {
        this.name = name;
        this.type = type2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<V> getClassType() {
        return this.type;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.NAME;
    }
}

