/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.NonceGenerator;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Key;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.format.ISODateTimeFormat;

@Entity(cacheable=false)
public abstract class AbstractQueuedCheckIn {
    @Key
    @Generated
    public Long id;
    public String event_slug;
    public String secret;
    public String nonce;
    @Deprecated
    public Date datetime;
    public String datetime_string;
    public String answers;
    public String type;
    public Long checkinListId;

    public void generateNonce() {
        this.nonce = NonceGenerator.nextNonce();
    }

    public static String formatDatetime(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        df.setTimeZone(tz);
        return df.format(date);
    }

    public Date getFullDatetime() {
        if (this.datetime_string != null && !this.datetime_string.equals("")) {
            return ISODateTimeFormat.dateTimeParser().parseDateTime(this.datetime_string).toDate();
        }
        return this.datetime;
    }
}

