/*
 * Decompiled with CFR 0.152.
 */
package io.requery.cache;

import io.requery.EntityCache;
import io.requery.cache.EmptyEntityCache;
import io.requery.cache.LayeredEntityCache;
import io.requery.cache.SerializableEntityCache;
import io.requery.cache.SerializationContext;
import io.requery.cache.WeakEntityCache;
import io.requery.meta.EntityModel;
import java.util.LinkedList;
import javax.cache.CacheManager;

public class EntityCacheBuilder {
    private final EntityModel model;
    private boolean useReferenceCache;
    private boolean useSerializableCache;
    private CacheManager cacheManager;

    public EntityCacheBuilder(EntityModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
    }

    public EntityCacheBuilder useReferenceCache(boolean enable) {
        this.useReferenceCache = enable;
        return this;
    }

    public EntityCacheBuilder useSerializableCache(boolean enable) {
        this.useSerializableCache = enable;
        return this;
    }

    public EntityCacheBuilder useCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public EntityCache build() {
        LinkedList<EntityCache> caches = new LinkedList<EntityCache>();
        if (this.useReferenceCache) {
            caches.add(new WeakEntityCache());
        }
        if (this.useSerializableCache) {
            SerializationContext.map(this.model);
            caches.add(new SerializableEntityCache(this.model, this.cacheManager));
        }
        if (caches.isEmpty()) {
            return new EmptyEntityCache();
        }
        return new LayeredEntityCache(caches);
    }
}

