/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.pretix.libpretixsync.db.ItemVariation;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.db.Quota;
import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.utils.I18nString;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Key;
import io.requery.ManyToMany;
import io.requery.Nullable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractItem
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public String event_slug;
    public Long server_id;
    public Long position;
    @Nullable
    public Long category_id;
    public boolean admission;
    public boolean active;
    @Column(definition="TEXT")
    public String json_data;
    @ManyToMany
    @JsonIgnore
    List<Question> questions;
    @ManyToMany
    @JsonIgnore
    List<Quota> quotas;
    @Nullable
    public Long badge_layout_id;
    @Nullable
    public Long ticket_layout_id;
    @Nullable
    public Long ticket_layout_pretixpos_id;
    public String picture_filename;

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    @JsonIgnore
    public String getInternalName() {
        try {
            String internal = this.getJSON().optString("internal_name");
            if (internal != null && !internal.isEmpty() && !"null".equals(internal)) {
                return internal;
            }
            return I18nString.toString(this.getJSON().getJSONObject("name"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    @JsonIgnore
    public String getName() {
        try {
            return I18nString.toString(this.getJSON().getJSONObject("name"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    @JsonIgnore
    public boolean isGiftcard() {
        try {
            return this.getJSON().getBoolean("issue_giftcard");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    @JsonIgnore
    public boolean hasVariations() {
        try {
            return this.getJSON().getBoolean("has_variations");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    @JsonIgnore
    public Integer getMinPerOrder() {
        try {
            if (this.getJSON().isNull("min_per_order")) {
                return null;
            }
            return this.getJSON().optInt("min_per_order");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @JsonIgnore
    public Integer getMaxPerOrder() {
        try {
            if (this.getJSON().isNull("max_per_order")) {
                return null;
            }
            return this.getJSON().optInt("max_per_order");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @JsonIgnore
    public BigDecimal getDefaultPrice() {
        try {
            return new BigDecimal(this.getJSON().getString("default_price"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new BigDecimal(0.0);
        }
    }

    @JsonIgnore
    public boolean isGenerateTickets() {
        try {
            if (this.getJSON().isNull("generate_tickets")) {
                return true;
            }
            return this.getJSON().getBoolean("generate_tickets");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return true;
        }
    }

    @JsonIgnore
    public Long getTaxRuleId() {
        try {
            return this.getJSON().optLong("tax_rule");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @JsonIgnore
    public boolean isRequireVoucher() {
        try {
            return this.getJSON().getBoolean("require_voucher");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return true;
        }
    }

    @JsonIgnore
    public boolean isHideWithoutVoucher() {
        try {
            return this.getJSON().getBoolean("hide_without_voucher");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean availableByTime() {
        try {
            DateTime af;
            JSONObject jo = this.getJSON();
            if (!jo.isNull("available_from") && (af = ISODateTimeFormat.dateTimeParser().parseDateTime(jo.getString("available_from"))).isAfterNow()) {
                return false;
            }
            return jo.isNull("available_until") || !(af = ISODateTimeFormat.dateTimeParser().parseDateTime(jo.getString("available_until"))).isBeforeNow();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean availableOnSalesChannel(String channel) {
        try {
            JSONArray channels = this.getJSON().optJSONArray("sales_channels");
            if (channels == null) {
                return true;
            }
            for (int i2 = 0; i2 < channels.length(); ++i2) {
                if (!channels.getString(i2).equals(channel)) continue;
                return true;
            }
            return false;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return true;
        }
    }

    public List<ItemVariation> getVariations() throws JSONException {
        ArrayList<ItemVariation> l = new ArrayList<ItemVariation>();
        JSONArray vars = this.getJSON().getJSONArray("variations");
        for (int i2 = 0; i2 < vars.length(); ++i2) {
            JSONObject variation = vars.getJSONObject(i2);
            ItemVariation v = new ItemVariation();
            v.setActive(variation.getBoolean("active"));
            v.setDescription(variation.optJSONObject("description"));
            v.setPosition(variation.getLong("position"));
            v.setPrice(new BigDecimal(variation.getString("price")));
            v.setServer_id(variation.getLong("id"));
            v.setValue(variation.getJSONObject("value"));
            v.setAvailable_from(variation.optString("available_from"));
            v.setAvailable_until(variation.optString("available_until"));
            v.setSales_channels(variation.optJSONArray("sales_channels"));
            v.setHide_without_voucher(variation.optBoolean("hide_without_voucher", false));
            l.add(v);
        }
        return l;
    }

    public ItemVariation getVariation(Long variation_id) throws JSONException {
        for (ItemVariation var : this.getVariations()) {
            if (!var.getServer_id().equals(variation_id)) continue;
            return var;
        }
        return null;
    }
}

