/*
 * Decompiled with CFR 0.152.
 */
package io.requery.converter;

import io.requery.Converter;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UUIDConverter
implements Converter<UUID, byte[]> {
    @Override
    public Class<UUID> getMappedType() {
        return UUID.class;
    }

    @Override
    public Class<byte[]> getPersistedType() {
        return byte[].class;
    }

    @Override
    public Integer getPersistedSize() {
        return 16;
    }

    @Override
    public byte[] convertToPersisted(UUID value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = new byte[16];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putLong(value.getMostSignificantBits());
        buffer.putLong(value.getLeastSignificantBits());
        return bytes;
    }

    @Override
    public UUID convertToMapped(Class<? extends UUID> type2, byte[] value) {
        if (value == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(value);
        return new UUID(buffer.getLong(), buffer.getLong());
    }
}

