/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.query.Expression;
import io.requery.query.element.GroupByElement;
import io.requery.query.element.LimitedElement;
import io.requery.query.element.OrderByElement;
import io.requery.query.element.QueryElement;
import io.requery.query.element.SelectionElement;
import io.requery.query.element.SetOperationElement;
import io.requery.query.element.WhereElement;
import io.requery.sql.Keyword;
import io.requery.sql.Platform;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.GroupByGenerator;
import io.requery.sql.gen.Output;
import io.requery.sql.gen.SelectGenerator;
import io.requery.sql.gen.SetOperatorGenerator;
import io.requery.sql.gen.WhereGenerator;
import java.util.Map;

public final class StatementGenerator
implements Generator<QueryElement<?>> {
    private Generator<SelectionElement> select = new SelectGenerator();
    private Generator<QueryElement<?>> insert;
    private Generator<Map<Expression<?>, Object>> update;
    private Generator<Map<Expression<?>, Object>> upsert;
    private Generator<WhereElement> where;
    private Generator<GroupByElement> groupBy;
    private Generator<OrderByElement> orderBy;
    private Generator<LimitedElement> limit;
    private Generator<SetOperationElement> setOperation;

    public StatementGenerator(Platform platform) {
        this.insert = platform.insertGenerator();
        this.update = platform.updateGenerator();
        this.upsert = platform.upsertGenerator();
        this.where = new WhereGenerator();
        this.groupBy = new GroupByGenerator();
        this.orderBy = platform.orderByGenerator();
        this.limit = platform.limitGenerator();
        this.setOperation = new SetOperatorGenerator();
    }

    @Override
    public void write(Output output, QueryElement<?> query) {
        QueryBuilder qb = output.builder();
        switch (query.queryType()) {
            case SELECT: {
                this.select.write(output, query);
                break;
            }
            case INSERT: {
                this.insert.write(output, query);
                break;
            }
            case UPDATE: {
                this.update.write(output, StatementGenerator.checkEmpty(query.updateValues()));
                break;
            }
            case UPSERT: {
                this.upsert.write(output, StatementGenerator.checkEmpty(query.updateValues()));
                break;
            }
            case DELETE: {
                qb.keyword(Keyword.DELETE, Keyword.FROM);
                output.appendTables();
                break;
            }
            case TRUNCATE: {
                qb.keyword(Keyword.TRUNCATE);
                output.appendTables();
            }
        }
        this.where.write(output, query);
        this.groupBy.write(output, query);
        this.orderBy.write(output, query);
        this.limit.write(output, query);
        this.setOperation.write(output, query);
    }

    private static Map<Expression<?>, Object> checkEmpty(Map<Expression<?>, Object> values2) {
        if (values2 == null || values2.isEmpty()) {
            throw new IllegalStateException("Cannot generate update statement with an empty set of values");
        }
        return values2;
    }
}

