/*
 * Decompiled with CFR 0.152.
 */
package io.requery.util;

import io.requery.util.CollectionObserver;
import io.requery.util.Objects;
import io.requery.util.ObservableCollection;
import io.requery.util.ObservableCollectionIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;

public class ObservableSet<E>
implements Set<E>,
ObservableCollection<E> {
    private final Set<E> set;
    private final CollectionObserver<E> observer;

    public ObservableSet(Set<E> set, CollectionObserver<E> observer) {
        this.set = Objects.requireNotNull(set);
        this.observer = observer;
    }

    @Override
    public CollectionObserver<E> observer() {
        return this.observer;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new ObservableCollectionIterator<E>(this.set, this.observer);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added = this.set.add(e);
        if (added && this.observer != null) {
            this.observer.elementAdded(e);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.set.remove(o);
        if (removed && this.observer != null) {
            Object element = o;
            this.observer.elementRemoved(element);
        }
        return removed;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        boolean modified = false;
        for (E element : c) {
            boolean added = this.add(element);
            if (modified || !added) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        ArrayList<E> toRemove = new ArrayList<E>();
        for (E element : this) {
            if (c.contains(element)) continue;
            toRemove.add(element);
        }
        return this.removeAll(toRemove);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        boolean modified = false;
        for (Object element : c) {
            boolean removed = this.remove(element);
            if (modified || !removed) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        if (this.observer != null) {
            for (E element : this) {
                this.observer.elementRemoved(element);
            }
        }
        this.set.clear();
    }
}

