/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Base64Encoder;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.DecoderException;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Encoder;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.EncoderException;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.pbkdf2.Strings;

public class Base64 {
    private static final Encoder encoder = new Base64Encoder();

    public static String toBase64String(byte[] data2) {
        return Base64.toBase64String(data2, 0, data2.length);
    }

    public static String toBase64String(byte[] data2, int off, int length) {
        byte[] encoded = Base64.encode(data2, off, length);
        return Strings.fromByteArray(encoded);
    }

    public static byte[] encode(byte[] data2) {
        return Base64.encode(data2, 0, data2.length);
    }

    public static byte[] encode(byte[] data2, int off, int length) {
        int len = (length + 2) / 3 * 4;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            encoder.encode(data2, off, length, bOut);
        }
        catch (Exception e) {
            throw new EncoderException("exception encoding base64 string: " + e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data2, OutputStream out) throws IOException {
        return encoder.encode(data2, 0, data2.length, out);
    }

    public static int encode(byte[] data2, int off, int length, OutputStream out) throws IOException {
        return encoder.encode(data2, off, length, out);
    }

    public static byte[] decode(byte[] data2) {
        int len = data2.length / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            encoder.decode(data2, 0, data2.length, bOut);
        }
        catch (Exception e) {
            throw new DecoderException("unable to decode base64 data: " + e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    public static byte[] decode(String data2) {
        int len = data2.length() / 4 * 3;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
        try {
            encoder.decode(data2, bOut);
        }
        catch (Exception e) {
            throw new DecoderException("unable to decode base64 string: " + e.getMessage(), e);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data2, OutputStream out) throws IOException {
        return encoder.decode(data2, out);
    }

    public static int decode(byte[] base64Data, int start2, int length, OutputStream out) {
        try {
            return encoder.decode(base64Data, start2, length, out);
        }
        catch (Exception e) {
            throw new DecoderException("unable to decode base64 data: " + e.getMessage(), e);
        }
    }
}

