/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ManagedAttributeListener
implements ServletContextListener,
ServletContextAttributeListener {
    private static final Logger LOG = Log.getLogger(ManagedAttributeListener.class);
    final Set<String> _managedAttributes = new HashSet<String>();
    final ContextHandler _context;

    public ManagedAttributeListener(ContextHandler context, String ... managedAttributes) {
        this._context = context;
        for (String attr : managedAttributes) {
            this._managedAttributes.add(attr);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("managedAttributes {}", this._managedAttributes);
        }
    }

    @Override
    public void attributeReplaced(ServletContextAttributeEvent event2) {
        if (this._managedAttributes.contains(event2.getName())) {
            this.updateBean(event2.getName(), event2.getValue(), event2.getServletContext().getAttribute(event2.getName()));
        }
    }

    @Override
    public void attributeRemoved(ServletContextAttributeEvent event2) {
        if (this._managedAttributes.contains(event2.getName())) {
            this.updateBean(event2.getName(), event2.getValue(), null);
        }
    }

    @Override
    public void attributeAdded(ServletContextAttributeEvent event2) {
        if (this._managedAttributes.contains(event2.getName())) {
            this.updateBean(event2.getName(), null, event2.getValue());
        }
    }

    @Override
    public void contextInitialized(ServletContextEvent event2) {
        for (String name : this._context.getServletContext().getAttributeNameSet()) {
            if (!this._managedAttributes.contains(name)) continue;
            this.updateBean(name, null, event2.getServletContext().getAttribute(name));
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent event2) {
        for (String name : this._context.getServletContext().getAttributeNameSet()) {
            if (!this._managedAttributes.contains(name)) continue;
            this.updateBean(name, event2.getServletContext().getAttribute(name), null);
        }
    }

    protected void updateBean(String name, Object oldBean, Object newBean) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("update {} {}->{} on {}", name, oldBean, newBean, this._context);
        }
        this._context.updateBean(oldBean, newBean, false);
    }
}

