/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.sse;

import io.javalin.http.Context;
import io.javalin.http.sse.Emitter;

public class SseClient {
    public final Context ctx;
    private Emitter emitter;
    private Runnable closeCallback = null;

    public SseClient(Context ctx) {
        this.emitter = new Emitter(ctx.req.getAsyncContext());
        this.ctx = ctx;
    }

    public void onClose(Runnable closeCallback) {
        this.closeCallback = closeCallback;
    }

    public void sendEvent(String data2) {
        this.sendEvent("message", data2);
    }

    public void sendEvent(String event2, String data2) {
        this.sendEvent(event2, data2, null);
    }

    public void sendEvent(String event2, String data2, String id) {
        this.emitter.emit(event2, data2, id);
        if (this.emitter.isClose() && this.closeCallback != null) {
            this.closeCallback.run();
        }
    }
}

