/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.function.Consumer;
import java8.util.function.IntFunction;
import java8.util.function.Supplier;
import java8.util.stream.AbstractPipeline$$Lambda$1;
import java8.util.stream.AbstractPipeline$$Lambda$2;
import java8.util.stream.AbstractPipeline$$Lambda$3;
import java8.util.stream.BaseStream;
import java8.util.stream.Node;
import java8.util.stream.PipelineHelper;
import java8.util.stream.Sink;
import java8.util.stream.SinkDefaults;
import java8.util.stream.StreamOpFlag;
import java8.util.stream.StreamShape;
import java8.util.stream.Streams;
import java8.util.stream.TerminalOp;

abstract class AbstractPipeline<E_IN, E_OUT, S extends BaseStream<E_OUT, S>>
extends PipelineHelper<E_OUT>
implements BaseStream<E_OUT, S> {
    private static final String MSG_STREAM_LINKED = "stream has already been operated upon or closed";
    private static final String MSG_CONSUMED = "source already consumed or closed";
    private final AbstractPipeline sourceStage;
    private final AbstractPipeline previousStage;
    protected final int sourceOrOpFlags;
    private AbstractPipeline nextStage;
    private int depth;
    private int combinedFlags;
    private Spliterator<?> sourceSpliterator;
    private Supplier<? extends Spliterator<?>> sourceSupplier;
    private boolean linkedOrConsumed;
    private boolean sourceAnyStateful;
    private Runnable sourceCloseAction;
    private boolean parallel;

    AbstractPipeline(Supplier<? extends Spliterator<?>> source2, int sourceFlags, boolean parallel) {
        this.previousStage = null;
        this.sourceSupplier = source2;
        this.sourceStage = this;
        this.sourceOrOpFlags = sourceFlags & StreamOpFlag.STREAM_MASK;
        this.combinedFlags = ~(this.sourceOrOpFlags << 1) & StreamOpFlag.INITIAL_OPS_VALUE;
        this.depth = 0;
        this.parallel = parallel;
    }

    AbstractPipeline(Spliterator<?> source2, int sourceFlags, boolean parallel) {
        this.previousStage = null;
        this.sourceSpliterator = source2;
        this.sourceStage = this;
        this.sourceOrOpFlags = sourceFlags & StreamOpFlag.STREAM_MASK;
        this.combinedFlags = ~(this.sourceOrOpFlags << 1) & StreamOpFlag.INITIAL_OPS_VALUE;
        this.depth = 0;
        this.parallel = parallel;
    }

    AbstractPipeline(AbstractPipeline<?, E_IN, ?> previousStage, int opFlags) {
        if (previousStage.linkedOrConsumed) {
            throw new IllegalStateException(MSG_STREAM_LINKED);
        }
        previousStage.linkedOrConsumed = true;
        previousStage.nextStage = this;
        this.previousStage = previousStage;
        this.sourceOrOpFlags = opFlags & StreamOpFlag.OP_MASK;
        this.combinedFlags = StreamOpFlag.combineOpFlags(opFlags, previousStage.combinedFlags);
        this.sourceStage = previousStage.sourceStage;
        if (this.opIsStateful()) {
            this.sourceStage.sourceAnyStateful = true;
        }
        this.depth = previousStage.depth + 1;
    }

    final <R> R evaluate(TerminalOp<E_OUT, R> terminalOp) {
        if (this.linkedOrConsumed) {
            throw new IllegalStateException(MSG_STREAM_LINKED);
        }
        this.linkedOrConsumed = true;
        return this.isParallel() ? terminalOp.evaluateParallel(this, this.sourceSpliterator(terminalOp.getOpFlags())) : terminalOp.evaluateSequential(this, this.sourceSpliterator(terminalOp.getOpFlags()));
    }

    final Node<E_OUT> evaluateToArrayNode(IntFunction<E_OUT[]> generator) {
        if (this.linkedOrConsumed) {
            throw new IllegalStateException(MSG_STREAM_LINKED);
        }
        this.linkedOrConsumed = true;
        if (this.isParallel() && this.previousStage != null && this.opIsStateful()) {
            this.depth = 0;
            return this.opEvaluateParallel(this.previousStage, this.previousStage.sourceSpliterator(0), generator);
        }
        return this.evaluate((Spliterator<P_IN>)this.sourceSpliterator(0), true, generator);
    }

    final Spliterator<E_OUT> sourceStageSpliterator() {
        if (this != this.sourceStage) {
            throw new IllegalStateException();
        }
        if (this.linkedOrConsumed) {
            throw new IllegalStateException(MSG_STREAM_LINKED);
        }
        this.linkedOrConsumed = true;
        if (this.sourceStage.sourceSpliterator != null) {
            Spliterator<?> s = this.sourceStage.sourceSpliterator;
            this.sourceStage.sourceSpliterator = null;
            return s;
        }
        if (this.sourceStage.sourceSupplier != null) {
            Spliterator<?> s = this.sourceStage.sourceSupplier.get();
            this.sourceStage.sourceSupplier = null;
            return s;
        }
        throw new IllegalStateException(MSG_CONSUMED);
    }

    @Override
    public final S sequential() {
        this.sourceStage.parallel = false;
        return (S)this;
    }

    @Override
    public final S parallel() {
        this.sourceStage.parallel = true;
        return (S)this;
    }

    @Override
    public void close() {
        this.linkedOrConsumed = true;
        this.sourceSupplier = null;
        this.sourceSpliterator = null;
        if (this.sourceStage.sourceCloseAction != null) {
            Runnable closeAction = this.sourceStage.sourceCloseAction;
            this.sourceStage.sourceCloseAction = null;
            closeAction.run();
        }
    }

    @Override
    public S onClose(Runnable closeHandler) {
        if (this.linkedOrConsumed) {
            throw new IllegalStateException(MSG_STREAM_LINKED);
        }
        Objects.requireNonNull(closeHandler);
        Runnable existingHandler = this.sourceStage.sourceCloseAction;
        this.sourceStage.sourceCloseAction = existingHandler == null ? closeHandler : Streams.composeWithExceptions(existingHandler, closeHandler);
        return (S)this;
    }

    @Override
    public Spliterator<E_OUT> spliterator() {
        if (this.linkedOrConsumed) {
            throw new IllegalStateException(MSG_STREAM_LINKED);
        }
        this.linkedOrConsumed = true;
        if (this == this.sourceStage) {
            if (this.sourceStage.sourceSpliterator != null) {
                Spliterator<?> s = this.sourceStage.sourceSpliterator;
                this.sourceStage.sourceSpliterator = null;
                return s;
            }
            if (this.sourceStage.sourceSupplier != null) {
                Supplier<? extends Spliterator<?>> s = this.sourceStage.sourceSupplier;
                this.sourceStage.sourceSupplier = null;
                return this.lazySpliterator(s);
            }
            throw new IllegalStateException(MSG_CONSUMED);
        }
        return this.wrap(this, AbstractPipeline$$Lambda$1.lambdaFactory$(this), this.isParallel());
    }

    @Override
    public final boolean isParallel() {
        return this.sourceStage.parallel;
    }

    final int getStreamFlags() {
        return StreamOpFlag.toStreamFlags(this.combinedFlags);
    }

    private Spliterator<?> sourceSpliterator(int terminalFlags) {
        Spliterator<Object> spliterator = null;
        if (this.sourceStage.sourceSpliterator != null) {
            spliterator = this.sourceStage.sourceSpliterator;
            this.sourceStage.sourceSpliterator = null;
        } else if (this.sourceStage.sourceSupplier != null) {
            spliterator = this.sourceStage.sourceSupplier.get();
            this.sourceStage.sourceSupplier = null;
        } else {
            throw new IllegalStateException(MSG_CONSUMED);
        }
        if (this.isParallel() && this.sourceStage.sourceAnyStateful) {
            int depth = 1;
            AbstractPipeline u = this.sourceStage;
            AbstractPipeline p = this.sourceStage.nextStage;
            AbstractPipeline e = this;
            while (u != e) {
                int thisOpFlags = p.sourceOrOpFlags;
                if (p.opIsStateful()) {
                    depth = 0;
                    if (StreamOpFlag.SHORT_CIRCUIT.isKnown(thisOpFlags)) {
                        thisOpFlags &= ~StreamOpFlag.IS_SHORT_CIRCUIT;
                    }
                    thisOpFlags = (spliterator = p.opEvaluateParallelLazy(u, spliterator)).hasCharacteristics(64) ? thisOpFlags & ~StreamOpFlag.NOT_SIZED | StreamOpFlag.IS_SIZED : thisOpFlags & ~StreamOpFlag.IS_SIZED | StreamOpFlag.NOT_SIZED;
                }
                p.depth = depth++;
                p.combinedFlags = StreamOpFlag.combineOpFlags(thisOpFlags, u.combinedFlags);
                u = p;
                p = p.nextStage;
            }
        }
        if (terminalFlags != 0) {
            this.combinedFlags = StreamOpFlag.combineOpFlags(terminalFlags, this.combinedFlags);
        }
        return spliterator;
    }

    @Override
    final StreamShape getSourceShape() {
        AbstractPipeline p = this;
        while (p.depth > 0) {
            p = p.previousStage;
        }
        return p.getOutputShape();
    }

    @Override
    final <P_IN> long exactOutputSizeIfKnown(Spliterator<P_IN> spliterator) {
        return StreamOpFlag.SIZED.isKnown(this.getStreamAndOpFlags()) ? spliterator.getExactSizeIfKnown() : -1L;
    }

    @Override
    final <P_IN, S_ extends Sink<E_OUT>> S_ wrapAndCopyInto(S_ sink2, Spliterator<P_IN> spliterator) {
        this.copyInto(this.wrapSink(Objects.requireNonNull(sink2)), spliterator);
        return sink2;
    }

    @Override
    final <P_IN, S_ extends Consumer<E_OUT>> S_ wrapAndCopyInto(S_ sink2, Spliterator<P_IN> spliterator) {
        this.copyInto(this.wrapSink(Objects.requireNonNull(sink2)), spliterator);
        return sink2;
    }

    @Override
    final <P_IN> void copyInto(Sink<P_IN> wrappedSink, Spliterator<P_IN> spliterator) {
        Objects.requireNonNull(wrappedSink);
        if (!StreamOpFlag.SHORT_CIRCUIT.isKnown(this.getStreamAndOpFlags())) {
            wrappedSink.begin(spliterator.getExactSizeIfKnown());
            spliterator.forEachRemaining(wrappedSink);
            wrappedSink.end();
        } else {
            this.copyIntoWithCancel(wrappedSink, spliterator);
        }
    }

    @Override
    final <P_IN> boolean copyIntoWithCancel(Sink<P_IN> wrappedSink, Spliterator<P_IN> spliterator) {
        AbstractPipeline p = this;
        while (p.depth > 0) {
            p = p.previousStage;
        }
        wrappedSink.begin(spliterator.getExactSizeIfKnown());
        boolean cancelled = p.forEachWithCancel(spliterator, wrappedSink);
        wrappedSink.end();
        return cancelled;
    }

    @Override
    final int getStreamAndOpFlags() {
        return this.combinedFlags;
    }

    final boolean isOrdered() {
        return StreamOpFlag.ORDERED.isKnown(this.combinedFlags);
    }

    @Override
    final <P_IN> Sink<P_IN> wrapSink(Sink<E_OUT> sink2) {
        Objects.requireNonNull(sink2);
        AbstractPipeline p = this;
        while (p.depth > 0) {
            sink2 = p.opWrapSink(p.previousStage.combinedFlags, sink2);
            p = p.previousStage;
        }
        return sink2;
    }

    @Override
    final <P_IN> Sink<P_IN> wrapSink(final Consumer<E_OUT> sink2) {
        Objects.requireNonNull(sink2);
        Sink<Object> trampoline = new Sink<E_OUT>(){

            @Override
            public void accept(E_OUT t) {
                sink2.accept(t);
            }

            @Override
            public void begin(long size) {
            }

            @Override
            public void end() {
            }

            @Override
            public boolean cancellationRequested() {
                return false;
            }

            @Override
            public void accept(int value) {
                SinkDefaults.reject();
            }

            @Override
            public void accept(long value) {
                SinkDefaults.reject();
            }

            @Override
            public void accept(double value) {
                SinkDefaults.reject();
            }
        };
        AbstractPipeline p = this;
        while (p.depth > 0) {
            trampoline = p.opWrapSink(p.previousStage.combinedFlags, trampoline);
            p = p.previousStage;
        }
        return trampoline;
    }

    @Override
    final <P_IN> Spliterator<E_OUT> wrapSpliterator(Spliterator<P_IN> sourceSpliterator) {
        if (this.depth == 0) {
            return sourceSpliterator;
        }
        return this.wrap(this, AbstractPipeline$$Lambda$2.lambdaFactory$(sourceSpliterator), this.isParallel());
    }

    @Override
    final <P_IN> Node<E_OUT> evaluate(Spliterator<P_IN> spliterator, boolean flatten2, IntFunction<E_OUT[]> generator) {
        if (this.isParallel()) {
            return this.evaluateToNode(this, spliterator, flatten2, generator);
        }
        Node.Builder<E_OUT> nb = this.makeNodeBuilder(this.exactOutputSizeIfKnown(spliterator), generator);
        return this.wrapAndCopyInto((Consumer)nb, spliterator).build();
    }

    abstract StreamShape getOutputShape();

    abstract <P_IN> Node<E_OUT> evaluateToNode(PipelineHelper<E_OUT> var1, Spliterator<P_IN> var2, boolean var3, IntFunction<E_OUT[]> var4);

    abstract <P_IN> Spliterator<E_OUT> wrap(PipelineHelper<E_OUT> var1, Supplier<Spliterator<P_IN>> var2, boolean var3);

    abstract Spliterator<E_OUT> lazySpliterator(Supplier<? extends Spliterator<E_OUT>> var1);

    abstract boolean forEachWithCancel(Spliterator<E_OUT> var1, Sink<E_OUT> var2);

    @Override
    abstract Node.Builder<E_OUT> makeNodeBuilder(long var1, IntFunction<E_OUT[]> var3);

    abstract boolean opIsStateful();

    abstract Sink<E_IN> opWrapSink(int var1, Sink<E_OUT> var2);

    <P_IN> Node<E_OUT> opEvaluateParallel(PipelineHelper<E_OUT> helper, Spliterator<P_IN> spliterator, IntFunction<E_OUT[]> generator) {
        throw new UnsupportedOperationException("Parallel evaluation is not supported");
    }

    <P_IN> Spliterator<E_OUT> opEvaluateParallelLazy(PipelineHelper<E_OUT> helper, Spliterator<P_IN> spliterator) {
        return this.opEvaluateParallel(helper, spliterator, AbstractPipeline$$Lambda$3.lambdaFactory$()).spliterator();
    }

    static /* synthetic */ Object[] lambda$opEvaluateParallelLazy$79(int i2) {
        return new Object[i2];
    }

    static /* synthetic */ Spliterator lambda$wrapSpliterator$78(Spliterator spliterator) {
        return spliterator;
    }

    static /* synthetic */ Spliterator lambda$spliterator$77(AbstractPipeline this_) {
        return this_.sourceSpliterator(0);
    }
}

