/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.check;

import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.check.AsyncCheckProvider;
import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.crypto.sig1.TicketProtos;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.CheckIn;
import eu.pretix.libpretixsync.db.CheckInList;
import eu.pretix.libpretixsync.db.CheckInList_Item;
import eu.pretix.libpretixsync.db.Event;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.ItemVariation;
import eu.pretix.libpretixsync.db.NonceGenerator;
import eu.pretix.libpretixsync.db.Order;
import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.db.QuestionLike;
import eu.pretix.libpretixsync.db.QueuedCall;
import eu.pretix.libpretixsync.db.QueuedCheckIn;
import eu.pretix.libpretixsync.db.RevokedTicketSecret;
import eu.pretix.libpretixsync.db.SubEvent;
import eu.pretix.libpretixsync.utils.codec.binary.Base64;
import eu.pretix.libpretixsync.utils.logic.JsonLogic;
import eu.pretix.libpretixsync.utils.logic.UtilsKt;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.meta.QueryExpression;
import io.requery.query.Condition;
import io.requery.query.DistinctSelection;
import io.requery.query.Expression;
import io.requery.query.JoinOn;
import io.requery.query.LogicalCondition;
import io.requery.query.Result;
import io.requery.query.Return;
import io.requery.query.Scalar;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001EB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ*\u0010\u0016\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0016J8\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0016J.\u0010(\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0005H\u0003J\u0006\u0010,\u001a\u00020\u0015J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\u0013H\u0002J\u001e\u00103\u001a\b\u0012\u0004\u0012\u0002040\"2\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0019H\u0016J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0013J\u0010\u0010:\u001a\u0002082\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010;\u001a\u00020<H\u0016JS\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010DR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Leu/pretix/libpretixsync/check/AsyncCheckProvider;", "Leu/pretix/libpretixsync/check/TicketCheckProvider;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "eventSlug", "", "dataStore", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "listId", "", "(Leu/pretix/libpretixsync/config/ConfigStore;Ljava/lang/String;Lio/requery/BlockingEntityStore;J)V", "event", "Leu/pretix/libpretixsync/db/Event;", "getEvent", "()Leu/pretix/libpretixsync/db/Event;", "event$delegate", "Lkotlin/Lazy;", "overrideNow", "Lorg/joda/time/DateTime;", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "basePositionQuery", "Lio/requery/query/WhereAndOr;", "Lio/requery/query/Scalar;", "", "list", "Leu/pretix/libpretixsync/db/CheckInList;", "onlyCheckedIn", "", "check", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckResult;", "ticketid", "answers", "", "Leu/pretix/libpretixsync/db/Answer;", "ignore_unpaid", "with_badge_data", "type", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;", "checkOfflineWithoutData", "decodePretixSig1", "Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "qrcode", "getSentry", "initJsonLogic", "Leu/pretix/libpretixsync/utils/logic/JsonLogic;", "subeventId", "tz", "Lorg/joda/time/DateTimeZone;", "now", "search", "Leu/pretix/libpretixsync/check/TicketCheckProvider$SearchResult;", "query", "page", "setNow", "", "d", "setSentry", "status", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "storeFailedCheckin", "error_reason", "raw_barcode", "position", "item", "variation", "subevent", "(Ljava/lang/String;Ljava/lang/String;Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;)V", "SignedTicketData", "libpretixsync"})
public final class AsyncCheckProvider
implements TicketCheckProvider {
    @NotNull
    private final ConfigStore config;
    @NotNull
    private final String eventSlug;
    @NotNull
    private final BlockingEntityStore<Persistable> dataStore;
    @NotNull
    private SentryInterface sentry;
    private final long listId;
    @NotNull
    private final Lazy event$delegate;
    @Nullable
    private DateTime overrideNow;

    public AsyncCheckProvider(@NotNull ConfigStore config, @NotNull String eventSlug, @NotNull BlockingEntityStore<Persistable> dataStore, long listId) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        Intrinsics.checkNotNullParameter(dataStore, "dataStore");
        this.config = config;
        this.eventSlug = eventSlug;
        this.dataStore = dataStore;
        this.event$delegate = LazyKt.lazy((Function0)new Function0<Event>(this){
            final /* synthetic */ AsyncCheckProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Event invoke() {
                return (Event)((Result)AsyncCheckProvider.access$getDataStore$p(this.this$0).select(Event.class, new QueryAttribute[0]).where((Condition)Event.SLUG.eq((Object)AsyncCheckProvider.access$getEventSlug$p(this.this$0))).get()).first();
            }
        });
        this.sentry = new DummySentryImplementation();
        this.listId = listId;
    }

    @NotNull
    public final SentryInterface getSentry() {
        return this.sentry;
    }

    @NotNull
    public final Event getEvent() {
        Lazy lazy = this.event$delegate;
        Object var3_2 = null;
        boolean bl = false;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-event>(...)");
        return (Event)t;
    }

    @Override
    public void setSentry(@NotNull SentryInterface sentry) {
        Intrinsics.checkNotNullParameter(sentry, "sentry");
        this.sentry = sentry;
    }

    public final void storeFailedCheckin(@NotNull String error_reason, @NotNull String raw_barcode, @NotNull TicketCheckProvider.CheckInType type2, @Nullable Long position, @Nullable Long item, @Nullable Long variation, @Nullable Long subevent) {
        String string;
        Intrinsics.checkNotNullParameter(error_reason, "error_reason");
        Intrinsics.checkNotNullParameter(raw_barcode, "raw_barcode");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        DateTime dt = this.now();
        JSONObject jdoc = new JSONObject();
        jdoc.put("datetime", QueuedCheckIn.formatDatetime(dt.toDate()));
        Object object = raw_barcode;
        Object object2 = new Regex("[\\p{C}]");
        boolean bl = false;
        if (((Regex)object2).containsMatchIn((CharSequence)object)) {
            object2 = raw_barcode;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
            boolean bl2 = false;
            byte[] byArray = ((String)object2).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            object = Base64.encodeBase64(byArray);
            Intrinsics.checkNotNullExpressionValue(object, "encodeBase64(raw_barcode\u2026harset.defaultCharset()))");
            object2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(object2, "defaultCharset()");
            boolean bl3 = false;
            bl2 = false;
            jdoc.put("raw_barcode", Intrinsics.stringPlus("binary:", new String((byte[])object, (Charset)object2)));
        } else {
            jdoc.put("raw_barcode", raw_barcode);
        }
        object = type2;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                string = "entry";
                break;
            }
            case 2: {
                string = "exit";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        jdoc.put("type", string);
        jdoc.put("error_reason", error_reason);
        if (position != null && position > 0L) {
            jdoc.put("position", position);
        }
        if (item != null && item > 0L) {
            jdoc.put("item", item);
        }
        if (variation != null && variation > 0L) {
            jdoc.put("variation", variation);
        }
        if (subevent != null && subevent > 0L) {
            jdoc.put("subevent", subevent);
        }
        QueuedCall qo = new QueuedCall();
        PretixApi api = PretixApi.Companion.fromConfig(this.config);
        qo.setUrl(api.eventResourceUrl("checkinlists") + this.listId + "/failed_checkins/");
        qo.setBody(jdoc.toString());
        qo.setIdempotency_key(NonceGenerator.nextNonce());
        this.dataStore.insert(qo);
    }

    public static /* synthetic */ void storeFailedCheckin$default(AsyncCheckProvider asyncCheckProvider, String string, String string2, TicketCheckProvider.CheckInType checkInType, Long l, Long l2, Long l3, Long l4, int n, Object object) {
        if ((n & 8) != 0) {
            l = null;
        }
        if ((n & 0x10) != 0) {
            l2 = null;
        }
        if ((n & 0x20) != 0) {
            l3 = null;
        }
        if ((n & 0x40) != 0) {
            l4 = null;
        }
        asyncCheckProvider.storeFailedCheckin(string, string2, checkInType, l, l2, l3, l4);
    }

    private final JsonLogic initJsonLogic(long subeventId, DateTimeZone tz) {
        JsonLogic jsonLogic = new JsonLogic();
        jsonLogic.addOperation("objectList", initJsonLogic.1.INSTANCE);
        jsonLogic.addOperation("lookup", initJsonLogic.2.INSTANCE);
        jsonLogic.addOperation("inList", initJsonLogic.3.INSTANCE);
        jsonLogic.addOperation("isAfter", initJsonLogic.4.INSTANCE);
        jsonLogic.addOperation("isBefore", initJsonLogic.5.INSTANCE);
        jsonLogic.addOperation("buildTime", (Function2<? super List<? extends Object>, Object, ? extends Object>)new Function2<List<? extends Object>, Object, Object>(this, subeventId, tz){
            final /* synthetic */ AsyncCheckProvider this$0;
            final /* synthetic */ long $subeventId;
            final /* synthetic */ DateTimeZone $tz;
            {
                this.this$0 = $receiver;
                this.$subeventId = $subeventId;
                this.$tz = $tz;
                super(2);
            }

            @Nullable
            public final Object invoke(@Nullable List<? extends Object> l, @Nullable Object d) {
                DateTime dateTime;
                List<? extends Object> list = l;
                Object t = list == null ? null : CollectionsKt.getOrNull(list, 0);
                JSONObject evjson = this.this$0.getEvent().getJSON();
                if (this.$subeventId != 0L) {
                    SubEvent subevent = (SubEvent)((Result)((WhereAndOr)AsyncCheckProvider.access$getDataStore$p(this.this$0).select(SubEvent.class, new QueryAttribute[0]).where((Condition)SubEvent.EVENT_SLUG.eq((Object)AsyncCheckProvider.access$getEventSlug$p(this.this$0))).and((Condition)SubEvent.SERVER_ID.eq((Object)this.$subeventId))).get()).first();
                    evjson = subevent.getJSON();
                }
                if (Intrinsics.areEqual(t, "custom")) {
                    dateTime = ISODateTimeFormat.dateTimeParser().parseDateTime((String)CollectionsKt.getOrNull(l, 1));
                } else if (Intrinsics.areEqual(t, "customtime")) {
                    DateTime dateTime2;
                    LocalTime time = ISODateTimeFormat.timeParser().parseLocalTime((String)CollectionsKt.getOrNull(l, 1));
                    LocalDate today = new DateTime(AsyncCheckProvider.access$now(this.this$0)).withZone(this.$tz).toLocalDate();
                    try {
                        dateTime2 = today.toLocalDateTime(time).toDateTime(this.$tz);
                    }
                    catch (IllegalInstantException e) {
                        dateTime2 = today.toLocalDateTime(time.minusHours(1)).toDateTime(this.$tz);
                    }
                    dateTime = dateTime2;
                } else {
                    String string;
                    dateTime = Intrinsics.areEqual(t, "date_from") ? ISODateTimeFormat.dateTimeParser().parseDateTime(evjson.getString("date_from")) : (Intrinsics.areEqual(t, "date_to") ? ISODateTimeFormat.dateTimeParser().parseDateTime(evjson.optString("date_to")) : (Intrinsics.areEqual(t, "date_admission") ? ISODateTimeFormat.dateTimeParser().parseDateTime((string = evjson.optString("date_admission")) == null ? evjson.getString("date_from") : string) : (DateTime)null));
                }
                return dateTime;
            }
        });
        return jsonLogic;
    }

    @ExperimentalUnsignedTypes
    private final SignedTicketData decodePretixSig1(String qrcode) {
        JSONArray jSONArray;
        byte by;
        byte[] rawbytes = null;
        try {
            String string = qrcode;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.reversed((CharSequence)string2)).toString();
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
            by = 0;
            String string3 = string;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = Base64.decodeBase64(byArray);
            Intrinsics.checkNotNullExpressionValue(byArray2, "decodeBase64(qrcode.reve\u2026harset.defaultCharset()))");
            rawbytes = byArray2;
        }
        catch (Exception e) {
            return null;
        }
        if (rawbytes.length == 0) {
            return null;
        }
        byte by2 = rawbytes[0];
        byte by3 = 0;
        by2 = UByte.constructor-impl(by2);
        by3 = 0;
        int version = by2 & 0xFF;
        if (version != 1) {
            return null;
        }
        by3 = rawbytes[1];
        by = 0;
        by3 = UByte.constructor-impl(by3);
        by = 0;
        int n = (by3 & 0xFF) << 2;
        by3 = rawbytes[2];
        by = 0;
        by3 = UByte.constructor-impl(by3);
        by = 0;
        int payloadLength = n + (by3 & 0xFF);
        by = rawbytes[3];
        boolean bl = false;
        by = UByte.constructor-impl(by);
        bl = false;
        int n2 = (by & 0xFF) << 2;
        by = rawbytes[4];
        bl = false;
        by = UByte.constructor-impl(by);
        bl = false;
        int signatureLength = n2 + (by & 0xFF);
        byte[] byArray = rawbytes;
        int n3 = 5;
        int n4 = 5 + payloadLength;
        int n5 = 0;
        byte[] payload = ArraysKt.copyOfRange(byArray, n3, n4);
        byte[] byArray3 = rawbytes;
        n4 = 5 + payloadLength;
        n5 = 5 + payloadLength + signatureLength;
        boolean bl2 = false;
        byte[] signature2 = ArraysKt.copyOfRange(byArray3, n4, n5);
        JSONObject jSONObject = this.getEvent().getValidKeys();
        JSONArray jSONArray2 = jSONArray = jSONObject == null ? null : jSONObject.optJSONArray("pretix_sig1");
        if (jSONArray == null) {
            return null;
        }
        int n6 = 0;
        JSONArray validKeys = jSONArray;
        int n7 = validKeys.length();
        if (n6 < n7) {
            do {
                int vki = n6++;
                String vk = validKeys.getString(vki);
                Intrinsics.checkNotNullExpressionValue(vk, "vk");
                Object object = vk;
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
                boolean bl3 = false;
                byte[] byArray4 = ((String)object).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue(byArray4, "(this as java.lang.String).getBytes(charset)");
                byte[] byArray5 = Base64.decodeBase64(byArray4);
                Intrinsics.checkNotNullExpressionValue(byArray5, "decodeBase64(vk.toByteAr\u2026harset.defaultCharset()))");
                object = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue(object, "defaultCharset()");
                boolean bl4 = false;
                bl3 = false;
                if (!eu.pretix.libpretixsync.crypto.UtilsKt.isValidSignature(payload, signature2, eu.pretix.libpretixsync.crypto.UtilsKt.readPubkeyFromPem(new String(byArray5, (Charset)object)))) continue;
                TicketProtos.Ticket ticket = TicketProtos.Ticket.parseFrom(payload);
                object = ticket.getSeed();
                Intrinsics.checkNotNullExpressionValue(object, "ticket.seed");
                return new SignedTicketData((String)object, ticket.getItem(), ticket.getVariation(), ticket.getSubevent());
            } while (n6 < n7);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final TicketCheckProvider.CheckResult checkOfflineWithoutData(CheckInList list, String ticketid, TicketCheckProvider.CheckInType type, List<Answer> answers) {
        block41: {
            block39: {
                block40: {
                    dt = this.now();
                    decoded = this.decodePretixSig1(ticketid);
                    if (decoded == null) {
                        AsyncCheckProvider.storeFailedCheckin$default(this, "invalid", ticketid, type, null, null, null, null, 120, null);
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID);
                    }
                    is_revoked = (Integer)((Scalar)this.dataStore.count(RevokedTicketSecret.class).where((Condition)RevokedTicketSecret.SECRET.eq((Object)ticketid)).get()).value();
                    Intrinsics.checkNotNullExpressionValue(is_revoked, "is_revoked");
                    if (is_revoked > 0) {
                        AsyncCheckProvider.storeFailedCheckin$default(this, "revoked", ticketid, type, null, null, null, null, 120, null);
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.REVOKED);
                    }
                    if (!list.all_items) {
                        v0 = this.dataStore.count(CheckInList_Item.class).leftJoin(Item.class);
                        var9_8 = Item.ID;
                        Intrinsics.checkNotNullExpressionValue(var9_8, "ID");
                        v1 = is_in_list = (Integer)((Scalar)((WhereAndOr)v0.on((Condition)CheckInList_Item.ITEM_ID.eq(var9_8)).where((Condition)Item.SERVER_ID.eq((Object)decoded.getItem())).and((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId()))).get()).value();
                        var9_9 = false;
                        if (v1 != null && v1.intValue() == 0) {
                            AsyncCheckProvider.storeFailedCheckin$default(this, "product", ticketid, type, null, null, null, decoded.getSubevent(), 56, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.PRODUCT);
                        }
                    }
                    if (list.getSubevent_id() != null) {
                        is_in_list = list.getSubevent_id();
                        Intrinsics.checkNotNullExpressionValue(is_in_list, "list.getSubevent_id()");
                        if (((Number)is_in_list).longValue() > 0L && !Intrinsics.areEqual(list.getSubevent_id(), decoded.getSubevent())) {
                            AsyncCheckProvider.storeFailedCheckin$default(this, "invalid", ticketid, type, null, null, null, null, 120, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID);
                        }
                    }
                    if ((item = (Item)((Result)((WhereAndOr)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.eq((Object)decoded.getItem())).and((Condition)Item.EVENT_SLUG.eq((Object)this.eventSlug))).get()).firstOrNull()) == null) {
                        AsyncCheckProvider.storeFailedCheckin$default(this, "product", ticketid, type, null, null, null, decoded.getSubevent(), 56, null);
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Item not found");
                    }
                    res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR);
                    res.setScanType(type);
                    res.setTicket(item.getInternalName());
                    if (decoded.getVariation() != null && decoded.getVariation() > 0L) {
                        try {
                            var = item.getVariation(decoded.getVariation());
                            if (var != null) {
                                res.setVariation(var.getStringValue());
                            }
                        }
                        catch (JSONException e) {
                            this.sentry.captureException(e);
                        }
                    }
                    require_attention = false;
                    try {
                        require_attention = item.getJSON().optBoolean("checkin_attention", false);
                    }
                    catch (JSONException e) {
                        this.sentry.captureException(e);
                    }
                    res.setRequireAttention(require_attention);
                    var12_17 = ((Result)this.dataStore.select(QueuedCheckIn.class, new QueryAttribute[0]).where((Condition)QueuedCheckIn.SECRET.eq((Object)ticketid)).get()).toList();
                    Intrinsics.checkNotNullExpressionValue(var12_17, "dataStore.select(QueuedC\u2026          .get().toList()");
                    $this$filter$iv = (Function1[])var12_17;
                    $i$f$filter = false;
                    var14_21 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (QueuedCheckIn)element$iv$iv;
                        $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$queuedCheckIns$1 = false;
                        v2 = it.getCheckinListId();
                        var21_46 = this.listId;
                        if (!(v2 != null && v2 == var21_46)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = new Function1[]{checkOfflineWithoutData.queuedCheckIns.2.INSTANCE, checkOfflineWithoutData.queuedCheckIns.3.INSTANCE};
                    queuedCheckIns = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$filter$iv));
                    rules = list.getRules();
                    if (type == TicketCheckProvider.CheckInType.ENTRY && rules != null && rules.length() > 0) {
                        $this$filterTo$iv$iv = false;
                        data = new LinkedHashMap<K, V>();
                        tz = DateTimeZone.forID(this.getEvent().getTimezone());
                        $i$f$filterTo = decoded.getSubevent();
                        v3 = $i$f$filterTo == null ? 0L : $i$f$filterTo.longValue();
                        Intrinsics.checkNotNullExpressionValue(tz, "tz");
                        jsonLogic = this.initJsonLogic(v3, tz);
                        data.put("product", String.valueOf(item.getServer_id()));
                        data.put("variation", decoded.getVariation() != null && decoded.getVariation() > 0L ? decoded.getVariation().toString() : "");
                        data.put("now", dt);
                        data.put("now_isoweekday", dt.withZone(tz).dayOfWeek().get());
                        $i$f$filterTo = queuedCheckIns;
                        var27_54 = "entries_number";
                        var26_55 = data;
                        $i$f$filter = false;
                        element$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var28_62 = (List)destination$iv$iv /* !! */ ;
                        var26_55.put(var27_54, var28_62.size());
                        $this$filter$iv = queuedCheckIns;
                        var27_54 = "entries_today";
                        var26_55 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$2 = false;
                            if (!(Intrinsics.areEqual(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate(), dt.withZone(tz).toLocalDate()) != false && Intrinsics.areEqual(it.type, "entry") != false)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var28_62 = (List)destination$iv$iv /* !! */ ;
                        var26_55.put(var27_54, var28_62.size());
                        $this$filter$iv = queuedCheckIns;
                        var27_54 = "entries_days";
                        var26_55 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$3 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var28_62 = (List)destination$iv$iv /* !! */ ;
                        $this$filter$iv = var28_62;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (Iterator<T> item$iv$iv : $this$mapTo$iv$iv) {
                            it = (QueuedCheckIn)item$iv$iv;
                            var28_62 = destination$iv$iv /* !! */ ;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithoutData$4 = false;
                            var29_63 = new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate();
                            var28_62.add(var29_63);
                        }
                        var28_62 = (List)destination$iv$iv /* !! */ ;
                        var26_55.put(var27_54, CollectionsKt.toHashSet((Iterable)var28_62).size());
                        $this$filter$iv = queuedCheckIns;
                        $i$f$filter = false;
                        destination$iv$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        item$iv$iv = $this$filterTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            element$iv$iv = item$iv$iv.next();
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$minutes_since_entries$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        item$iv$iv = $this$mapTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            item$iv$iv = item$iv$iv.next();
                            it = (QueuedCheckIn)item$iv$iv;
                            var26_55 = destination$iv$iv;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithoutData$minutes_since_entries$2 = false;
                            var27_54 = new Duration(new DateTime(it.getFullDatetime()).withZone(tz), dt).toStandardMinutes().getMinutes();
                            var26_55.add(var27_54);
                        }
                        minutes_since_entries = (List)destination$iv$iv;
                        $this$map$iv = (Integer)CollectionsKt.minOrNull(minutes_since_entries);
                        data.put("minutes_since_last_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        $this$map$iv = (Integer)CollectionsKt.maxOrNull(minutes_since_entries);
                        data.put("minutes_since_first_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        if (!UtilsKt.getTruthy(jsonLogic.applyString(rules.toString(), data, true))) {
                            res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                            res.setCheckinAllowed(false);
                            AsyncCheckProvider.storeFailedCheckin$default(this, "rules", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), 8, null);
                            return res;
                        }
                    }
                    questions = item.getQuestions();
                    jsonLogic = false;
                    answerMap = new LinkedHashMap<K, V>();
                    if (answers != null) {
                        for (Answer a : answers) {
                            $this$map$iv = answerMap;
                            $i$f$map = ((Question)a.getQuestion()).getServer_id();
                            Intrinsics.checkNotNullExpressionValue($i$f$map, "a.question as Question).getServer_id()");
                            $this$mapTo$iv$iv = a.getValue();
                            destination$iv$iv = false;
                            $this$map$iv.put($i$f$map, $this$mapTo$iv$iv);
                        }
                    }
                    givenAnswers = new JSONArray();
                    required_answers = new ArrayList<E>();
                    ask_questions = false;
                    if (type != TicketCheckProvider.CheckInType.EXIT) {
                        for (Question q : questions) {
                            if (!q.isAskDuringCheckin()) continue;
                            answer = "";
                            if (answerMap.containsKey(q.getServer_id())) {
                                answer = (String)answerMap.get(q.getServer_id());
                                try {
                                    answer = q.clean_answer(answer, q.getOptions());
                                    jo = new JSONObject();
                                    jo.put("answer", answer);
                                    item$iv$iv = q.getServer_id();
                                    Intrinsics.checkNotNullExpressionValue(item$iv$iv, "q.getServer_id()");
                                    jo.put("question", ((Number)item$iv$iv).longValue());
                                    givenAnswers.put(jo);
                                }
                                catch (QuestionLike.ValidationException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                                catch (JSONException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                            } else {
                                ask_questions = true;
                            }
                            Intrinsics.checkNotNullExpressionValue(q, "q");
                            required_answers.add(new TicketCheckProvider.RequiredAnswer(q, answer));
                        }
                    }
                    if (!ask_questions || required_answers.size() <= 0) break block40;
                    res.setCheckinAllowed(true);
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    res.setRequiredAnswers(required_answers);
                    break block41;
                }
                if (type == TicketCheckProvider.CheckInType.EXIT || list.isAllowMultipleEntries() || queuedCheckIns.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = queuedCheckIns;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v4 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (QueuedCheckIn)element$iv;
                        $i$a$-all-AsyncCheckProvider$checkOfflineWithoutData$entry_allowed$1 = false;
                        if (Intrinsics.areEqual(it.type, "exit")) continue;
                        v4 = false;
                        break block39;
                    }
                    v4 = true;
                }
            }
            if (v4 || list.isAllowEntryAfterExit() && Intrinsics.areEqual(((QueuedCheckIn)CollectionsKt.last(queuedCheckIns)).type, "exit")) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = entry_allowed = false;
            }
            if (!entry_allowed) {
                res.setCheckinAllowed(false);
                res.setFirstScanned(((QueuedCheckIn)CollectionsKt.first(queuedCheckIns)).getFullDatetime());
                res.setType(TicketCheckProvider.CheckResult.Type.USED);
                AsyncCheckProvider.storeFailedCheckin$default(this, "already_redeemed", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), 8, null);
            } else {
                res.setCheckinAllowed(true);
                res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                qci = new QueuedCheckIn();
                qci.generateNonce();
                qci.setSecret(ticketid);
                qci.setDatetime(dt.toDate());
                qci.setDatetime_string(QueuedCheckIn.formatDatetime(dt.toDate()));
                qci.setAnswers(givenAnswers.toString());
                qci.setEvent_slug(this.eventSlug);
                var20_45 = type.toString();
                var21_53 = false;
                v6 = var20_45;
                if (v6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v7 = v6.toLowerCase();
                Intrinsics.checkNotNullExpressionValue(v7, "(this as java.lang.String).toLowerCase()");
                qci.setType(v7);
                qci.setCheckinListId(this.listId);
                this.dataStore.insert(qci);
            }
        }
        return res;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull String ticketid) {
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        return this.check(ticketid, new ArrayList(), false, true, TicketCheckProvider.CheckInType.ENTRY);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull String ticketid, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean with_badge_data, @NotNull TicketCheckProvider.CheckInType type) {
        block46: {
            block44: {
                block45: {
                    Intrinsics.checkNotNullParameter(ticketid, "ticketid");
                    Intrinsics.checkNotNullParameter((Object)type, "type");
                    this.sentry.addBreadcrumb("provider.check", "offline check started");
                    dt = this.now();
                    var8_7 = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)this.listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)this.eventSlug))).get()).firstOrNull();
                    if (var8_7 == null) {
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not found");
                    }
                    list = var8_7;
                    v0 = this.dataStore.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class);
                    var9_9 = OrderPosition.ORDER_ID;
                    Intrinsics.checkNotNullExpressionValue(var9_9, "ORDER_ID");
                    tickets = ((Result)((WhereAndOr)v0.on((Condition)Order.ID.eq((Expression)var9_9)).where((Condition)OrderPosition.SECRET.eq((Object)ticketid)).and((Condition)Order.EVENT_SLUG.eq((Object)this.eventSlug))).get()).toList();
                    if (tickets.size() == 0) {
                        var9_9 = answers;
                        return this.checkOfflineWithoutData(list, ticketid, type, (List<Answer>)(var9_9 == null ? CollectionsKt.emptyList() : var9_9));
                    }
                    position = (OrderPosition)tickets.get(0);
                    item = position.getItem();
                    order = position.getOrder();
                    jPosition = null;
                    try {
                        var13_13 = position.getJSON();
                        Intrinsics.checkNotNullExpressionValue(var13_13, "{\n            position.json\n        }");
                    }
                    catch (JSONException e) {
                        this.sentry.captureException(e);
                        this.storeFailedCheckin("error", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR);
                    }
                    jPosition = var13_13;
                    res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR);
                    res.setScanType(type);
                    res.setTicket(position.getItem().getInternalName());
                    varid = position.getVariationId();
                    if (varid != null) {
                        try {
                            var = item.getVariation(varid);
                            if (var != null) {
                                res.setVariation(var.getStringValue());
                            }
                        }
                        catch (JSONException e) {
                            this.sentry.captureException(e);
                        }
                    }
                    res.setAttendee_name(position.attendee_name);
                    res.setSeat(position.getSeatName());
                    res.setOrderCode(position.getOrder().getCode());
                    res.setPositionId(position.getPositionid());
                    res.setPosition(jPosition);
                    require_attention = position.getOrder().isCheckin_attention();
                    try {
                        require_attention = require_attention != false || item.getJSON().optBoolean("checkin_attention", false) != false;
                    }
                    catch (JSONException e) {
                        this.sentry.captureException(e);
                    }
                    res.setRequireAttention(require_attention);
                    storedCheckIns = ((Result)this.dataStore.select(CheckIn.class, new QueryAttribute[0]).where((Condition)CheckIn.POSITION_ID.eq(position.getId())).get()).toList();
                    Intrinsics.checkNotNullExpressionValue(storedCheckIns, "storedCheckIns");
                    $this$filter$iv = (Function1[])storedCheckIns;
                    $i$f$filter = false;
                    var20_25 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (CheckIn)element$iv$iv;
                        $i$a$-filter-AsyncCheckProvider$check$checkIns$1 = false;
                        v1 = it.getListId();
                        var27_47 = this.listId;
                        if (!(v1 != null && v1 == var27_47)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = new Function1[]{check.checkIns.2.INSTANCE, check.checkIns.3.INSTANCE};
                    checkIns = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$filter$iv));
                    if (!Intrinsics.areEqual(order.getStatus(), "p") && !Intrinsics.areEqual(order.getStatus(), "n")) {
                        res.setType(TicketCheckProvider.CheckResult.Type.CANCELED);
                        res.setCheckinAllowed(false);
                        this.storeFailedCheckin("canceled", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return res;
                    }
                    if (!list.all_items) {
                        v2 = is_in_list = (Integer)((Scalar)((WhereAndOr)this.dataStore.count(CheckInList_Item.class).where((Condition)CheckInList_Item.ITEM_ID.eq((Object)item.getId())).and((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId()))).get()).value();
                        $i$f$filter = false;
                        if (v2 != null && v2.intValue() == 0) {
                            this.storeFailedCheckin("product", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.PRODUCT);
                        }
                    }
                    if (list.getSubevent_id() != null) {
                        is_in_list = list.getSubevent_id();
                        Intrinsics.checkNotNullExpressionValue(is_in_list, "list.getSubevent_id()");
                        if (((Number)is_in_list).longValue() > 0L && !Intrinsics.areEqual(list.getSubevent_id(), position.getSubeventId())) {
                            this.storeFailedCheckin("invalid", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID);
                        }
                    }
                    if (!(Intrinsics.areEqual(order.getStatus(), "p") || ignore_unpaid && list.include_pending)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.UNPAID);
                        res.setCheckinAllowed(list.include_pending);
                        this.storeFailedCheckin("unpaid", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                        return res;
                    }
                    rules = list.getRules();
                    if (type == TicketCheckProvider.CheckInType.ENTRY && rules != null && rules.length() > 0) {
                        $this$filterTo$iv$iv = false;
                        data = new LinkedHashMap<K, V>();
                        tz = DateTimeZone.forID(this.getEvent().getTimezone());
                        $i$f$filterTo = position.getSubevent_id();
                        Intrinsics.checkNotNullExpressionValue($i$f$filterTo, "position.getSubevent_id()");
                        v3 = ((Number)$i$f$filterTo).longValue();
                        Intrinsics.checkNotNullExpressionValue(tz, "tz");
                        jsonLogic = this.initJsonLogic(v3, tz);
                        data.put("product", String.valueOf(position.getItem().getServer_id()));
                        data.put("variation", String.valueOf(position.getVariation_id()));
                        data.put("now", dt);
                        data.put("now_isoweekday", dt.withZone(tz).dayOfWeek().get());
                        $i$f$filterTo = checkIns;
                        var33_57 = "entries_number";
                        var32_58 = data;
                        $i$f$filter = false;
                        element$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var34_66 = (List)destination$iv$iv /* !! */ ;
                        var32_58.put(var33_57, var34_66.size());
                        $this$filter$iv = checkIns;
                        var33_57 = "entries_today";
                        var32_58 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$2 = false;
                            if (!(Intrinsics.areEqual(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate(), dt.withZone(tz).toLocalDate()) != false && Intrinsics.areEqual(it.type, "entry") != false)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var34_66 = (List)destination$iv$iv /* !! */ ;
                        var32_58.put(var33_57, var34_66.size());
                        $this$filter$iv = checkIns;
                        var33_57 = "entries_days";
                        var32_58 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$3 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var34_66 = (List)destination$iv$iv /* !! */ ;
                        $this$filter$iv = var34_66;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (Iterator<T> item$iv$iv : $this$mapTo$iv$iv) {
                            it = (CheckIn)item$iv$iv;
                            var34_66 = destination$iv$iv /* !! */ ;
                            $i$a$-map-AsyncCheckProvider$check$4 = false;
                            var35_67 = new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate();
                            var34_66.add(var35_67);
                        }
                        var34_66 = (List)destination$iv$iv /* !! */ ;
                        var32_58.put(var33_57, CollectionsKt.toHashSet((Iterable)var34_66).size());
                        $this$filter$iv = checkIns;
                        $i$f$filter = false;
                        destination$iv$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        item$iv$iv = $this$filterTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            element$iv$iv = item$iv$iv.next();
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$check$minutes_since_entries$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        item$iv$iv = $this$mapTo$iv$iv.iterator();
                        while (item$iv$iv.hasNext()) {
                            item$iv$iv = item$iv$iv.next();
                            it = (CheckIn)item$iv$iv;
                            var32_58 = destination$iv$iv;
                            $i$a$-map-AsyncCheckProvider$check$minutes_since_entries$2 = false;
                            var33_57 = new Duration(new DateTime(it.getFullDatetime()).withZone(tz), dt).toStandardMinutes().getMinutes();
                            var32_58.add(var33_57);
                        }
                        minutes_since_entries = (List)destination$iv$iv;
                        $this$map$iv = (Integer)CollectionsKt.minOrNull(minutes_since_entries);
                        data.put("minutes_since_last_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        $this$map$iv = (Integer)CollectionsKt.maxOrNull(minutes_since_entries);
                        data.put("minutes_since_first_entry", $this$map$iv == null ? -1 : $this$map$iv.intValue());
                        if (!UtilsKt.getTruthy(jsonLogic.applyString(rules.toString(), data, true))) {
                            res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                            res.setCheckinAllowed(false);
                            this.storeFailedCheckin("rules", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
                            return res;
                        }
                    }
                    questions = item.getQuestions();
                    answerMap = position.getAnswers();
                    if (answers != null) {
                        for (Answer a : answers) {
                            Intrinsics.checkNotNullExpressionValue(answerMap, "answerMap");
                            $this$map$iv = answerMap;
                            $i$f$map = ((Question)a.getQuestion()).getServer_id();
                            $this$mapTo$iv$iv = a.getValue();
                            destination$iv$iv = false;
                            $this$map$iv.put((Long)$i$f$map, (String)$this$mapTo$iv$iv);
                        }
                    }
                    givenAnswers = new JSONArray();
                    required_answers = new ArrayList<E>();
                    ask_questions = false;
                    if (type != TicketCheckProvider.CheckInType.EXIT) {
                        for (Question q : questions) {
                            if (!q.isAskDuringCheckin()) continue;
                            answer = "";
                            if (answerMap.containsKey(q.getServer_id())) {
                                answer = answerMap.get(q.getServer_id());
                                try {
                                    answer = q.clean_answer(answer, q.getOptions());
                                    jo = new JSONObject();
                                    jo.put("answer", answer);
                                    item$iv$iv = q.getServer_id();
                                    Intrinsics.checkNotNullExpressionValue(item$iv$iv, "q.getServer_id()");
                                    jo.put("question", ((Number)item$iv$iv).longValue());
                                    givenAnswers.put(jo);
                                }
                                catch (QuestionLike.ValidationException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                                catch (JSONException e) {
                                    answer = "";
                                    ask_questions = true;
                                }
                            } else {
                                ask_questions = true;
                            }
                            Intrinsics.checkNotNullExpressionValue(q, "q");
                            required_answers.add(new TicketCheckProvider.RequiredAnswer(q, answer));
                        }
                    }
                    if (!ask_questions || required_answers.size() <= 0) break block45;
                    res.setCheckinAllowed(true);
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    res.setRequiredAnswers(required_answers);
                    break block46;
                }
                if (type == TicketCheckProvider.CheckInType.EXIT || list.isAllowMultipleEntries() || checkIns.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = checkIns;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v4 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (CheckIn)element$iv;
                        $i$a$-all-AsyncCheckProvider$check$entry_allowed$1 = false;
                        if (Intrinsics.areEqual(it.type, "exit")) continue;
                        v4 = false;
                        break block44;
                    }
                    v4 = true;
                }
            }
            if (v4 || list.isAllowEntryAfterExit() && Intrinsics.areEqual(((CheckIn)CollectionsKt.last(checkIns)).type, "exit")) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = entry_allowed = false;
            }
            if (!entry_allowed) {
                res.setCheckinAllowed(false);
                res.setFirstScanned(((CheckIn)CollectionsKt.first(checkIns)).getFullDatetime());
                res.setType(TicketCheckProvider.CheckResult.Type.USED);
                this.storeFailedCheckin("already_redeemed", ticketid, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id());
            } else {
                res.setCheckinAllowed(true);
                res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                qci = new QueuedCheckIn();
                qci.generateNonce();
                qci.setSecret(ticketid);
                qci.setDatetime(dt.toDate());
                qci.setDatetime_string(QueuedCheckIn.formatDatetime(dt.toDate()));
                qci.setAnswers(givenAnswers.toString());
                qci.setEvent_slug(this.eventSlug);
                $i$f$all = type.toString();
                var27_54 = false;
                v6 = $i$f$all;
                if (v6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v7 = v6.toLowerCase();
                Intrinsics.checkNotNullExpressionValue(v7, "(this as java.lang.String).toLowerCase()");
                qci.setType(v7);
                qci.setCheckinListId(this.listId);
                this.dataStore.insert(qci);
                ci = new CheckIn();
                ci.setListId(this.listId);
                ci.setPosition(position);
                var27_55 = type.toString();
                var28_60 = false;
                v8 = var27_55;
                if (v8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v9 = v8.toLowerCase();
                Intrinsics.checkNotNullExpressionValue(v9, "(this as java.lang.String).toLowerCase()");
                ci.setType(v9);
                ci.setDatetime(dt.toDate());
                v10 = new StringBuilder().append("{\"local\": true, \"type\": \"");
                var27_55 = type.toString();
                var28_60 = false;
                v11 = var27_55;
                if (v11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v12 = v11.toLowerCase();
                Intrinsics.checkNotNullExpressionValue(v12, "(this as java.lang.String).toLowerCase()");
                ci.setJson_data(v10.append(v12).append("\", \"datetime\": \"").append((Object)QueuedCheckIn.formatDatetime(dt.toDate())).append("\"}").toString());
                this.dataStore.insert(ci);
            }
        }
        return res;
    }

    @Override
    @NotNull
    public List<TicketCheckProvider.SearchResult> search(@NotNull String query, int page) throws CheckException {
        Intrinsics.checkNotNullParameter(query, "query");
        String query2 = query;
        this.sentry.addBreadcrumb("provider.search", "offline search started");
        List results = new ArrayList();
        if (query2.length() < 4) {
            return results;
        }
        CheckInList checkInList = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)this.listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)this.eventSlug))).get()).firstOrNull();
        if (checkInList == null) {
            throw new CheckException("Check-in list not found", null, 2, null);
        }
        CheckInList list = checkInList;
        List positions = null;
        Condition search = null;
        Object object = query2;
        boolean bl = false;
        String string = ((String)object).toUpperCase();
        Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.String).toUpperCase()");
        query2 = string;
        object = ((LogicalCondition)((LogicalCondition)((LogicalCondition)OrderPosition.SECRET.upper().like(Intrinsics.stringPlus(query2, "%")).or((Condition)OrderPosition.ATTENDEE_NAME.upper().like('%' + query2 + '%'))).or((Condition)OrderPosition.ATTENDEE_EMAIL.upper().like('%' + query2 + '%'))).or((Condition)Order.EMAIL.upper().like('%' + query2 + '%'))).or((Condition)Order.CODE.upper().like(Intrinsics.stringPlus(query2, "%")));
        Intrinsics.checkNotNullExpressionValue(object, "SECRET.upper().like(\"$qu\u2026.upper().like(\"$query%\"))");
        search = (Condition)object;
        if (!list.all_items) {
            List itemids = new ArrayList();
            for (Item item : list.getItems()) {
                Long l = item.getId();
                Intrinsics.checkNotNullExpressionValue(l, "item.getId()");
                itemids.add(l);
            }
            search = (Condition)Item.ID.in((Collection)itemids).and(search);
        }
        search = (Condition)Order.EVENT_SLUG.eq((Object)this.eventSlug).and(search);
        if (list.getSubevent_id() != null) {
            object = list.getSubevent_id();
            Intrinsics.checkNotNullExpressionValue(object, "list.getSubevent_id()");
            if (((Number)object).longValue() > 0L) {
                search = (Condition)OrderPosition.SUBEVENT_ID.eq((Object)list.getSubevent_id()).and(search);
            }
        }
        JoinOn joinOn = this.dataStore.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class);
        QueryExpression<Long> queryExpression = OrderPosition.ORDER_ID;
        Intrinsics.checkNotNullExpressionValue(queryExpression, "ORDER_ID");
        JoinOn joinOn2 = joinOn.on((Condition)Order.ID.eq(queryExpression)).leftJoin(Item.class);
        QueryExpression<Long> queryExpression2 = OrderPosition.ITEM_ID;
        Intrinsics.checkNotNullExpressionValue(queryExpression2, "ITEM_ID");
        Object e = joinOn2.on((Condition)Item.ID.eq(queryExpression2)).where(search).limit(50).offset(50 * (page - 1)).get();
        if (e == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.requery.query.Result<eu.pretix.libpretixsync.db.OrderPosition>");
        }
        object = ((Result)e).toList();
        Intrinsics.checkNotNullExpressionValue(object, "dataStore.select(OrderPo\u2026<OrderPosition>).toList()");
        positions = object;
        for (OrderPosition position : positions) {
            Item item = position.getItem();
            Order order = position.getOrder();
            TicketCheckProvider.SearchResult sr = new TicketCheckProvider.SearchResult();
            sr.setTicket(item.getInternalName());
            try {
                if (position.getVariationId() != null) {
                    Serializable serializable = position.getVariationId();
                    Intrinsics.checkNotNullExpressionValue(serializable, "position.variationId");
                    if (((Number)serializable).longValue() > 0L) {
                        serializable = item.getVariation(position.getVariationId());
                        sr.setVariation(serializable == null ? null : ((ItemVariation)serializable).getStringValue());
                    }
                }
            }
            catch (JSONException e2) {
                this.sentry.captureException(e2);
            }
            sr.setAttendee_name(position.attendee_name);
            sr.setSeat(position.getSeatName());
            sr.setOrderCode(order.getCode());
            sr.setPositionId(position.getPositionid());
            sr.setSecret(position.getSecret());
            long queuedCheckIns2 = ((Number)((Scalar)((WhereAndOr)this.dataStore.count(QueuedCheckIn.class).where((Condition)QueuedCheckIn.SECRET.eq((Object)position.getSecret())).and((Condition)QueuedCheckIn.CHECKIN_LIST_ID.eq((Object)this.listId))).get()).value()).intValue();
            boolean is_checked_in = queuedCheckIns2 > 0L;
            for (CheckIn ci : position.getCheckins()) {
                Long l = ci.getListId();
                long l2 = this.listId;
                if (l == null || l != l2) continue;
                is_checked_in = true;
                break;
            }
            sr.setRedeemed(is_checked_in);
            if (Intrinsics.areEqual(order.getStatus(), "p")) {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.PAID);
            } else if (Intrinsics.areEqual(order.getStatus(), "n")) {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.PENDING);
            } else {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.CANCELED);
            }
            boolean require_attention = position.getOrder().isCheckin_attention();
            try {
                require_attention = require_attention || item.getJSON().optBoolean("checkin_attention", false);
            }
            catch (JSONException e3) {
                this.sentry.captureException(e3);
            }
            sr.setRequireAttention(require_attention);
            sr.setPosition(position.getJSON());
            results.add(sr);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final WhereAndOr<? extends Scalar<Integer>> basePositionQuery(CheckInList list, boolean onlyCheckedIn) {
        Object object;
        Object object2;
        List status = new ArrayList();
        status.add("p");
        if (list.include_pending) {
            status.add("n");
        }
        WhereAndOr q = (WhereAndOr)((DistinctSelection)this.dataStore.count(OrderPosition.class).distinct()).leftJoin(Order.class).on((Condition)OrderPosition.ORDER_ID.eq((Expression)Order.ID)).where((Condition)Order.EVENT_SLUG.eq((Object)this.eventSlug)).and((Condition)Order.STATUS.in((Collection)status));
        if (list.getSubevent_id() != null) {
            object2 = list.getSubevent_id();
            Intrinsics.checkNotNullExpressionValue(object2, "list.getSubevent_id()");
            if (((Number)object2).longValue() > 0L) {
                q = (WhereAndOr)q.and((Condition)OrderPosition.SUBEVENT_ID.eq((Object)list.getSubevent_id()));
            }
        }
        if (!list.isAll_items()) {
            void $this$mapTo$iv$iv;
            Expression[] expressionArray = new Expression[]{CheckInList_Item.ITEM_ID};
            object = ((Result)this.dataStore.select(expressionArray).where((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId())).get()).toList();
            Intrinsics.checkNotNullExpressionValue(object, "dataStore.select(CheckIn\u2026          .get().toList()");
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tuple tuple = (Tuple)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Long l = (Long)it.get(0);
                collection.add(l);
            }
            List product_ids = (List)destination$iv$iv;
            q = (WhereAndOr)q.and((Condition)OrderPosition.ITEM_ID.in(product_ids));
        }
        if (onlyCheckedIn) {
            object = new Expression[]{CheckIn.POSITION_ID};
            object2 = this.dataStore.select((Expression<?>)object).where((Condition)CheckIn.LIST_ID.eq((Object)list.getServer_id())).and((Condition)CheckIn.TYPE.eq((Object)"entry"));
            Intrinsics.checkNotNullExpressionValue(object2, "dataStore.select(CheckIn\u2026CheckIn.TYPE.eq(\"entry\"))");
            q = (WhereAndOr)q.and((Condition)OrderPosition.ID.in((Return)object2));
        }
        object2 = q;
        Intrinsics.checkNotNullExpressionValue(object2, "q");
        return object2;
    }

    @Override
    @NotNull
    public TicketCheckProvider.StatusResult status() throws CheckException {
        List<Item> list;
        List<Item> list2;
        this.sentry.addBreadcrumb("provider.status", "offline status started");
        List items = new ArrayList();
        CheckInList checkInList = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)this.listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)this.eventSlug))).get()).firstOrNull();
        if (checkInList == null) {
            throw new CheckException("Check-in list not found", null, 2, null);
        }
        CheckInList list3 = checkInList;
        List<Item> products = null;
        if (list3.all_items) {
            list2 = ((Result)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.EVENT_SLUG.eq((Object)this.eventSlug)).get()).toList();
            Intrinsics.checkNotNullExpressionValue(list2, "{\n            dataStore.\u2026.get().toList()\n        }");
            list = list2;
        } else {
            list2 = list3.getItems();
            Intrinsics.checkNotNullExpressionValue(list2, "{\n            list.items\n        }");
            list = list2;
        }
        products = list;
        int sum_pos = 0;
        int sum_ci = 0;
        for (Item product : products) {
            List variations = new ArrayList();
            try {
                for (ItemVariation var : product.getVariations()) {
                    Object r = ((WhereAndOr)((WhereAndOr)this.basePositionQuery(list3, false).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).and((Condition)OrderPosition.VARIATION_ID.eq((Object)var.getServer_id()))).get();
                    Intrinsics.checkNotNull(r);
                    Object e = ((Scalar)r).value();
                    Intrinsics.checkNotNull(e);
                    int position_count = ((Number)e).intValue();
                    Object r2 = ((WhereAndOr)((WhereAndOr)this.basePositionQuery(list3, true).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).and((Condition)OrderPosition.VARIATION_ID.eq((Object)var.getServer_id()))).get();
                    Intrinsics.checkNotNull(r2);
                    Object e2 = ((Scalar)r2).value();
                    Intrinsics.checkNotNull(e2);
                    int ci_count = ((Number)e2).intValue();
                    Long l = var.getServer_id();
                    Intrinsics.checkNotNullExpressionValue(l, "`var`.server_id");
                    variations.add(new TicketCheckProvider.StatusResultItemVariation(((Number)l).longValue(), var.getStringValue(), position_count, ci_count));
                }
                Object r = ((WhereAndOr)this.basePositionQuery(list3, false).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).get();
                Intrinsics.checkNotNull(r);
                Object e = ((Scalar)r).value();
                Intrinsics.checkNotNull(e);
                int position_count = ((Number)e).intValue();
                Object r3 = ((WhereAndOr)this.basePositionQuery(list3, true).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).get();
                Intrinsics.checkNotNull(r3);
                Object e3 = ((Scalar)r3).value();
                Intrinsics.checkNotNull(e3);
                int ci_count = ((Number)e3).intValue();
                Long l = product.getServer_id();
                Intrinsics.checkNotNullExpressionValue(l, "product.getServer_id()");
                items.add(new TicketCheckProvider.StatusResultItem(((Number)l).longValue(), product.getInternalName(), position_count, ci_count, variations, product.isAdmission()));
                sum_pos += position_count;
                sum_ci += ci_count;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return new TicketCheckProvider.StatusResult(list3.name, sum_pos, sum_ci, null, items);
    }

    public final void setNow(@NotNull DateTime d) {
        Intrinsics.checkNotNullParameter(d, "d");
        this.overrideNow = d;
    }

    private final DateTime now() {
        DateTime dateTime = this.overrideNow;
        return dateTime == null ? new DateTime() : dateTime;
    }

    public static final /* synthetic */ BlockingEntityStore access$getDataStore$p(AsyncCheckProvider $this) {
        return $this.dataStore;
    }

    public static final /* synthetic */ String access$getEventSlug$p(AsyncCheckProvider $this) {
        return $this.eventSlug;
    }

    public static final /* synthetic */ DateTime access$now(AsyncCheckProvider $this) {
        return $this.now();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ:\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "", "seed", "", "item", "", "variation", "subevent", "(Ljava/lang/String;JLjava/lang/Long;Ljava/lang/Long;)V", "getItem", "()J", "getSeed", "()Ljava/lang/String;", "getSubevent", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getVariation", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;JLjava/lang/Long;Ljava/lang/Long;)Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "equals", "", "other", "hashCode", "", "toString", "libpretixsync"})
    public static final class SignedTicketData {
        @NotNull
        private final String seed;
        private final long item;
        @Nullable
        private final Long variation;
        @Nullable
        private final Long subevent;

        public SignedTicketData(@NotNull String seed, long item, @Nullable Long variation, @Nullable Long subevent) {
            Intrinsics.checkNotNullParameter(seed, "seed");
            this.seed = seed;
            this.item = item;
            this.variation = variation;
            this.subevent = subevent;
        }

        @NotNull
        public final String getSeed() {
            return this.seed;
        }

        public final long getItem() {
            return this.item;
        }

        @Nullable
        public final Long getVariation() {
            return this.variation;
        }

        @Nullable
        public final Long getSubevent() {
            return this.subevent;
        }

        @NotNull
        public final String component1() {
            return this.seed;
        }

        public final long component2() {
            return this.item;
        }

        @Nullable
        public final Long component3() {
            return this.variation;
        }

        @Nullable
        public final Long component4() {
            return this.subevent;
        }

        @NotNull
        public final SignedTicketData copy(@NotNull String seed, long item, @Nullable Long variation, @Nullable Long subevent) {
            Intrinsics.checkNotNullParameter(seed, "seed");
            return new SignedTicketData(seed, item, variation, subevent);
        }

        public static /* synthetic */ SignedTicketData copy$default(SignedTicketData signedTicketData, String string, long l, Long l2, Long l3, int n, Object object) {
            if ((n & 1) != 0) {
                string = signedTicketData.seed;
            }
            if ((n & 2) != 0) {
                l = signedTicketData.item;
            }
            if ((n & 4) != 0) {
                l2 = signedTicketData.variation;
            }
            if ((n & 8) != 0) {
                l3 = signedTicketData.subevent;
            }
            return signedTicketData.copy(string, l, l2, l3);
        }

        @NotNull
        public String toString() {
            return "SignedTicketData(seed=" + this.seed + ", item=" + this.item + ", variation=" + this.variation + ", subevent=" + this.subevent + ')';
        }

        public int hashCode() {
            int result2 = this.seed.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.item);
            result2 = result2 * 31 + (this.variation == null ? 0 : ((Object)this.variation).hashCode());
            result2 = result2 * 31 + (this.subevent == null ? 0 : ((Object)this.subevent).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SignedTicketData)) {
                return false;
            }
            SignedTicketData signedTicketData = (SignedTicketData)other;
            if (!Intrinsics.areEqual(this.seed, signedTicketData.seed)) {
                return false;
            }
            if (this.item != signedTicketData.item) {
                return false;
            }
            if (!Intrinsics.areEqual(this.variation, signedTicketData.variation)) {
                return false;
            }
            return Intrinsics.areEqual(this.subevent, signedTicketData.subevent);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TicketCheckProvider.CheckInType.values().length];
            nArray[TicketCheckProvider.CheckInType.ENTRY.ordinal()] = 1;
            nArray[TicketCheckProvider.CheckInType.EXIT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

