/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query.element;

import io.requery.query.Condition;
import io.requery.query.JoinAndOr;
import io.requery.query.JoinOn;
import io.requery.query.Return;
import io.requery.query.element.JoinConditionElement;
import io.requery.query.element.JoinType;
import io.requery.query.element.QueryElement;
import io.requery.util.Objects;
import java.util.LinkedHashSet;
import java.util.Set;

public class JoinOnElement<E>
implements JoinOn<E> {
    private final QueryElement<E> query;
    private final String table;
    private final Return<?> subQuery;
    private final JoinType joinType;
    private final Set<JoinConditionElement<E>> conditions;

    JoinOnElement(QueryElement<E> query, String table, JoinType joinType) {
        this.query = query;
        this.table = table;
        this.subQuery = null;
        this.joinType = joinType;
        this.conditions = new LinkedHashSet<JoinConditionElement<E>>();
    }

    JoinOnElement(QueryElement<E> query, Return subQuery, JoinType joinType) {
        this.query = query;
        this.subQuery = subQuery;
        this.joinType = joinType;
        this.table = null;
        this.conditions = new LinkedHashSet<JoinConditionElement<E>>();
    }

    public String tableName() {
        return this.table;
    }

    public Return<?> subQuery() {
        return this.subQuery;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    public Set<JoinConditionElement<E>> conditions() {
        return this.conditions;
    }

    @Override
    public <V> JoinAndOr<E> on(Condition<V, ?> condition) {
        JoinConditionElement<E> element = new JoinConditionElement<E>(this.query, this.conditions, condition, null);
        this.conditions.add(element);
        return element;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JoinOnElement) {
            JoinOnElement other = (JoinOnElement)obj;
            return Objects.equals(this.table, other.table) && Objects.equals((Object)this.joinType, (Object)other.joinType) && Objects.equals(this.conditions, other.conditions);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.table, this.joinType, this.conditions});
    }
}

