/*
 * Decompiled with CFR 0.152.
 */
package io.requery.meta;

import io.requery.meta.EntityModel;
import io.requery.meta.NotMappedException;
import io.requery.meta.Type;
import io.requery.util.ClassMap;
import io.requery.util.Objects;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

final class ImmutableEntityModel
implements EntityModel {
    private final String name;
    private final Map<Class<?>, Type<?>> map;

    ImmutableEntityModel(String name, Set<Type<?>> types) {
        this.name = name;
        ClassMap map = new ClassMap();
        for (Type<?> type2 : types) {
            map.put(type2.getClassType(), type2);
            map.put(type2.getBaseType(), type2);
        }
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> Type<T> typeOf(Class<? extends T> entityClass) {
        Type<?> type2 = this.map.get(entityClass);
        if (type2 == null) {
            throw new NotMappedException("No mapping for " + entityClass.getName());
        }
        return type2;
    }

    @Override
    public <T> boolean containsTypeOf(Class<? extends T> entityClass) {
        return this.map.containsKey(entityClass);
    }

    @Override
    public Set<Type<?>> getTypes() {
        return new LinkedHashSet(this.map.values());
    }

    public String toString() {
        return this.name + " : " + this.map.keySet().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityModel) {
            EntityModel other = (EntityModel)obj;
            return Objects.equals(this.name, other.getName()) && this.getTypes().equals(other.getTypes());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.map);
    }
}

