/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.EntityCache;
import io.requery.Transaction;
import io.requery.TransactionIsolation;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.sql.CompositeTransactionListener;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.ConnectionTransaction;
import io.requery.sql.EntityTransaction;
import io.requery.sql.ManagedTransaction;
import io.requery.sql.RuntimeConfiguration;
import io.requery.sql.TransactionMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

class ThreadLocalTransaction
implements EntityTransaction,
ConnectionProvider {
    private final ThreadLocal<EntityTransaction> threadLocal = new ThreadLocal();
    private final RuntimeConfiguration configuration;

    ThreadLocalTransaction(RuntimeConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Transaction begin() {
        return this.begin(this.configuration.getTransactionIsolation());
    }

    @Override
    public Transaction begin(TransactionIsolation isolation) {
        EntityTransaction transaction = this.threadLocal.get();
        if (transaction == null) {
            EntityCache cache2 = this.configuration.getCache();
            TransactionMode mode = this.configuration.getTransactionMode();
            CompositeTransactionListener listener = new CompositeTransactionListener(this.configuration.getTransactionListenerFactories());
            transaction = mode == TransactionMode.MANAGED ? new ManagedTransaction(listener, this.configuration, cache2) : new ConnectionTransaction(listener, this.configuration, cache2, mode != TransactionMode.NONE);
            this.threadLocal.set(transaction);
        }
        transaction.begin(isolation);
        return this;
    }

    @Override
    public void commit() {
        Transaction transaction = this.threadLocal.get();
        if (transaction == null) {
            throw new IllegalStateException();
        }
        transaction.commit();
    }

    @Override
    public void rollback() {
        Transaction transaction = this.threadLocal.get();
        if (transaction == null) {
            throw new IllegalStateException();
        }
        transaction.rollback();
    }

    @Override
    public boolean active() {
        Transaction transaction = this.threadLocal.get();
        return transaction != null && transaction.active();
    }

    @Override
    public void addToTransaction(EntityProxy<?> proxy) {
        EntityTransaction transaction = this.threadLocal.get();
        if (transaction != null) {
            transaction.addToTransaction(proxy);
        }
    }

    @Override
    public void addToTransaction(Collection<Type<?>> types) {
        EntityTransaction transaction = this.threadLocal.get();
        if (transaction != null) {
            transaction.addToTransaction(types);
        }
    }

    @Override
    public void close() {
        Transaction transaction = this.threadLocal.get();
        try {
            if (transaction != null) {
                transaction.close();
            }
        }
        finally {
            this.threadLocal.remove();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Transaction transaction = this.threadLocal.get();
        if (transaction instanceof ConnectionProvider) {
            return ((ConnectionProvider)((Object)transaction)).getConnection();
        }
        return null;
    }
}

