/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.crypto;

import eu.pretix.libpretixsync.utils.codec.binary.Base64;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"isValidSignature", "", "payload", "", "signature", "publicKey", "Lnet/i2p/crypto/eddsa/EdDSAPublicKey;", "readPubkeyFromPem", "pem", "", "libpretixsync"})
public final class UtilsKt {
    @NotNull
    public static final EdDSAPublicKey readPubkeyFromPem(@NotNull String pem) {
        Intrinsics.checkNotNullParameter(pem, "pem");
        EdDSANamedCurveSpec keySpecs = EdDSANamedCurveTable.getByName("Ed25519");
        String pubKeyPEM = StringsKt.replace$default(pem, "-----BEGIN PUBLIC KEY-----\n", "", false, 4, null);
        String string = pubKeyPEM = StringsKt.replace$default(pubKeyPEM, "-----END PUBLIC KEY-----", "", false, 4, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset()");
        boolean bl2 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        byte[] asn1Bytes = Base64.decodeBase64(byArray);
        Intrinsics.checkNotNullExpressionValue(asn1Bytes, "asn1Bytes");
        byte[] keyBytes = ArraysKt.sliceArray(asn1Bytes, new IntRange(12, 43));
        EdDSAPublicKeySpec keySpec = new EdDSAPublicKeySpec(keyBytes, (EdDSAParameterSpec)keySpecs);
        return new EdDSAPublicKey(keySpec);
    }

    public static final boolean isValidSignature(@NotNull byte[] payload, @NotNull byte[] signature2, @NotNull EdDSAPublicKey publicKey) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(publicKey, "publicKey");
        EdDSAEngine engine = new EdDSAEngine();
        engine.initVerify(publicKey);
        return engine.verifyOneShot(payload, signature2);
    }
}

