/*
 * Decompiled with CFR 0.152.
 */
package io.requery.cache;

import io.requery.EntityCache;
import io.requery.util.Objects;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class WeakEntityCache
implements EntityCache {
    private final Map<Class<?>, WeakReferenceMap<?>> maps = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> type2, Object key) {
        Map<Class<?>, WeakReferenceMap<?>> map = this.maps;
        synchronized (map) {
            WeakReferenceMap<?> map2 = this.maps.get(type2);
            if (map2 == null) {
                return null;
            }
            Object value = map2.getValue(key);
            return type2.cast(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(Class<T> type2, Object key, T value) {
        Objects.requireNotNull(type2);
        Map<Class<?>, WeakReferenceMap<?>> map = this.maps;
        synchronized (map) {
            WeakReferenceMap<Object> map2 = this.maps.get(type2);
            if (map2 == null) {
                map2 = new WeakReferenceMap();
                this.maps.put(type2, map2);
            }
            map2.putValue(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Class<?> type2, Object key) {
        Map<Class<?>, WeakReferenceMap<?>> map = this.maps;
        synchronized (map) {
            WeakReferenceMap<?> map2 = this.maps.get(type2);
            return map2 != null && map2.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Class<?> type2, Object key) {
        Map<Class<?>, WeakReferenceMap<?>> map = this.maps;
        synchronized (map) {
            WeakReferenceMap<?> map2 = this.maps.get(type2);
            if (map2 != null) {
                map2.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Class<?> type2) {
        Map<Class<?>, WeakReferenceMap<?>> map = this.maps;
        synchronized (map) {
            WeakReferenceMap<?> map2 = this.maps.get(type2);
            if (map2 != null) {
                map2.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<Class<?>, WeakReferenceMap<?>> map = this.maps;
        synchronized (map) {
            this.maps.clear();
        }
    }

    private static class WeakReferenceMap<T>
    extends HashMap<Object, Reference<T>> {
        private final ReferenceQueue<T> referenceQueue = new ReferenceQueue();

        private WeakReferenceMap() {
        }

        public T getValue(Object key) {
            this.removeStaleEntries();
            Reference ref = (Reference)this.get(key);
            return ref == null ? null : (T)ref.get();
        }

        public void putValue(Object key, T value) {
            this.removeStaleEntries();
            this.put(key, new KeyReference<T>(key, value, this.referenceQueue));
        }

        private void removeStaleEntries() {
            Reference<T> reference;
            while ((reference = this.referenceQueue.poll()) != null) {
                T value = reference.get();
                if (value != null) continue;
                Object key = ((KeyReference)reference).getKey();
                this.remove(key);
            }
        }
    }

    private static class KeyReference<S>
    extends WeakReference<S> {
        private final Object key;

        KeyReference(Object key, S value, ReferenceQueue<S> referenceQueue) {
            super(value, referenceQueue);
            Objects.requireNotNull(key);
            Objects.requireNotNull(value);
            this.key = key;
        }

        Object getKey() {
            return this.key;
        }
    }
}

